/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.util.ArrayList;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.literals.StringLiteral;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.interfaces.objects.SProfileDescriptor;
import org.bimserver.interfaces.objects.SServiceDescriptor;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.ServiceDescriptor;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;

public class Bimsie1RemoteServiceImpl
extends GenericServiceImpl
implements Bimsie1RemoteServiceInterface {
    private BimServer bimServer;

    public Bimsie1RemoteServiceImpl(BimServer bimServer, ServiceMap serviceMapInterface) {
        super(serviceMapInterface);
        this.bimServer = bimServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProfileDescriptor> getPublicProfiles(String serviceIdentifier) throws UserException, ServerException {
        ArrayList<SProfileDescriptor> descriptors = new ArrayList<SProfileDescriptor>();
        try (DatabaseSession session = this.getServiceMap().getBimServer().getDatabase().createSession();){
            IfcModelInterface modelInterface = session.getAllOfType(StorePackage.eINSTANCE.getInternalServicePluginConfiguration(), OldQuery.getDefault());
            for (InternalServicePluginConfiguration internalServicePluginConfiguration : modelInterface.getAll(InternalServicePluginConfiguration.class)) {
                if (!internalServicePluginConfiguration.isPublicProfile() || !serviceIdentifier.equals("" + internalServicePluginConfiguration.getOid())) continue;
                SProfileDescriptor sProfileDescriptor = new SProfileDescriptor();
                descriptors.add(sProfileDescriptor);
                sProfileDescriptor.setIdentifier("" + internalServicePluginConfiguration.getOid());
                sProfileDescriptor.setName(internalServicePluginConfiguration.getName());
                sProfileDescriptor.setDescription(internalServicePluginConfiguration.getDescription());
                sProfileDescriptor.setPublicProfile(false);
            }
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProfileDescriptor> getPrivateProfiles(String serviceIdentifier, String token) throws UserException, ServerException {
        ArrayList<SProfileDescriptor> descriptors = new ArrayList<SProfileDescriptor>();
        try (DatabaseSession session = this.getServiceMap().getBimServer().getDatabase().createSession();){
            AttributeCondition condition = new AttributeCondition(StorePackage.eINSTANCE.getUser_Token(), new StringLiteral(token));
            User user = session.querySingle(condition, User.class, OldQuery.getDefault());
            if (user != null) {
                for (InternalServicePluginConfiguration internalServicePluginConfiguration : user.getUserSettings().getServices()) {
                    if (!internalServicePluginConfiguration.getPluginDescriptor().getPluginClassName().equals(serviceIdentifier)) continue;
                    SProfileDescriptor sProfileDescriptor = new SProfileDescriptor();
                    descriptors.add(sProfileDescriptor);
                    sProfileDescriptor.setIdentifier("" + internalServicePluginConfiguration.getOid());
                    sProfileDescriptor.setName(internalServicePluginConfiguration.getName());
                    sProfileDescriptor.setDescription(internalServicePluginConfiguration.getDescription());
                    sProfileDescriptor.setPublicProfile(false);
                }
            }
        }
        return descriptors;
    }

    public void newRevision(Long poid, Long roid, Long soid, String serviceIdentifier, String profileIdentifier, String userToken, String token, String apiUrl) throws UserException, ServerException {
        Bimsie1RemoteServiceInterface localRemoteServiceInterface = this.bimServer.getInternalServicesManager().getLocalRemoteServiceInterface(serviceIdentifier);
        if (localRemoteServiceInterface == null) {
            throw new UserException("No local remote service found " + serviceIdentifier);
        }
        localRemoteServiceInterface.newRevision(poid, roid, soid, serviceIdentifier, profileIdentifier, userToken, token, apiUrl);
    }

    public SServiceDescriptor getService(String serviceIdentifier) throws UserException, ServerException {
        ServiceDescriptor internalService = this.getBimServer().getInternalServicesManager().getInternalService(this.getAuthorization().getUoid(), serviceIdentifier);
        return this.getBimServer().getSConverter().convertToSObject(internalService);
    }

    public void newExtendedDataOnProject(Long poid, Long edid, Long soid, String serviceIdentifier, String profileIdentifier, String userToken, String token, String apiUrl) throws UserException, ServerException {
        this.bimServer.getInternalServicesManager().getLocalRemoteServiceInterface(serviceIdentifier).newExtendedDataOnProject(poid, edid, soid, serviceIdentifier, profileIdentifier, userToken, token, apiUrl);
    }

    public void newExtendedDataOnRevision(Long poid, Long roid, Long edid, Long soid, String serviceIdentifier, String profileIdentifier, String userToken, String token, String apiUrl) throws UserException, ServerException {
        this.bimServer.getInternalServicesManager().getLocalRemoteServiceInterface(serviceIdentifier).newExtendedDataOnRevision(poid, roid, edid, soid, serviceIdentifier, profileIdentifier, userToken, token, apiUrl);
    }
}

