/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AddExtendedDataToRevisionDatabaseAction;
import org.bimserver.database.actions.AddProjectDatabaseAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.BranchToExistingProjectDatabaseAction;
import org.bimserver.database.actions.BranchToNewProjectDatabaseAction;
import org.bimserver.database.actions.DeleteProjectDatabaseAction;
import org.bimserver.database.actions.GetAllProjectsDatabaseAction;
import org.bimserver.database.actions.GetAllProjectsSmallDatabaseAction;
import org.bimserver.database.actions.GetAllRevisionsOfProjectDatabaseAction;
import org.bimserver.database.actions.GetDeserializerByIdDatabaseAction;
import org.bimserver.database.actions.GetDeserializerByNameDatabaseAction;
import org.bimserver.database.actions.GetExtendedDataByIdDatabaseAction;
import org.bimserver.database.actions.GetExtendedDataSchemaByIdDatabaseAction;
import org.bimserver.database.actions.GetExtendedDataSchemaByNamespaceDatabaseAction;
import org.bimserver.database.actions.GetProjectByPoidDatabaseAction;
import org.bimserver.database.actions.GetProjectsByNameDatabaseAction;
import org.bimserver.database.actions.GetQueryEngineByIdDatabaseAction;
import org.bimserver.database.actions.GetQueryEngineByNameDatabaseAction;
import org.bimserver.database.actions.GetRevisionDatabaseAction;
import org.bimserver.database.actions.GetSerializerByContentTypeDatabaseAction;
import org.bimserver.database.actions.GetSerializerByIdDatabaseAction;
import org.bimserver.database.actions.GetSerializerByNameDatabaseAction;
import org.bimserver.database.actions.GetSubProjectsDatabaseAction;
import org.bimserver.database.actions.UndeleteProjectDatabaseAction;
import org.bimserver.emf.QueryInterface;
import org.bimserver.emf.Schema;
import org.bimserver.interfaces.objects.SCheckoutResult;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SDownloadResult;
import org.bimserver.interfaces.objects.SExtendedData;
import org.bimserver.interfaces.objects.SExtendedDataSchema;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SProjectSmall;
import org.bimserver.interfaces.objects.SQueryEnginePluginConfiguration;
import org.bimserver.interfaces.objects.SRevision;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.longaction.CannotBeScheduledException;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongBranchAction;
import org.bimserver.longaction.LongCheckoutAction;
import org.bimserver.longaction.LongDownloadAction;
import org.bimserver.longaction.LongDownloadOrCheckoutAction;
import org.bimserver.longaction.LongStreamingDownloadAction;
import org.bimserver.models.store.DeserializerPluginConfiguration;
import org.bimserver.models.store.ExtendedData;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.deserializers.DeserializerPlugin;
import org.bimserver.plugins.serializers.MessagingStreamingSerializerPlugin;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1ServiceInterface;
import org.bimserver.webservices.SProjectComparator;
import org.bimserver.webservices.SRevisionComparator;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bimsie1ServiceImpl
extends GenericServiceImpl
implements Bimsie1ServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bimsie1ServiceInterface.class);

    public Bimsie1ServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public Long checkin(Long poid, String comment, Long deserializerOid, Long fileSize, String fileName, DataHandler data, Boolean sync) throws ServerException, UserException {
        return this.getServiceMap().get(ServiceInterface.class).checkin(poid, comment, deserializerOid, fileSize, fileName, data, Boolean.valueOf(false), sync);
    }

    public Long initiateCheckin(Long poid, Long deserializerOid) throws ServerException, UserException {
        return this.getServiceMap().get(ServiceInterface.class).initiateCheckin(poid, deserializerOid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long checkout(Long roid, Long serializerOid, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        this.getAuthorization().canDownload(roid);
        User user = null;
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SerializerPluginConfiguration serializerPluginConfiguration = (SerializerPluginConfiguration)session.get(serializerOid, OldQuery.getDefault());
            if (serializerPluginConfiguration == null) {
                throw new UserException("No serializer with id " + serializerOid + " could be found");
            }
            if (!serializerPluginConfiguration.getPluginDescriptor().getPluginClassName().equals("org.bimserver.ifc.step.serializer.IfcStepSerializerPlugin") && !serializerPluginConfiguration.getPluginDescriptor().getPluginClassName().equals("org.bimserver.ifc.xml.serializer.IfcXmlSerializerPlugin")) {
                throw new UserException("Only IFC or IFCXML allowed when checking out");
            }
            DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_PROJECTS);
            downloadParameters.setRoid(roid);
            downloadParameters.setSerializerOid(serializerOid);
            user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            LongCheckoutAction longDownloadAction = new LongCheckoutAction(this.getBimServer(), user.getName(), user.getUsername(), downloadParameters, this.getAuthorization(), this.getInternalAccessMethod());
            try {
                this.getBimServer().getLongActionManager().start(longDownloadAction);
            }
            catch (CannotBeScheduledException e) {
                LOGGER.error("", (Throwable)e);
            }
            if (sync.booleanValue()) {
                longDownloadAction.waitForCompletion();
            }
            Long l = longDownloadAction.getProgressTopic().getKey().getId();
            return l;
        }
    }

    public Long checkinFromUrl(Long poid, String comment, Long deserializerOid, String fileName, String url, Boolean sync) throws ServerException, UserException {
        return this.getServiceMap().get(ServiceInterface.class).checkinFromUrl(poid, comment, deserializerOid, fileName, url, Boolean.valueOf(false), sync);
    }

    public void terminateLongRunningAction(Long topicId) throws ServerException, UserException {
        LongAction<?> longAction = this.getBimServer().getLongActionManager().getLongAction(topicId);
        if (longAction == null) {
            throw new UserException("No data found for topicId " + topicId);
        }
        longAction.terminate();
    }

    public SDownloadResult getDownloadData(Long topicId) throws ServerException, UserException {
        LongAction<?> longAction = this.getBimServer().getLongActionManager().getLongAction(topicId);
        if (longAction == null) {
            throw new UserException("No data found for topicId " + topicId);
        }
        if (longAction instanceof LongStreamingDownloadAction) {
            LongStreamingDownloadAction longStreamingDownloadAction = (LongStreamingDownloadAction)longAction;
            if (longStreamingDownloadAction.getErrors().isEmpty()) {
                SCheckoutResult result;
                try {
                    result = longStreamingDownloadAction.getCheckoutResult();
                }
                catch (SerializerException e) {
                    throw new UserException((Throwable)e);
                }
                return result;
            }
            LOGGER.error(longStreamingDownloadAction.getErrors().get(0));
            throw new ServerException(longStreamingDownloadAction.getErrors().get(0));
        }
        LongDownloadOrCheckoutAction longDownloadAction = (LongDownloadOrCheckoutAction)longAction;
        try {
            longDownloadAction.waitForCompletion();
            if (longDownloadAction.getErrors().isEmpty()) {
                SCheckoutResult result = longDownloadAction.getCheckoutResult();
                return result;
            }
            LOGGER.error(longDownloadAction.getErrors().get(0));
            throw new ServerException(longDownloadAction.getErrors().get(0));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new ServerException((Throwable)e);
        }
    }

    public Long download(DownloadParameters downloadParameters, Boolean sync) throws ServerException, UserException {
        User user = null;
        for (long roid : downloadParameters.getRoids()) {
            this.getAuthorization().canDownload(roid);
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
        }
        LongDownloadAction longDownloadAction = new LongDownloadAction(this.getBimServer(), user == null ? "Unknown" : user.getName(), user == null ? "Unknown" : user.getUsername(), downloadParameters, this.getAuthorization(), this.getInternalAccessMethod());
        try {
            this.getBimServer().getLongActionManager().start(longDownloadAction);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        if (sync.booleanValue()) {
            longDownloadAction.waitForCompletion();
        }
        return longDownloadAction.getProgressTopic().getKey().getId();
    }

    public Long download(Long roid, Long serializerOid, Boolean showOwn, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_REVISION);
        downloadParameters.setRoid(roid);
        downloadParameters.setSerializerOid(serializerOid);
        return this.download(downloadParameters, sync);
    }

    public Long downloadByOids(Set<Long> roids, Set<Long> oids, Long serializerOid, Boolean sync, Boolean deep) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_BY_OIDS);
        downloadParameters.setSerializerOid(serializerOid);
        downloadParameters.setRoids(roids);
        downloadParameters.setOids(oids);
        downloadParameters.setDeep(deep != false ? OldQuery.Deep.YES : OldQuery.Deep.NO);
        return this.download(downloadParameters, sync);
    }

    public Long downloadByTypes(Set<Long> roids, String schema, Set<String> classNames, Long serializerOid, Boolean includeAllSubtypes, Boolean useObjectIDM, Boolean deep, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_OF_TYPE);
        downloadParameters.setRoids(roids);
        downloadParameters.setClassNames(classNames);
        downloadParameters.setIncludeAllSubtypes(includeAllSubtypes);
        downloadParameters.setSerializerOid(serializerOid);
        downloadParameters.setUseObjectIDM(useObjectIDM);
        downloadParameters.setSchema(schema);
        return this.download(downloadParameters, sync);
    }

    public Long downloadByJsonQuery(Set<Long> roids, String jsonQuery, Long serializerOid, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_JSON_QUERY);
        downloadParameters.setRoids(roids);
        downloadParameters.setJsonQuery(jsonQuery);
        downloadParameters.setSerializerOid(serializerOid);
        return this.download(downloadParameters, sync);
    }

    public Long downloadByNewJsonQuery(Set<Long> roids, String jsonQuery, Long serializerOid, Boolean sync) throws ServerException, UserException {
        User user = null;
        Plugin plugin = null;
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SerializerPluginConfiguration serializerPluginConfiguration = (SerializerPluginConfiguration)session.get(StorePackage.eINSTANCE.getSerializerPluginConfiguration(), (long)serializerOid, (QueryInterface)OldQuery.getDefault());
            plugin = this.getBimServer().getPluginManager().getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
            user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
        }
        if (plugin instanceof StreamingSerializerPlugin || plugin instanceof MessagingStreamingSerializerPlugin) {
            LongStreamingDownloadAction longDownloadAction = new LongStreamingDownloadAction(this.getBimServer(), user == null ? "Unknown" : user.getName(), user == null ? "Unknown" : user.getUsername(), this.getAuthorization(), serializerOid, jsonQuery, roids);
            try {
                this.getBimServer().getLongActionManager().start(longDownloadAction);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            if (sync.booleanValue()) {
                longDownloadAction.waitForCompletion();
            }
            return longDownloadAction.getProgressTopic().getKey().getId();
        }
        if (plugin instanceof SerializerPlugin) {
            this.requireAuthenticationAndRunningServer();
            DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_BY_NEW_JSON_QUERY);
            downloadParameters.setRoids(roids);
            downloadParameters.setJsonQuery(jsonQuery);
            downloadParameters.setSerializerOid(serializerOid);
            return this.download(downloadParameters, sync);
        }
        throw new UserException("Unimplemented");
    }

    public Long downloadByGuids(Set<Long> roids, Set<String> guids, Long serializerOid, Boolean deep, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_BY_GUIDS);
        downloadParameters.setRoids(roids);
        downloadParameters.setGuids(guids);
        downloadParameters.setSerializerOid(serializerOid);
        downloadParameters.setDeep(deep != false ? OldQuery.Deep.YES : OldQuery.Deep.NO);
        return this.download(downloadParameters, sync);
    }

    public Long downloadByNames(Set<Long> roids, Set<String> names, Long serializerOid, Boolean deep, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_BY_NAMES);
        downloadParameters.setRoids(roids);
        downloadParameters.setNames(names);
        downloadParameters.setSerializerOid(serializerOid);
        downloadParameters.setDeep(deep != false ? OldQuery.Deep.YES : OldQuery.Deep.NO);
        return this.download(downloadParameters, sync);
    }

    public Long downloadRevisions(Set<Long> roids, Long serializerOid, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_PROJECTS);
        downloadParameters.setRoids(roids);
        if (serializerOid == null) {
            throw new UserException("No valid serializer selected");
        }
        downloadParameters.setSerializerOid(serializerOid);
        return this.download(downloadParameters, sync);
    }

    public Long downloadQuery(Long roid, Long qeid, String code, Boolean sync, Long serializerOid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_QUERY);
        downloadParameters.setRoid(roid);
        downloadParameters.setQeid(qeid);
        downloadParameters.setCode(code);
        downloadParameters.setSerializerOid(serializerOid);
        return this.download(downloadParameters, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSerializerPluginConfiguration getSerializerByName(String serializerName) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SSerializerPluginConfiguration sSerializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetSerializerByNameDatabaseAction(session, this.getInternalAccessMethod(), serializerName)));
            return sSerializerPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDeserializerPluginConfiguration getDeserializerByName(String deserializerName) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SDeserializerPluginConfiguration sDeserializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetDeserializerByNameDatabaseAction(session, this.getInternalAccessMethod(), deserializerName)));
            return sDeserializerPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDeserializerPluginConfiguration getDeserializerById(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SDeserializerPluginConfiguration sDeserializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetDeserializerByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sDeserializerPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQueryEnginePluginConfiguration getQueryEngineByName(String name) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SQueryEnginePluginConfiguration sQueryEnginePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetQueryEngineByNameDatabaseAction(session, this.getInternalAccessMethod(), name)));
            return sQueryEnginePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQueryEnginePluginConfiguration getQueryEngineById(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SQueryEnginePluginConfiguration sQueryEnginePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetQueryEngineByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sQueryEnginePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSerializerPluginConfiguration getSerializerById(Long oid) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SSerializerPluginConfiguration sSerializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetSerializerByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sSerializerPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSerializerPluginConfiguration getSerializerByContentType(String contentType) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SSerializerPluginConfiguration sSerializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetSerializerByContentTypeDatabaseAction(session, this.getInternalAccessMethod(), contentType)));
            return sSerializerPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public SDeserializerPluginConfiguration getSuggestedDeserializerForExtension(String extension, Long poid) throws ServerException, UserException {
        try {
            this.requireAuthenticationAndRunningServer();
            try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
                Project project = (Project)session.get(poid, OldQuery.getDefault());
                for (DeserializerPlugin deserializerPlugin : this.getBimServer().getPluginManager().getAllDeserializerPlugins(true).values()) {
                    if (!deserializerPlugin.canHandleExtension(extension)) continue;
                    UserSettings userSettings = this.getUserSettings(session);
                    for (DeserializerPluginConfiguration deserializer : userSettings.getDeserializers()) {
                        if (!deserializer.getPluginDescriptor().getPluginClassName().equals(deserializerPlugin.getClass().getName()) || !deserializerPlugin.getSupportedSchemas().contains(Schema.valueOf((String)project.getSchema().toUpperCase()))) continue;
                        SDeserializerPluginConfiguration sDeserializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(deserializer);
                        return sDeserializerPluginConfiguration;
                    }
                }
            }
        }
        catch (Exception e) {
            return (SDeserializerPluginConfiguration)this.handleException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtendedDataToRevision(Long roid, SExtendedData extendedData) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ExtendedData convert = this.getBimServer().getSConverter().convertFromSObject(extendedData, session);
            session.executeAndCommitAction(new AddExtendedDataToRevisionDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SExtendedDataSchema getExtendedDataSchemaById(Long oid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SExtendedDataSchema sExtendedDataSchema = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetExtendedDataSchemaByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sExtendedDataSchema;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SExtendedData getExtendedData(Long oid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SExtendedData sExtendedData = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetExtendedDataByIdDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), oid)));
            return sExtendedData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRevision getRevision(Long roid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetRevisionDatabaseAction action = new GetRevisionDatabaseAction(session, this.getInternalAccessMethod(), roid, this.getAuthorization());
            SRevision sRevision = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sRevision;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SProject addProjectAsSubProject(String projectName, Long parentPoid, String schema) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddProjectDatabaseAction action = new AddProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), projectName, parentPoid, schema, this.getAuthorization());
            SProject sProject = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long branchToNewProject(Long roid, String projectName, String comment, Boolean sync) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            BranchToNewProjectDatabaseAction action = new BranchToNewProjectDatabaseAction(session, this.getInternalAccessMethod(), this.getBimServer(), this.getAuthorization(), roid, projectName, comment);
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            String username = user.getName();
            String userUsername = user.getUsername();
            LongBranchAction longAction = new LongBranchAction(this.getBimServer(), username, userUsername, this.getAuthorization(), action);
            this.getBimServer().getLongActionManager().start(longAction);
            if (sync.booleanValue()) {
                longAction.waitForCompletion();
            }
            Long l = longAction.getProgressTopic().getKey().getId();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long branchToExistingProject(Long roid, Long destPoid, String comment, Boolean sync) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            BranchToExistingProjectDatabaseAction action = new BranchToExistingProjectDatabaseAction(session, this.getInternalAccessMethod(), this.getBimServer(), this.getAuthorization(), roid, destPoid, comment);
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            String username = user.getName();
            String userUsername = user.getUsername();
            LongBranchAction longBranchAction = new LongBranchAction(this.getBimServer(), username, userUsername, this.getAuthorization(), action);
            this.getBimServer().getLongActionManager().start(longBranchAction);
            if (sync.booleanValue()) {
                longBranchAction.waitForCompletion();
            }
            Long l = longBranchAction.getProgressTopic().getKey().getId();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SProject getProjectByPoid(Long poid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SProject result;
            GetProjectByPoidDatabaseAction action = new GetProjectByPoidDatabaseAction(session, this.getInternalAccessMethod(), poid, this.getAuthorization());
            SProject sProject = result = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SProjectSmall getProjectSmallByPoid(Long poid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetProjectByPoidDatabaseAction action = new GetProjectByPoidDatabaseAction(session, this.getInternalAccessMethod(), poid, this.getAuthorization());
            Project project = session.executeAndCommitAction(action);
            User user = (User)session.get(this.getAuthorization().getUoid(), OldQuery.getDefault());
            SProjectSmall sProjectSmall = GetAllProjectsSmallDatabaseAction.createSmallProject(this.getAuthorization(), this.getBimServer(), project, user);
            return sProjectSmall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getProjectsByName(String name) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetProjectsByNameDatabaseAction action = new GetProjectsByNameDatabaseAction(session, this.getInternalAccessMethod(), name, this.getAuthorization());
            List<SProject> list = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getSubProjects(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetSubProjectsDatabaseAction action = new GetSubProjectsDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), poid);
            List<SProject> convertToSListProject = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            Collections.sort(convertToSListProject, new SProjectComparator());
            List<SProject> list = convertToSListProject;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SExtendedData> getAllExtendedDataOfRevision(Long roid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Revision revision = (Revision)session.get(StorePackage.eINSTANCE.getRevision(), (long)roid, (QueryInterface)OldQuery.getDefault());
            List<SExtendedData> list = this.getBimServer().getSConverter().convertToSListExtendedData((Collection<ExtendedData>)revision.getExtendedData());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean undeleteProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UndeleteProjectDatabaseAction action = new UndeleteProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), poid, this.getAuthorization());
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean deleteProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteProjectDatabaseAction action = new DeleteProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), poid, this.getAuthorization());
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SRevision> getAllRevisionsOfProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllRevisionsOfProjectDatabaseAction action = new GetAllRevisionsOfProjectDatabaseAction(session, this.getInternalAccessMethod(), poid);
            List<SRevision> convertToSListRevision = this.getBimServer().getSConverter().convertToSListRevision((Collection<Revision>)session.executeAndCommitAction(action));
            Collections.sort(convertToSListRevision, new SRevisionComparator(true));
            List<SRevision> list = convertToSListRevision;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getAllProjects(Boolean onlyTopLevel, Boolean onlyActive) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllProjectsDatabaseAction action = new GetAllProjectsDatabaseAction(session, this.getInternalAccessMethod(), onlyTopLevel, onlyActive, this.getAuthorization());
            List<SProject> convertToSListProject = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            Collections.sort(convertToSListProject, new SProjectComparator());
            List<SProject> list = convertToSListProject;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProjectSmall> getAllProjectsSmall() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllProjectsSmallDatabaseAction action = new GetAllProjectsSmallDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization());
            List list = (List)((BimDatabaseAction)action).execute();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SProject addProject(String projectName, String schema) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddProjectDatabaseAction action = new AddProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), projectName, schema, this.getAuthorization());
            SProject sProject = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SExtendedDataSchema getExtendedDataSchemaByNamespace(String nameSpace) throws UserException, ServerException {
        if (nameSpace == null) {
            throw new UserException("NameSpace required");
        }
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SExtendedDataSchema sExtendedDataSchema = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetExtendedDataSchemaByNamespaceDatabaseAction(session, this.getInternalAccessMethod(), nameSpace)));
            return sExtendedDataSchema;
        }
    }
}

