/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.objects.SUser;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ServerState;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.NoTransactionException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.AnonymousAuthorization;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericServiceImpl.class);
    private ServiceMap serviceMap;

    public GenericServiceImpl(ServiceMap serviceMap) {
        this.serviceMap = serviceMap;
    }

    protected void requireAuthenticationAndRunningServer() throws UserException {
        this.requireRunningServer();
        this.requireAuthentication();
    }

    protected void requireAdminAuthenticationAndRunningServer() throws UserException {
        this.requireRunningServer();
        this.requireAdminAuthentication();
    }

    protected void requireRunningServer() throws UserException {
        if (this.serviceMap.getBimServer().getServerInfo().getServerState() != ServerState.RUNNING) {
            throw new UserException("Call cannot be executed because the server is in " + this.serviceMap.getBimServer().getServerInfo().getServerState() + " mode");
        }
    }

    protected void requireAuthentication() throws UserException {
        if (this.serviceMap.getAuthorization() == null) {
            throw new UserException("Authentication required for this call");
        }
    }

    protected void requireRealUserAuthentication() throws UserException {
        this.requireRunningServer();
        if (this.serviceMap.getAuthorization() == null) {
            throw new UserException("Authentication required for this call");
        }
        if (this.serviceMap.getAuthorization() instanceof ExplicitRightsAuthorization) {
            throw new UserException("Real authentication required (this session has token authentication)");
        }
        if (this.serviceMap.getAuthorization() instanceof AnonymousAuthorization) {
            throw new UserException("Anonymous has no rights for this call");
        }
    }

    protected void requireAdminAuthentication() throws UserException {
        if (this.serviceMap.getAuthorization() == null) {
            throw new UserException("Authentication required for this call");
        }
        if (!(this.serviceMap.getAuthorization() instanceof AdminAuthorization) && !(this.serviceMap.getAuthorization() instanceof SystemAuthorization)) {
            throw new UserException("Administrator rights required for this call");
        }
    }

    protected void requireSelfregistrationAllowed() throws UserException {
        if (this.serviceMap.getAuthorization() == null) {
            throw new UserException("No self registration allowed");
        }
    }

    public BimServer getBimServer() {
        return this.serviceMap.getBimServer();
    }

    public Authorization getAuthorization() {
        return this.serviceMap.getAuthorization();
    }

    public void setAuthorization(Authorization authorization) {
        this.serviceMap.setAuthorization(authorization);
    }

    public AccessMethod getInternalAccessMethod() {
        return this.serviceMap.getAccessMethod();
    }

    protected <T> T handleException(Exception e) throws ServerException, UserException {
        if (e instanceof UserException) {
            throw (UserException)((Object)e);
        }
        if (e instanceof ServerException) {
            LOGGER.error("", (Throwable)e);
            throw (ServerException)e;
        }
        if (e instanceof NoTransactionException) {
            throw new UserException((Throwable)e);
        }
        if (e instanceof BimserverConcurrentModificationDatabaseException) {
            throw new ServerException("Concurrent modification of object, please try again", (Throwable)e);
        }
        if (e instanceof BimserverDatabaseException) {
            LOGGER.error("", (Throwable)e);
            throw new ServerException("Database error", (Throwable)e);
        }
        LOGGER.error("", (Throwable)e);
        throw new ServerException("Unknown error: " + e.getMessage(), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser getCurrentUser() throws UserException, ServerException {
        if (this.getAuthorization() == null) {
            return null;
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            SUser sUser = this.getBimServer().getSConverter().convertToSObject(user);
            return sUser;
        }
    }

    public ServiceMap getServiceMap() {
        return this.serviceMap;
    }

    protected UserSettings getUserSettings(DatabaseSession session) throws BimserverLockConflictException, BimserverDatabaseException {
        User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
        return user.getUserSettings();
    }
}

