/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bimserver.interfaces.objects.SServiceField;
import org.bimserver.interfaces.objects.SServiceInterface;
import org.bimserver.interfaces.objects.SServiceMethod;
import org.bimserver.interfaces.objects.SServiceParameter;
import org.bimserver.interfaces.objects.SServiceSimpleType;
import org.bimserver.interfaces.objects.SServiceType;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.meta.SClass;
import org.bimserver.shared.meta.SField;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;

public class MetaServiceImpl
extends GenericServiceImpl
implements MetaInterface {
    public MetaServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public List<SServiceInterface> getServiceInterfaces() throws ServerException, UserException {
        ArrayList<SServiceInterface> sServiceInterfaces = new ArrayList<SServiceInterface>();
        for (String name : this.getBimServer().getServicesMap().keySetName()) {
            SServiceInterface sServiceInterface = this.convertServiceInterface(name);
            sServiceInterfaces.add(sServiceInterface);
        }
        Collections.sort(sServiceInterfaces, new Comparator<SServiceInterface>(){

            @Override
            public int compare(SServiceInterface o1, SServiceInterface o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sServiceInterfaces;
    }

    private SServiceInterface convertServiceInterface(String name) {
        SServiceInterface sServiceInterface = new SServiceInterface();
        SService byName = this.getBimServer().getServicesMap().getByName(name);
        sServiceInterface.setName(name);
        sServiceInterface.setNameSpace(byName.getNameSpace());
        sServiceInterface.setSimpleName(byName.getSimpleName());
        return sServiceInterface;
    }

    public List<SServiceMethod> getServiceMethods(String serviceInterfaceName) throws ServerException, UserException {
        ArrayList<SServiceMethod> sServiceMethods = new ArrayList<SServiceMethod>();
        SService sService = this.getBimServer().getServicesMap().getByName(serviceInterfaceName);
        if (sService == null) {
            throw new UserException("Service \"" + serviceInterfaceName + "\" not found");
        }
        for (SMethod sMethod : sService.getMethods()) {
            SServiceMethod sServiceMethod = this.convertMethod(sMethod);
            sServiceMethods.add(sServiceMethod);
        }
        return sServiceMethods;
    }

    private SServiceMethod convertMethod(SMethod sMethod) {
        SServiceMethod sServiceMethod = new SServiceMethod();
        sServiceMethod.setName(sMethod.getName());
        sServiceMethod.setDoc(sMethod.getDoc());
        sServiceMethod.setReturnDoc(sMethod.getReturnDoc());
        return sServiceMethod;
    }

    public List<SServiceType> getServiceTypes() throws ServerException, UserException {
        ArrayList<SServiceType> sServiceTypes = new ArrayList<SServiceType>();
        for (SClass sType : this.getBimServer().getServicesMap().getTypes()) {
            sServiceTypes.add(this.createSServiceType(sType, false));
        }
        return sServiceTypes;
    }

    public List<String> getEnumLiterals(String enumName) throws UserException {
        ArrayList<String> result = new ArrayList<String>();
        SClass type = this.getBimServer().getServicesMap().getType(enumName);
        for (Object enumConstant : type.getInstanceClass().getEnumConstants()) {
            result.add(enumConstant.toString());
        }
        return result;
    }

    public SServiceType createSServiceType(SClass sClass, boolean recurse) throws UserException, ServerException {
        if (sClass == null) {
            return null;
        }
        SServiceType sServiceType = new SServiceType();
        sServiceType.setName(sClass.getName());
        sServiceType.setSimpleName(sClass.getSimpleName());
        sServiceType.setSimpleType(SServiceSimpleType.valueOf((String)sClass.getSimpleType().name()));
        for (SField field : sClass.getOwnFields()) {
            SServiceField sServiceField = new SServiceField();
            sServiceField.setName(field.getName());
            if (recurse) {
                sServiceField.setType(this.createSServiceType(field.getType(), recurse));
                sServiceField.setGenericType(this.createSServiceType(field.getGenericType(), recurse));
            }
            sServiceField.setDoc(field.getDoc());
            sServiceType.getFields().add(sServiceField);
        }
        return sServiceType;
    }

    public List<SServiceParameter> getServiceMethodParameters(String serviceInterfaceName, String serviceMethodName) throws ServerException, UserException {
        ArrayList<SServiceParameter> sServiceParameters = new ArrayList<SServiceParameter>();
        SService serviceInterface = this.getBimServer().getServicesMap().getByName(serviceInterfaceName);
        if (serviceInterface == null) {
            throw new UserException("Service \"" + serviceInterfaceName + "\" not found");
        }
        SMethod sMethod = serviceInterface.getSMethod(serviceMethodName);
        if (sMethod == null) {
            throw new UserException("Method \"" + serviceMethodName + "\" not found in \"" + serviceInterfaceName + "\"");
        }
        for (SParameter sParameter : sMethod.getParameters()) {
            SServiceParameter sServiceParameter = new SServiceParameter();
            sServiceParameter.setName(sParameter.getName());
            sServiceParameter.setDoc(sParameter.getDoc());
            sServiceParameter.setType(this.createSServiceType(sParameter.getType(), false));
            sServiceParameter.setGenericType(this.createSServiceType(sParameter.getGenericType(), false));
            sServiceParameters.add(sServiceParameter);
        }
        return sServiceParameters;
    }

    public SServiceInterface getServiceInterface(String serviceInterfaceName) throws ServerException, UserException {
        return this.convertServiceInterface(serviceInterfaceName);
    }

    public SServiceMethod getServiceMethod(String serviceInterfaceName, String methodName) throws ServerException, UserException {
        SService sService = this.getBimServer().getServicesMap().getByName(serviceInterfaceName);
        if (sService == null) {
            throw new UserException("Service \"" + serviceInterfaceName + "\" not found");
        }
        return this.convertMethod(sService.getMethod(methodName));
    }

    public String getAllAsJson() throws ServerException, UserException {
        return this.getBimServer().getServicesMap().toJson(new ObjectMapper()).toString();
    }
}

