/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AddDeserializerDatabaseAction;
import org.bimserver.database.actions.AddInternalServiceDatabaseAction;
import org.bimserver.database.actions.AddModelCompareDatabaseAction;
import org.bimserver.database.actions.AddModelMergerDatabaseAction;
import org.bimserver.database.actions.AddObjectIDMDatabaseAction;
import org.bimserver.database.actions.AddQueryEngineDatabaseAction;
import org.bimserver.database.actions.AddRenderEngineDatabaseAction;
import org.bimserver.database.actions.AddSerializerDatabaseAction;
import org.bimserver.database.actions.DeleteDeserializerDatabaseAction;
import org.bimserver.database.actions.DeleteInternalServiceDatabaseAction;
import org.bimserver.database.actions.DeleteModelCompareDatabaseAction;
import org.bimserver.database.actions.DeleteModelMergerDatabaseAction;
import org.bimserver.database.actions.DeleteObjectIDMDatabaseAction;
import org.bimserver.database.actions.DeleteQueryEngineDatabaseAction;
import org.bimserver.database.actions.DeleteRenderEngineDatabaseAction;
import org.bimserver.database.actions.DeleteSerializerDatabaseAction;
import org.bimserver.database.actions.GetAvailablePluginBundles;
import org.bimserver.database.actions.GetByIdDatabaseAction;
import org.bimserver.database.actions.GetInstalledPluginBundles;
import org.bimserver.database.actions.GetMessagingSerializerByPluginClassNameDatabaseAction;
import org.bimserver.database.actions.GetModelCompareByIdDatabaseAction;
import org.bimserver.database.actions.GetModelCompareByNameDatabaseAction;
import org.bimserver.database.actions.GetModelMergerByIdDatabaseAction;
import org.bimserver.database.actions.GetModelMergerByNameDatabaseAction;
import org.bimserver.database.actions.GetObjectIDMByIdDatabaseAction;
import org.bimserver.database.actions.GetObjectIDMByNameDatabaseAction;
import org.bimserver.database.actions.GetPluginInformation;
import org.bimserver.database.actions.GetRenderEngineByIdDatabaseAction;
import org.bimserver.database.actions.GetRenderEngineByNameDatabaseAction;
import org.bimserver.database.actions.GetSerializerByPluginClassNameDatabaseAction;
import org.bimserver.database.actions.GetWebModuleByIdDatabaseAction;
import org.bimserver.database.actions.GetWebModuleByNameDatabaseAction;
import org.bimserver.database.actions.InstallPlugin;
import org.bimserver.database.actions.SetPluginSettingsDatabaseAction;
import org.bimserver.database.actions.SetUserSettingDatabaseAction;
import org.bimserver.database.actions.UninstallPlugin;
import org.bimserver.database.actions.UpdateDatabaseAction;
import org.bimserver.database.actions.UpdateDeserializerDatabaseAction;
import org.bimserver.database.actions.UpdateModelCompareDatabaseAction;
import org.bimserver.database.actions.UpdateModelMergerDatabaseAction;
import org.bimserver.database.actions.UpdateObjectIDMDatabaseAction;
import org.bimserver.database.actions.UpdateQueryEngineDatabaseAction;
import org.bimserver.database.actions.UpdateRenderEngineDatabaseAction;
import org.bimserver.database.actions.UpdateSerializerDatabaseAction;
import org.bimserver.database.actions.UserSettingsSetter;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.emf.Schema;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SDeserializerPluginDescriptor;
import org.bimserver.interfaces.objects.SInternalServicePluginConfiguration;
import org.bimserver.interfaces.objects.SMessagingSerializerPluginConfiguration;
import org.bimserver.interfaces.objects.SModelCheckerPluginDescriptor;
import org.bimserver.interfaces.objects.SModelComparePluginConfiguration;
import org.bimserver.interfaces.objects.SModelComparePluginDescriptor;
import org.bimserver.interfaces.objects.SModelMergerPluginConfiguration;
import org.bimserver.interfaces.objects.SModelMergerPluginDescriptor;
import org.bimserver.interfaces.objects.SObjectDefinition;
import org.bimserver.interfaces.objects.SObjectIDMPluginConfiguration;
import org.bimserver.interfaces.objects.SObjectIDMPluginDescriptor;
import org.bimserver.interfaces.objects.SObjectType;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginDescriptor;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.interfaces.objects.SQueryEnginePluginConfiguration;
import org.bimserver.interfaces.objects.SQueryEnginePluginDescriptor;
import org.bimserver.interfaces.objects.SRenderEnginePluginConfiguration;
import org.bimserver.interfaces.objects.SRenderEnginePluginDescriptor;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.interfaces.objects.SSerializerPluginDescriptor;
import org.bimserver.interfaces.objects.SServicePluginDescriptor;
import org.bimserver.interfaces.objects.SWebModulePluginConfiguration;
import org.bimserver.interfaces.objects.SWebModulePluginDescriptor;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DeserializerPluginConfiguration;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.ModelComparePluginConfiguration;
import org.bimserver.models.store.ModelMergerPluginConfiguration;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ObjectIDMPluginConfiguration;
import org.bimserver.models.store.ObjectType;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.PluginDescriptor;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.QueryEnginePluginConfiguration;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.UserSettings;
import org.bimserver.models.store.WebModulePluginConfiguration;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.deserializers.DeserializerPlugin;
import org.bimserver.plugins.deserializers.StreamingDeserializerPlugin;
import org.bimserver.plugins.objectidms.ObjectIDMPlugin;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.plugins.services.ServicePlugin;
import org.bimserver.schemaconverter.SchemaConverterFactory;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.webservices.SPluginConfigurationComparator;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.eclipse.emf.common.util.EList;

public class PluginServiceImpl
extends GenericServiceImpl
implements PluginInterface {
    public PluginServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeserializer(SDeserializerPluginConfiguration deserializer) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeserializerPluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(deserializer, session);
            session.executeAndCommitAction(new AddDeserializerDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSerializer(SSerializerPluginConfiguration serializer) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SerializerPluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(serializer, session);
            session.executeAndCommitAction(new UpdateSerializerDatabaseAction(session, this.getInternalAccessMethod(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeserializer(SDeserializerPluginConfiguration deserializer) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeserializerPluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(deserializer, session);
            session.executeAndCommitAction(new UpdateDeserializerDatabaseAction(session, this.getInternalAccessMethod(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SObjectIDMPluginConfiguration> getAllObjectIDMs(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            List<SObjectIDMPluginConfiguration> objectIdms = this.getBimServer().getSConverter().convertToSListObjectIDMPluginConfiguration((Collection<ObjectIDMPluginConfiguration>)userSettings.getObjectIDMs());
            Collections.sort(objectIdms, new SPluginConfigurationComparator());
            List<SObjectIDMPluginConfiguration> list = objectIdms;
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectIDM(SObjectIDMPluginConfiguration objectIDM) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.executeAndCommitAction(new AddObjectIDMDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), this.getBimServer().getSConverter().convertFromSObject(objectIDM, session)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectIDM(SObjectIDMPluginConfiguration objectIDM) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.executeAndCommitAction(new UpdateObjectIDMDatabaseAction(session, this.getInternalAccessMethod(), this.getBimServer().getSConverter().convertFromSObject(objectIDM, session)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SObjectIDMPluginConfiguration getObjectIDMById(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SObjectIDMPluginConfiguration sObjectIDMPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetObjectIDMByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sObjectIDMPluginConfiguration;
        }
        return null;
    }

    public List<SSerializerPluginDescriptor> getAllSerializerPluginDescriptors() throws UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllSerializerPluginDescriptors();
    }

    public List<SWebModulePluginDescriptor> getAllWebModulePluginDescriptors() throws UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllWebModulePluginDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectIDM(Long ifid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteObjectIDMDatabaseAction action = new DeleteObjectIDMDatabaseAction(session, this.getInternalAccessMethod(), ifid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSerializer(Long sid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteSerializerDatabaseAction action = new DeleteSerializerDatabaseAction(session, this.getInternalAccessMethod(), sid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDeserializer(Long sid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteDeserializerDatabaseAction action = new DeleteDeserializerDatabaseAction(session, this.getInternalAccessMethod(), sid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWebModulePluginConfiguration getWebModuleByName(String name) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SWebModulePluginConfiguration sWebModulePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetWebModuleByNameDatabaseAction(session, this.getInternalAccessMethod(), name)));
            return sWebModulePluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SObjectIDMPluginConfiguration getObjectIDMByName(String ObjectIDMName) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SObjectIDMPluginConfiguration sObjectIDMPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetObjectIDMByNameDatabaseAction(session, this.getInternalAccessMethod(), ObjectIDMName)));
            return sObjectIDMPluginConfiguration;
        }
        return null;
    }

    public List<SDeserializerPluginDescriptor> getAllDeserializerPluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        ArrayList<SDeserializerPluginDescriptor> descriptors = new ArrayList<SDeserializerPluginDescriptor>();
        for (DeserializerPlugin deserializerPlugin : this.getBimServer().getPluginManager().getAllDeserializerPlugins(true).values()) {
            SDeserializerPluginDescriptor descriptor = new SDeserializerPluginDescriptor();
            descriptor.setDefaultName(deserializerPlugin.getDefaultName());
            descriptor.setPluginClassName(deserializerPlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<SRenderEnginePluginDescriptor> getAllRenderEnginePluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllRenderEnginePluginDescriptors();
    }

    public List<SQueryEnginePluginDescriptor> getAllQueryEnginePluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllQueryEnginePluginDescriptors();
    }

    public List<SServicePluginDescriptor> getAllServicePluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllServicePluginDescriptors();
    }

    public List<SModelComparePluginDescriptor> getAllModelComparePluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllModelComparePluginDescriptors();
    }

    public List<SModelCheckerPluginDescriptor> getAllModelCheckerPluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllModelCheckerPluginDescriptors();
    }

    public List<SModelMergerPluginDescriptor> getAllModelMergerPluginDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getAllModelMergerPluginDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SRenderEnginePluginConfiguration> getAllRenderEngines(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            List<SRenderEnginePluginConfiguration> renderEngines = this.getBimServer().getSConverter().convertToSListRenderEnginePluginConfiguration((Collection<RenderEnginePluginConfiguration>)userSettings.getRenderEngines());
            Collections.sort(renderEngines, new SPluginConfigurationComparator());
            List<SRenderEnginePluginConfiguration> list = renderEngines;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQueryEnginePluginConfiguration> getAllQueryEngines(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            List<SQueryEnginePluginConfiguration> queryEngines = this.getBimServer().getSConverter().convertToSListQueryEnginePluginConfiguration((Collection<QueryEnginePluginConfiguration>)userSettings.getQueryEngines());
            Collections.sort(queryEngines, new SPluginConfigurationComparator());
            List<SQueryEnginePluginConfiguration> list = queryEngines;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SModelComparePluginConfiguration> getAllModelCompares(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            List<SModelComparePluginConfiguration> modelCompares = this.getBimServer().getSConverter().convertToSListModelComparePluginConfiguration((Collection<ModelComparePluginConfiguration>)userSettings.getModelCompares());
            Collections.sort(modelCompares, new SPluginConfigurationComparator());
            List<SModelComparePluginConfiguration> list = modelCompares;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SModelMergerPluginConfiguration> getAllModelMergers(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            List<SModelMergerPluginConfiguration> modelMergers = this.getBimServer().getSConverter().convertToSListModelMergerPluginConfiguration((Collection<ModelMergerPluginConfiguration>)userSettings.getModelMergers());
            Collections.sort(modelMergers, new SPluginConfigurationComparator());
            List<SModelMergerPluginConfiguration> list = modelMergers;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRenderEngine(SRenderEnginePluginConfiguration renderEngine) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RenderEnginePluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(renderEngine, session);
            session.executeAndCommitAction(new UpdateRenderEngineDatabaseAction(session, this.getInternalAccessMethod(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueryEngine(SQueryEnginePluginConfiguration queryEngine) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            QueryEnginePluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(queryEngine, session);
            session.executeAndCommitAction(new UpdateQueryEngineDatabaseAction(session, this.getInternalAccessMethod(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModelCompare(SModelComparePluginConfiguration modelCompare) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ModelComparePluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(modelCompare, session);
            session.executeAndCommitAction(new UpdateModelCompareDatabaseAction(session, this.getInternalAccessMethod(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModelMerger(SModelMergerPluginConfiguration modelMerger) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ModelMergerPluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(modelMerger, session);
            session.executeAndCommitAction(new UpdateModelMergerDatabaseAction(session, this.getInternalAccessMethod(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRenderEngine(Long iid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteRenderEngineDatabaseAction action = new DeleteRenderEngineDatabaseAction(session, this.getInternalAccessMethod(), iid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQueryEngine(Long iid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteQueryEngineDatabaseAction action = new DeleteQueryEngineDatabaseAction(session, this.getInternalAccessMethod(), iid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteModelCompare(Long iid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteModelCompareDatabaseAction action = new DeleteModelCompareDatabaseAction(session, this.getInternalAccessMethod(), iid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteModelChecker(Long iid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteModelCompareDatabaseAction action = new DeleteModelCompareDatabaseAction(session, this.getInternalAccessMethod(), iid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteModelMerger(Long iid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteModelMergerDatabaseAction action = new DeleteModelMergerDatabaseAction(session, this.getInternalAccessMethod(), iid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRenderEnginePluginConfiguration getRenderEngineByName(String name) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SRenderEnginePluginConfiguration sRenderEnginePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetRenderEngineByNameDatabaseAction(session, this.getInternalAccessMethod(), name)));
            return sRenderEnginePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelMergerPluginConfiguration getModelMergerById(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SModelMergerPluginConfiguration sModelMergerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetModelMergerByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sModelMergerPluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelComparePluginConfiguration getModelCompareById(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SModelComparePluginConfiguration sModelComparePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetModelCompareByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sModelComparePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelComparePluginConfiguration getModelCompareByName(String name) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SModelComparePluginConfiguration sModelComparePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetModelCompareByNameDatabaseAction(session, this.getInternalAccessMethod(), name)));
            return sModelComparePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelMergerPluginConfiguration getModelMergerByName(String name) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SModelMergerPluginConfiguration sModelMergerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetModelMergerByNameDatabaseAction(session, this.getInternalAccessMethod(), name)));
            return sModelMergerPluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRenderEnginePluginConfiguration getRenderEngineById(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SRenderEnginePluginConfiguration sRenderEnginePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetRenderEngineByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sRenderEnginePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderEngine(SRenderEnginePluginConfiguration renderEngine) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RenderEnginePluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(renderEngine, session);
            session.executeAndCommitAction(new AddRenderEngineDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryEngine(SQueryEnginePluginConfiguration queryEngine) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            QueryEnginePluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(queryEngine, session);
            session.executeAndCommitAction(new AddQueryEngineDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelCompare(SModelComparePluginConfiguration modelCompare) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ModelComparePluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(modelCompare, session);
            session.executeAndCommitAction(new AddModelCompareDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelMerger(SModelMergerPluginConfiguration modelMerger) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ModelMergerPluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(modelMerger, session);
            session.executeAndCommitAction(new AddModelMergerDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SObjectDefinition getPluginObjectDefinition(Long oid) throws ServerException, UserException {
        if (oid == -1L) {
            return null;
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            PluginDescriptor pluginDescriptor = (PluginDescriptor)session.get(oid, OldQuery.getDefault());
            if (pluginDescriptor == null) {
                throw new UserException("No PluginDescriptor found with oid " + oid);
            }
            Plugin plugin = this.getBimServer().getPluginManager().getPlugin(pluginDescriptor.getPluginClassName(), false);
            if (plugin == null) {
                throw new UserException("No plugin with class name " + pluginDescriptor.getPluginClassName() + " found");
            }
            ObjectDefinition settingsDefinition = plugin.getSettingsDefinition();
            SObjectDefinition sObjectDefinition = this.getBimServer().getSConverter().convertToSObject(settingsDefinition);
            return sObjectDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginSettings(Long poid, SObjectType settings) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ObjectType convertedSettings = this.getBimServer().getSConverter().convertFromSObject(settings, session);
            SetPluginSettingsDatabaseAction action = new SetPluginSettingsDatabaseAction(session, this.getInternalAccessMethod(), poid, convertedSettings);
            session.executeAndCommitAction(action);
        }
        session = this.getBimServer().getDatabase().createSession();
        try {
            PluginConfiguration pluginConfiguration = (PluginConfiguration)session.get(StorePackage.eINSTANCE.getPluginConfiguration(), (long)poid, (QueryInterface)OldQuery.getDefault());
            ServicePlugin servicePlugin = this.getBimServer().getPluginManager().getServicePlugin(pluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
            SInternalServicePluginConfiguration sInternalService = (SInternalServicePluginConfiguration)this.getBimServer().getSConverter().convertToSObject(pluginConfiguration);
            servicePlugin.unregister(sInternalService);
            servicePlugin.register(this.getAuthorization().getUoid(), sInternalService, new org.bimserver.plugins.PluginConfiguration(settings));
        }
        catch (BimserverDatabaseException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SSerializerPluginConfiguration> getAllSerializers(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            ArrayList<SSerializerPluginConfiguration> sSerializers = new ArrayList<SSerializerPluginConfiguration>();
            for (SerializerPluginConfiguration serializerPluginConfiguration : userSettings.getSerializers()) {
                if (onlyEnabled.booleanValue() && (!serializerPluginConfiguration.getEnabled().booleanValue() || !serializerPluginConfiguration.getPluginDescriptor().getEnabled().booleanValue())) continue;
                sSerializers.add(this.getBimServer().getSConverter().convertToSObject(serializerPluginConfiguration));
            }
            Collections.sort(sSerializers, new SPluginConfigurationComparator());
            ArrayList<SSerializerPluginConfiguration> arrayList = sSerializers;
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SWebModulePluginConfiguration> getAllWebModules(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            EList webModules = this.getBimServer().getServerSettingsCache().getServerSettings().getWebModules();
            List<SWebModulePluginConfiguration> serializers = this.getBimServer().getSConverter().convertToSListWebModulePluginConfiguration((Collection<WebModulePluginConfiguration>)webModules);
            Collections.sort(serializers, new SPluginConfigurationComparator());
            List<SWebModulePluginConfiguration> list = serializers;
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerializer(SSerializerPluginConfiguration serializer) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SerializerPluginConfiguration convert = this.getBimServer().getSConverter().convertFromSObject(serializer, session);
            session.executeAndCommitAction(new AddSerializerDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), convert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRenderEnginePluginConfiguration getDefaultRenderEngine() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings settings = this.getUserSettings(session);
            SRenderEnginePluginConfiguration sRenderEnginePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(settings.getDefaultRenderEngine());
            return sRenderEnginePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQueryEnginePluginConfiguration getDefaultQueryEngine() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings settings = this.getUserSettings(session);
            SQueryEnginePluginConfiguration sQueryEnginePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(settings.getDefaultQueryEngine());
            return sQueryEnginePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelComparePluginConfiguration getDefaultModelCompare() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings settings = this.getUserSettings(session);
            SModelComparePluginConfiguration sModelComparePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(settings.getDefaultModelCompare());
            return sModelComparePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelMergerPluginConfiguration getDefaultModelMerger() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings settings = this.getUserSettings(session);
            SModelMergerPluginConfiguration sModelMergerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(settings.getDefaultModelMerger());
            return sModelMergerPluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSerializerPluginConfiguration getDefaultSerializer() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings settings = this.getUserSettings(session);
            SSerializerPluginConfiguration sSerializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(settings.getDefaultSerializer());
            return sSerializerPluginConfiguration;
        }
    }

    public SWebModulePluginConfiguration getDefaultWebModule() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        WebModulePluginConfiguration defaultWebModule = this.getBimServer().getServerSettingsCache().getServerSettings().getWebModule();
        return this.getBimServer().getSConverter().convertToSObject(defaultWebModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SObjectIDMPluginConfiguration getDefaultObjectIDM() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings settings = this.getUserSettings(session);
            SObjectIDMPluginConfiguration sObjectIDMPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(settings.getDefaultObjectIDM());
            return sObjectIDMPluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SObjectType getPluginSettings(Long poid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            PluginConfiguration pluginConfiguration = (PluginConfiguration)session.get(StorePackage.eINSTANCE.getPluginConfiguration(), (long)poid, (QueryInterface)OldQuery.getDefault());
            ObjectType settings = pluginConfiguration.getSettings();
            SObjectType sObjectType = this.getBimServer().getSConverter().convertToSObject(settings);
            return sObjectType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRenderEngine(final Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetUserSettingDatabaseAction action = new SetUserSettingDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), new UserSettingsSetter(){

                @Override
                public void set(UserSettings userSettings) {
                    userSettings.setDefaultRenderEngine((RenderEnginePluginConfiguration)PluginServiceImpl.this.find((List)userSettings.getRenderEngines(), oid));
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultQueryEngine(final Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetUserSettingDatabaseAction action = new SetUserSettingDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), new UserSettingsSetter(){

                @Override
                public void set(UserSettings userSettings) {
                    userSettings.setDefaultQueryEngine((QueryEnginePluginConfiguration)PluginServiceImpl.this.find((List)userSettings.getQueryEngines(), oid));
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public void setDefaultWebModule(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            this.getBimServer().getWebModuleManager().setDefault(oid);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SSerializerPluginConfiguration> getAllSerializersForRoids(Boolean onlyEnabled, Set<Long> roids) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            HashSet<Schema> uniqueSchemas = new HashSet<Schema>();
            for (Long roid : roids) {
                Revision revision = (Revision)session.get(roid, OldQuery.getDefault());
                for (ConcreteRevision concreteRevision : revision.getConcreteRevisions()) {
                    uniqueSchemas.add(Schema.valueOf((String)concreteRevision.getProject().getSchema().toUpperCase()));
                }
            }
            HashSet<Schema> schemaOr = new HashSet<Schema>();
            if (uniqueSchemas.size() != 0) {
                if (uniqueSchemas.size() == 1) {
                    Schema schema = (Schema)uniqueSchemas.iterator().next();
                    schemaOr.add(schema);
                    for (Schema target : this.getBimServer().getSchemaConverterManager().getSchemaTargets(schema)) {
                        schemaOr.add(target);
                    }
                } else if (uniqueSchemas.size() == 2) {
                    Iterator iterator = uniqueSchemas.iterator();
                    Schema schema1 = (Schema)iterator.next();
                    Schema schema2 = (Schema)iterator.next();
                    SchemaConverterFactory converter1 = this.getBimServer().getSchemaConverterManager().getSchemaConverterFactory(schema1, schema2);
                    SchemaConverterFactory converter2 = this.getBimServer().getSchemaConverterManager().getSchemaConverterFactory(schema2, schema1);
                    if (converter1 != null) {
                        schemaOr.add(schema1);
                    }
                    if (converter2 != null) {
                        schemaOr.add(schema2);
                    }
                } else {
                    throw new ServerException("Unimplemented, no support for > 2 schemas");
                }
            }
            UserSettings userSettings = this.getUserSettings(session);
            ArrayList<SSerializerPluginConfiguration> sSerializers = new ArrayList<SSerializerPluginConfiguration>();
            block8: for (SerializerPluginConfiguration serializerPluginConfiguration : userSettings.getSerializers()) {
                Plugin plugin = this.getBimServer().getPluginManager().getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
                if (plugin instanceof SerializerPlugin) {
                    SerializerPlugin serializerPlugin = this.getBimServer().getPluginManager().getSerializerPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
                    for (Schema schema : serializerPlugin.getSupportedSchemas()) {
                        if (!schemaOr.contains(schema) || onlyEnabled.booleanValue() && (!serializerPluginConfiguration.getEnabled().booleanValue() || !serializerPluginConfiguration.getPluginDescriptor().getEnabled().booleanValue())) continue;
                        sSerializers.add(this.getBimServer().getSConverter().convertToSObject(serializerPluginConfiguration));
                        continue block8;
                    }
                    continue;
                }
                if (!(plugin instanceof StreamingSerializerPlugin)) continue;
                StreamingSerializerPlugin streamingSerializerPlugin = (StreamingSerializerPlugin)plugin;
                for (Schema schema : streamingSerializerPlugin.getSupportedSchemas()) {
                    if (!schemaOr.contains(schema) || onlyEnabled.booleanValue() && (!serializerPluginConfiguration.getEnabled().booleanValue() || !serializerPluginConfiguration.getPluginDescriptor().getEnabled().booleanValue())) continue;
                    sSerializers.add(this.getBimServer().getSConverter().convertToSObject(serializerPluginConfiguration));
                    continue block8;
                }
            }
            Collections.sort(sSerializers, new SPluginConfigurationComparator());
            ArrayList<SSerializerPluginConfiguration> arrayList = sSerializers;
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultModelCompare(final Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetUserSettingDatabaseAction action = new SetUserSettingDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), new UserSettingsSetter(){

                @Override
                public void set(UserSettings userSettings) {
                    userSettings.setDefaultModelCompare((ModelComparePluginConfiguration)PluginServiceImpl.this.find((List)userSettings.getModelCompares(), oid));
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultModelMerger(final Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetUserSettingDatabaseAction action = new SetUserSettingDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), new UserSettingsSetter(){

                @Override
                public void set(UserSettings userSettings) {
                    userSettings.setDefaultModelMerger((ModelMergerPluginConfiguration)PluginServiceImpl.this.find((List)userSettings.getModelMergers(), oid));
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    private <T extends IdEObject> T find(List<T> list, long oid) {
        for (IdEObject t : list) {
            if (t.getOid() != oid) continue;
            return (T)t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultSerializer(final Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetUserSettingDatabaseAction action = new SetUserSettingDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), new UserSettingsSetter(){

                @Override
                public void set(UserSettings userSettings) {
                    userSettings.setDefaultSerializer((SerializerPluginConfiguration)PluginServiceImpl.this.find((List)userSettings.getSerializers(), oid));
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultObjectIDM(final Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetUserSettingDatabaseAction action = new SetUserSettingDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), new UserSettingsSetter(){

                @Override
                public void set(UserSettings userSettings) {
                    userSettings.setDefaultObjectIDM((ObjectIDMPluginConfiguration)PluginServiceImpl.this.find((List)userSettings.getObjectIDMs(), oid));
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SDeserializerPluginConfiguration> getAllDeserializers(Boolean onlyEnabled) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            EList deserializers = userSettings.getDeserializers();
            ArrayList<SDeserializerPluginConfiguration> sDeserializers = new ArrayList<SDeserializerPluginConfiguration>();
            for (DeserializerPluginConfiguration deserializerPluginConfiguration : deserializers) {
                if (onlyEnabled.booleanValue() && (!deserializerPluginConfiguration.getEnabled().booleanValue() || !deserializerPluginConfiguration.getPluginDescriptor().getEnabled().booleanValue())) continue;
                sDeserializers.add(this.getBimServer().getSConverter().convertToSObject(deserializerPluginConfiguration));
            }
            Collections.sort(sDeserializers, new SPluginConfigurationComparator());
            ArrayList<SDeserializerPluginConfiguration> arrayList = sDeserializers;
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWebModulePluginConfiguration getWebModuleById(Long oid) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SWebModulePluginConfiguration sWebModulePluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetWebModuleByIdDatabaseAction(session, this.getInternalAccessMethod(), oid)));
            return sWebModulePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSerializerPluginConfiguration getSerializerByPluginClassName(String pluginClassName) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SSerializerPluginConfiguration sSerializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetSerializerByPluginClassNameDatabaseAction(session, this.getAuthorization(), this.getInternalAccessMethod(), pluginClassName)));
            return sSerializerPluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMessagingSerializerPluginConfiguration getMessagingSerializerByPluginClassName(String pluginClassName) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SMessagingSerializerPluginConfiguration sMessagingSerializerPluginConfiguration = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(new GetMessagingSerializerByPluginClassNameDatabaseAction(session, this.getAuthorization(), this.getInternalAccessMethod(), pluginClassName)));
            return sMessagingSerializerPluginConfiguration;
        }
    }

    public Boolean hasActiveSerializer(String contentType) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            SPluginDescriptor pluginDescriptor;
            SSerializerPluginConfiguration serializer = this.getServiceMap().getBimsie1ServiceInterface().getSerializerByContentType(contentType);
            if (serializer != null && serializer.getEnabled().booleanValue() && (pluginDescriptor = this.getServiceMap().getPluginInterface().getPluginDescriptor(Long.valueOf(serializer.getPluginDescriptorId()))).getEnabled().booleanValue()) {
                return this.getBimServer().getPluginManager().isEnabled(pluginDescriptor.getPluginClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public SSerializerPluginDescriptor getSerializerPluginDescriptor(String type) throws UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getSerializerFactory().getSerializerPluginDescriptor(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SInternalServicePluginConfiguration getInternalServiceById(Long oid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SInternalServicePluginConfiguration convertToSObject;
            SInternalServicePluginConfiguration sInternalServicePluginConfiguration = convertToSObject = this.getBimServer().getSConverter().convertToSObject((InternalServicePluginConfiguration)session.executeAndCommitAction(new GetByIdDatabaseAction(session, this.getInternalAccessMethod(), oid, StorePackage.eINSTANCE.getInternalServicePluginConfiguration())));
            return sInternalServicePluginConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInternalService(SInternalServicePluginConfiguration internalService) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            InternalServicePluginConfiguration convertFromSObject = this.getBimServer().getSConverter().convertFromSObject(internalService, session);
            session.executeAndCommitAction(new UpdateDatabaseAction<InternalServicePluginConfiguration>(session, this.getInternalAccessMethod(), convertFromSObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalService(SInternalServicePluginConfiguration internalService) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.executeAndCommitAction(new AddInternalServiceDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), this.getBimServer().getSConverter().convertFromSObject(internalService, session)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInternalService(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.executeAndCommitAction(new DeleteInternalServiceDatabaseAction(session, this.getInternalAccessMethod(), oid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SInternalServicePluginConfiguration> getAllInternalServices(Boolean onlyEnabled) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserSettings userSettings = this.getUserSettings(session);
            EList services2 = userSettings.getServices();
            List<SInternalServicePluginConfiguration> services = this.getBimServer().getSConverter().convertToSListInternalServicePluginConfiguration((Collection<InternalServicePluginConfiguration>)services2);
            Collections.sort(services, new SPluginConfigurationComparator());
            List<SInternalServicePluginConfiguration> list = services;
            return list;
        }
    }

    public List<SObjectIDMPluginDescriptor> getAllObjectIDMPluginDescriptors() throws UserException {
        this.requireRealUserAuthentication();
        Collection allObjectIDMs = this.getBimServer().getPluginManager().getAllObjectIDMPlugins(true).values();
        ArrayList<SObjectIDMPluginDescriptor> descriptors = new ArrayList<SObjectIDMPluginDescriptor>();
        for (ObjectIDMPlugin ObjectIDMPlugin2 : allObjectIDMs) {
            SObjectIDMPluginDescriptor descriptor = new SObjectIDMPluginDescriptor();
            descriptor.setClassName(ObjectIDMPlugin2.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPluginDescriptor getPluginDescriptor(Long oid) throws ServerException, UserException {
        if (oid == -1L) {
            return null;
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            PluginDescriptor pluginDescriptor = (PluginDescriptor)session.get(oid, OldQuery.getDefault());
            SPluginDescriptor sPluginDescriptor = this.getBimServer().getSConverter().convertToSObject(pluginDescriptor);
            return sPluginDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SDeserializerPluginConfiguration> getAllDeserializersForProject(Boolean onlyEnabled, Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Project project = (Project)session.get(poid, OldQuery.getDefault());
            UserSettings userSettings = this.getUserSettings(session);
            EList deserializers = userSettings.getDeserializers();
            ArrayList<SDeserializerPluginConfiguration> sDeserializers = new ArrayList<SDeserializerPluginConfiguration>();
            for (DeserializerPluginConfiguration deserializerPluginConfiguration : deserializers) {
                DeserializerPlugin plugin = this.getBimServer().getPluginManager().getDeserializerPlugin(deserializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
                if (plugin == null) {
                    StreamingDeserializerPlugin streamingPlugin = this.getBimServer().getPluginManager().getStreamingDeserializerPlugin(deserializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
                    if (streamingPlugin == null || !streamingPlugin.getSupportedSchemas().contains(Schema.valueOf((String)project.getSchema().toUpperCase())) || onlyEnabled.booleanValue() && (!deserializerPluginConfiguration.getEnabled().booleanValue() || !deserializerPluginConfiguration.getPluginDescriptor().getEnabled().booleanValue())) continue;
                    sDeserializers.add(this.getBimServer().getSConverter().convertToSObject(deserializerPluginConfiguration));
                    continue;
                }
                if (!plugin.getSupportedSchemas().contains(Schema.valueOf((String)project.getSchema().toUpperCase())) || onlyEnabled.booleanValue() && (!deserializerPluginConfiguration.getEnabled().booleanValue() || !deserializerPluginConfiguration.getPluginDescriptor().getEnabled().booleanValue())) continue;
                sDeserializers.add(this.getBimServer().getSConverter().convertToSObject(deserializerPluginConfiguration));
            }
            Collections.sort(sDeserializers, new SPluginConfigurationComparator());
            ArrayList<SDeserializerPluginConfiguration> arrayList = sDeserializers;
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SPluginBundle> getAvailablePluginBundles() throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<SPluginBundle> list = session.executeAndCommitAction(new GetAvailablePluginBundles(session, this.getInternalAccessMethod(), this.getBimServer(), this.getBimServer().getServerSettingsCache().getServerSettings().isPluginStrictVersionChecking()));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPluginBundle(String repository, String groupId, String artifactId, String version, List<SPluginInformation> plugins) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.executeAndCommitAction(new InstallPlugin(session, this.getInternalAccessMethod(), this.getBimServer(), repository, groupId, artifactId, version, plugins));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SPluginBundle> getInstalledPluginBundles() throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<SPluginBundle> list = session.executeAndCommitAction(new GetInstalledPluginBundles(session, this.getInternalAccessMethod(), this.getBimServer(), this.getBimServer().getServerSettingsCache().getServerSettings().isPluginStrictVersionChecking()));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallPluginBundle(String repository, String groupId, String artifactId, String version) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.executeAndCommitAction(new UninstallPlugin(session, this.getInternalAccessMethod(), this.getBimServer(), repository, groupId, artifactId, version));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SPluginInformation> getPluginInformation(String repository, String groupId, String artifactId, String version) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<SPluginInformation> list = session.executeAndCommitAction(new GetPluginInformation(session, this.getInternalAccessMethod(), this.getBimServer(), repository, groupId, artifactId, version));
            return list;
        }
    }
}

