/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.bimserver.BimServerImporter;
import org.bimserver.client.json.JsonBimServerClientFactory;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AddExtendedDataSchemaDatabaseAction;
import org.bimserver.database.actions.AddExtendedDataToProjectDatabaseAction;
import org.bimserver.database.actions.AddLocalServiceToProjectDatabaseAction;
import org.bimserver.database.actions.AddModelCheckerDatabaseAction;
import org.bimserver.database.actions.AddModelCheckerToProjectDatabaseAction;
import org.bimserver.database.actions.AddServiceToProjectDatabaseAction;
import org.bimserver.database.actions.AddUserDatabaseAction;
import org.bimserver.database.actions.AddUserToExtendedDataSchemaDatabaseAction;
import org.bimserver.database.actions.AddUserToProjectDatabaseAction;
import org.bimserver.database.actions.ChangeUserTypeDatabaseAction;
import org.bimserver.database.actions.CheckinDatabaseAction;
import org.bimserver.database.actions.CompareDatabaseAction;
import org.bimserver.database.actions.DeleteServiceDatabaseAction;
import org.bimserver.database.actions.DeleteUserDatabaseAction;
import org.bimserver.database.actions.GetAllAuthorizedUsersOfProjectDatabaseAction;
import org.bimserver.database.actions.GetAllCheckoutsByUserDatabaseAction;
import org.bimserver.database.actions.GetAllCheckoutsOfProjectDatabaseAction;
import org.bimserver.database.actions.GetAllCheckoutsOfRevisionDatabaseAction;
import org.bimserver.database.actions.GetAllExtendedDataSchemasDatabaseAction;
import org.bimserver.database.actions.GetAllModelCheckersDatabaseAction;
import org.bimserver.database.actions.GetAllNonAuthorizedProjectsOfUserDatabaseAction;
import org.bimserver.database.actions.GetAllNonAuthorizedUsersOfProjectDatabaseAction;
import org.bimserver.database.actions.GetAllReadableProjectsDatabaseAction;
import org.bimserver.database.actions.GetAllRelatedProjectsDatabaseAction;
import org.bimserver.database.actions.GetAllRevisionsByUserDatabaseAction;
import org.bimserver.database.actions.GetAllServicesOfProjectDatabaseAction;
import org.bimserver.database.actions.GetAllUsersDatabaseAction;
import org.bimserver.database.actions.GetAllWritableProjectsDatabaseAction;
import org.bimserver.database.actions.GetAreaDatabaseAction;
import org.bimserver.database.actions.GetAvailableClassesDatabaseAction;
import org.bimserver.database.actions.GetAvailableClassesInRevisionDatabaseAction;
import org.bimserver.database.actions.GetCheckinWarningsDatabaseAction;
import org.bimserver.database.actions.GetCheckoutWarningsDatabaseAction;
import org.bimserver.database.actions.GetGeoTagDatabaseAction;
import org.bimserver.database.actions.GetGeometryInfoDatabaseAction;
import org.bimserver.database.actions.GetIfcHeaderDatabaseAction;
import org.bimserver.database.actions.GetModelCheckerOidDatabaseAction;
import org.bimserver.database.actions.GetNrPrimitivesDatabaseAction;
import org.bimserver.database.actions.GetOidByGuidDatabaseAction;
import org.bimserver.database.actions.GetProjectsOfUserDatabaseAction;
import org.bimserver.database.actions.GetRevisionSummaryDatabaseAction;
import org.bimserver.database.actions.GetUserByUoidDatabaseAction;
import org.bimserver.database.actions.GetUserByUserNameDatabaseAction;
import org.bimserver.database.actions.GetVolumeDatabaseAction;
import org.bimserver.database.actions.RemoveModelCheckerFromProjectDatabaseAction;
import org.bimserver.database.actions.RemoveServiceFromProjectDatabaseAction;
import org.bimserver.database.actions.RemoveUserFromExtendedDataSchemaDatabaseAction;
import org.bimserver.database.actions.RemoveUserFromProjectDatabaseAction;
import org.bimserver.database.actions.SetRevisionTagDatabaseAction;
import org.bimserver.database.actions.StreamingCheckinDatabaseAction;
import org.bimserver.database.actions.UndeleteUserDatabaseAction;
import org.bimserver.database.actions.UpdateGeoTagDatabaseAction;
import org.bimserver.database.actions.UpdateModelCheckerDatabaseAction;
import org.bimserver.database.actions.UpdateProjectDatabaseAction;
import org.bimserver.database.actions.UpdateRevisionDatabaseAction;
import org.bimserver.database.actions.UploadFileDatabaseAction;
import org.bimserver.database.actions.UserHasCheckinRightsDatabaseAction;
import org.bimserver.database.actions.UserHasRightsDatabaseAction;
import org.bimserver.database.actions.ValidateModelCheckerDatabaseAction;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.literals.StringLiteral;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.objects.SAccessMethod;
import org.bimserver.interfaces.objects.SCheckout;
import org.bimserver.interfaces.objects.SCompareResult;
import org.bimserver.interfaces.objects.SCompareType;
import org.bimserver.interfaces.objects.SExtendedData;
import org.bimserver.interfaces.objects.SExtendedDataAddedToRevision;
import org.bimserver.interfaces.objects.SExtendedDataSchema;
import org.bimserver.interfaces.objects.SExtendedDataSchemaType;
import org.bimserver.interfaces.objects.SFile;
import org.bimserver.interfaces.objects.SGeoTag;
import org.bimserver.interfaces.objects.SGeometryInfo;
import org.bimserver.interfaces.objects.SIfcHeader;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.interfaces.objects.SModelCheckerInstance;
import org.bimserver.interfaces.objects.SPluginDescriptor;
import org.bimserver.interfaces.objects.SProfileDescriptor;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SProjectSmall;
import org.bimserver.interfaces.objects.SQueryEnginePluginConfiguration;
import org.bimserver.interfaces.objects.SRevision;
import org.bimserver.interfaces.objects.SRevisionSummary;
import org.bimserver.interfaces.objects.SService;
import org.bimserver.interfaces.objects.SServiceDescriptor;
import org.bimserver.interfaces.objects.STrigger;
import org.bimserver.interfaces.objects.SUser;
import org.bimserver.interfaces.objects.SUserSettings;
import org.bimserver.interfaces.objects.SUserType;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.longaction.LongCheckinAction;
import org.bimserver.longaction.LongStreamingCheckinAction;
import org.bimserver.mail.EmailMessage;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.log.LogAction;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.DeserializerPluginConfiguration;
import org.bimserver.models.store.ExtendedData;
import org.bimserver.models.store.ExtendedDataSchema;
import org.bimserver.models.store.File;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.ModelCheckerInstance;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.ObjectType;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.RevisionSummary;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.notifications.NewExtendedDataOnRevisionNotification;
import org.bimserver.notifications.NewRevisionNotification;
import org.bimserver.notifications.ProgressOnProjectTopic;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.deserializers.Deserializer;
import org.bimserver.plugins.deserializers.DeserializerPlugin;
import org.bimserver.plugins.deserializers.StreamingDeserializer;
import org.bimserver.plugins.deserializers.StreamingDeserializerPlugin;
import org.bimserver.plugins.queryengine.QueryEnginePlugin;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.shared.compare.CompareWriter;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.utils.MultiplexingInputStream;
import org.bimserver.utils.NetUtils;
import org.bimserver.webservices.CheckoutComparator;
import org.bimserver.webservices.SRevisionComparator;
import org.bimserver.webservices.SServiceComparator;
import org.bimserver.webservices.SUserComparator;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.bimserver.webservices.impl.Bimsie1ServiceImpl;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImpl
extends GenericServiceImpl
implements ServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceImpl.class);

    public ServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public Long initiateCheckin(Long poid, Long deserializerOid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            Project project = (Project)session.get(poid, OldQuery.getDefault());
            if (!this.getAuthorization().hasRightsOnProjectOrSuperProjects(user, project)) {
                throw new UserException("User has no rights to checkin models to this project");
            }
            if (!MailSystem.isValidEmailAddress(user.getUsername())) {
                throw new UserException("Users must have a valid e-mail address to checkin");
            }
            if (project == null) {
                throw new UserException("No project found with poid " + poid);
            }
            ProgressOnProjectTopic progressTopic = this.getBimServer().getNotificationsManager().createProgressOnProjectTopic(this.getAuthorization().getUoid(), poid, SProgressTopicType.UPLOAD, "Checkin");
            Long l = progressTopic.getKey().getId();
            return l;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long checkinInitiated(Long topicId, Long poid, String comment, Long deserializerOid, Long fileSize, String fileName, DataHandler dataHandler, Boolean merge, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        String username = "Unknown";
        String userUsername = "Unknown";
        try {
            Path userDirIncoming;
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            Project project = (Project)session.get(poid, OldQuery.getDefault());
            if (project == null) {
                throw new UserException("No project found with poid " + poid);
            }
            username = user.getName();
            userUsername = user.getUsername();
            Path homeDirIncoming = this.getBimServer().getHomeDir().resolve("incoming");
            if (!Files.isDirectory(homeDirIncoming, new LinkOption[0])) {
                Files.createDirectory(homeDirIncoming, new FileAttribute[0]);
            }
            if (!Files.exists(userDirIncoming = homeDirIncoming.resolve(userUsername), new LinkOption[0])) {
                Files.createDirectories(userDirIncoming, new FileAttribute[0]);
            }
            if (fileName.contains("/")) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            }
            if (fileName.contains("\\")) {
                fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            String cacheFileName = dateFormat.format(new Date()) + "-" + fileName;
            Path file = userDirIncoming.resolve(cacheFileName);
            DeserializerPluginConfiguration deserializerPluginConfiguration = (DeserializerPluginConfiguration)session.get(StorePackage.eINSTANCE.getDeserializerPluginConfiguration(), (long)deserializerOid, (QueryInterface)OldQuery.getDefault());
            if (deserializerPluginConfiguration == null) {
                throw new UserException("Deserializer with oid " + deserializerOid + " not found");
            }
            Plugin plugin = this.getBimServer().getPluginManager().getPlugin(deserializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
            if (plugin == null) throw new UserException("No (enabled) (streaming) deserializer found with oid " + deserializerOid);
            if (plugin instanceof DeserializerPlugin) {
                DeserializerPlugin deserializerPlugin = (DeserializerPlugin)plugin;
                ObjectType settings = deserializerPluginConfiguration.getSettings();
                Deserializer deserializer = deserializerPlugin.createDeserializer(new PluginConfiguration(settings));
                OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
                MultiplexingInputStream inputStream = new MultiplexingInputStream(dataHandler.getInputStream(), outputStream);
                deserializer.init(this.getBimServer().getDatabase().getMetaDataManager().getPackageMetaData(project.getSchema()));
                IfcModelInterface model = deserializer.read((InputStream)inputStream, fileName, fileSize.longValue(), null);
                CheckinDatabaseAction checkinDatabaseAction = new CheckinDatabaseAction(this.getBimServer(), null, this.getInternalAccessMethod(), poid, this.getAuthorization(), model, comment, fileName, merge);
                LongCheckinAction longAction = new LongCheckinAction(topicId, this.getBimServer(), username, userUsername, this.getAuthorization(), checkinDatabaseAction);
                this.getBimServer().getLongActionManager().start(longAction);
                if (sync.booleanValue()) {
                    longAction.waitForCompletion();
                }
                Long l = longAction.getProgressTopic().getKey().getId();
                return l;
            }
            if (plugin instanceof StreamingDeserializerPlugin) {
                StreamingDeserializerPlugin streaminDeserializerPlugin = (StreamingDeserializerPlugin)plugin;
                ObjectType settings = deserializerPluginConfiguration.getSettings();
                StreamingDeserializer streamingDeserializer = streaminDeserializerPlugin.createDeserializer(new PluginConfiguration(settings));
                streamingDeserializer.init(this.getBimServer().getMetaDataManager().getPackageMetaData("ifc2x3tc1"));
                OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
                MultiplexingInputStream inputStream = new MultiplexingInputStream(dataHandler.getInputStream(), outputStream);
                StreamingCheckinDatabaseAction checkinDatabaseAction = new StreamingCheckinDatabaseAction(this.getBimServer(), null, this.getInternalAccessMethod(), poid, this.getAuthorization(), comment, fileName, (InputStream)inputStream, streamingDeserializer);
                LongStreamingCheckinAction longAction = new LongStreamingCheckinAction(topicId, this.getBimServer(), username, userUsername, this.getAuthorization(), checkinDatabaseAction);
                this.getBimServer().getLongActionManager().start(longAction);
                if (sync.booleanValue()) {
                    longAction.waitForCompletion();
                }
                Long l = longAction.getProgressTopic().getKey().getId();
                return l;
            }
            try {
                throw new UserException("No (enabled) (streaming) deserializer found with oid " + deserializerOid);
            }
            catch (UserException e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                throw new ServerException(e);
            }
        }
        finally {
            session.close();
        }
    }

    public Long checkin(Long poid, String comment, Long deserializerOid, Long fileSize, String fileName, DataHandler dataHandler, Boolean merge, Boolean sync) throws ServerException, UserException {
        Long topicId = this.initiateCheckin(poid, deserializerOid);
        this.checkinInitiated(topicId, poid, comment, deserializerOid, fileSize, fileName, dataHandler, merge, sync);
        return topicId;
    }

    public Long checkinFromUrl(Long poid, String comment, Long deserializerOid, String fileName, String urlString, Boolean merge, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        String username = "Unknown";
        String userUsername = "Unknown";
        try {
            Path userDirIncoming;
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            username = user.getName();
            userUsername = user.getUsername();
            Path homeDirIncoming = this.getBimServer().getHomeDir().resolve("incoming");
            if (!Files.isDirectory(homeDirIncoming, new LinkOption[0])) {
                Files.createDirectory(homeDirIncoming, new FileAttribute[0]);
            }
            if (!Files.exists(userDirIncoming = homeDirIncoming.resolve(userUsername), new LinkOption[0])) {
                Files.createDirectory(userDirIncoming, new FileAttribute[0]);
            }
            URL url = new URL(urlString);
            URLConnection openConnection = url.openConnection();
            InputStream input = openConnection.getInputStream();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            if (fileName == null) {
                fileName = urlString.contains("/") ? urlString.substring(urlString.lastIndexOf("/") + 1) : urlString;
                fileName = URLDecoder.decode(fileName, Charsets.UTF_8.name());
            } else {
                fileName = dateFormat.format(new Date()) + "-" + fileName;
            }
            Path file = userDirIncoming.resolve(fileName);
            DeserializerPluginConfiguration deserializerPluginConfiguration = (DeserializerPluginConfiguration)session.get(StorePackage.eINSTANCE.getDeserializerPluginConfiguration(), (long)deserializerOid, (QueryInterface)OldQuery.getDefault());
            if (deserializerPluginConfiguration == null) {
                throw new UserException("Deserializer with oid " + deserializerOid + " not found");
            }
            OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
            MultiplexingInputStream inputStream = new MultiplexingInputStream(input, outputStream);
            DeserializerPlugin deserializerPlugin = (DeserializerPlugin)this.getBimServer().getPluginManager().getPlugin(deserializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
            ObjectType settings = deserializerPluginConfiguration.getSettings();
            Deserializer deserializer = deserializerPlugin.createDeserializer(new PluginConfiguration(settings));
            deserializer.init(this.getBimServer().getDatabase().getMetaDataManager().getPackageMetaData("ifc2x3tc1"));
            IfcModelInterface model = deserializer.read((InputStream)inputStream, fileName, 0L, null);
            CheckinDatabaseAction checkinDatabaseAction = new CheckinDatabaseAction(this.getBimServer(), null, this.getInternalAccessMethod(), poid, this.getAuthorization(), model, comment, fileName, merge);
            LongCheckinAction longAction = new LongCheckinAction(-1L, this.getBimServer(), username, userUsername, this.getAuthorization(), checkinDatabaseAction);
            this.getBimServer().getLongActionManager().start(longAction);
            if (sync.booleanValue()) {
                longAction.waitForCompletion();
            }
            Long l = longAction.getProgressTopic().getKey().getId();
            return l;
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("", e);
            throw new ServerException(e);
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser addUser(String username, String name, SUserType type, Boolean selfRegistration, String resetUrl) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            if (selfRegistration.booleanValue()) {
                this.requireSelfregistrationAllowed();
            } else if (!this.getBimServer().getServerSettingsCache().getServerSettings().getAllowSelfRegistration().booleanValue()) {
                this.requireRealUserAuthentication();
            }
            AddUserDatabaseAction action = new AddUserDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), username, name, this.getBimServer().getSConverter().convertFromSObject(type), this.getAuthorization(), selfRegistration, resetUrl);
            SUser sUser = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser addUserWithPassword(String username, String password, String name, SUserType type, Boolean selfRegistration, String resetUrl) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            if (selfRegistration.booleanValue()) {
                this.requireSelfregistrationAllowed();
            } else if (!this.getBimServer().getServerSettingsCache().getServerSettings().getAllowSelfRegistration().booleanValue()) {
                this.requireRealUserAuthentication();
            }
            AddUserDatabaseAction action = new AddUserDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), username, password, name, this.getBimServer().getSConverter().convertFromSObject(type), this.getAuthorization(), selfRegistration, resetUrl);
            SUser sUser = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean addUserToProject(Long uoid, Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddUserToProjectDatabaseAction action = new AddUserToProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), uoid, poid);
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SService> getAllServicesOfProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllServicesOfProjectDatabaseAction action = new GetAllServicesOfProjectDatabaseAction(session, this.getInternalAccessMethod(), poid);
            List<SService> convertToSListRevision = this.getBimServer().getSConverter().convertToSListService((Collection<Service>)session.executeAndCommitAction(action));
            Collections.sort(convertToSListRevision, new SServiceComparator());
            List<SService> list = convertToSListRevision;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SCheckout> getAllCheckoutsOfProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllCheckoutsOfProjectDatabaseAction action = new GetAllCheckoutsOfProjectDatabaseAction(session, this.getInternalAccessMethod(), poid, false);
            List<Checkout> list = session.executeAndCommitAction(action);
            Collections.sort(list, new CheckoutComparator());
            List<SCheckout> list2 = this.getBimServer().getSConverter().convertToSListCheckout(list);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SCheckout> getAllCheckoutsOfProjectAndSubProjects(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllCheckoutsOfProjectDatabaseAction action = new GetAllCheckoutsOfProjectDatabaseAction(session, this.getInternalAccessMethod(), poid, true);
            List<Checkout> list = session.executeAndCommitAction(action);
            Collections.sort(list, new CheckoutComparator());
            List<SCheckout> list2 = this.getBimServer().getSConverter().convertToSListCheckout(list);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SUser> getAllUsers() throws ServerException, UserException {
        if (this.getBimServer().getServerSettingsCache().getServerSettings().getHideUserListForNonAdmin().booleanValue() && this.getCurrentUser().getUserType() != SUserType.ADMIN) {
            throw new UserException("Admin rights required to list users");
        }
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllUsersDatabaseAction action = new GetAllUsersDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization());
            List<SUser> convertToSListUser = this.getBimServer().getSConverter().convertToSListUser((Collection<User>)session.executeAndCommitAction(action));
            Collections.sort(convertToSListUser, new SUserComparator());
            List<SUser> list = convertToSListUser;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SCheckout> getAllCheckoutsByUser(Long uoid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllCheckoutsByUserDatabaseAction action = new GetAllCheckoutsByUserDatabaseAction(session, this.getInternalAccessMethod(), uoid);
            List<Checkout> list = session.executeAndCommitAction(action);
            Collections.sort(list, new CheckoutComparator());
            List<SCheckout> list2 = this.getBimServer().getSConverter().convertToSListCheckout(list);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SRevision> getAllRevisionsByUser(Long uoid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllRevisionsByUserDatabaseAction action = new GetAllRevisionsByUserDatabaseAction(session, this.getInternalAccessMethod(), uoid);
            List<SRevision> convertToSListRevision = this.getBimServer().getSConverter().convertToSListRevision((Collection<Revision>)session.executeAndCommitAction(action));
            Collections.sort(convertToSListRevision, new SRevisionComparator(true));
            List<SRevision> list = convertToSListRevision;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SCheckout> getAllCheckoutsOfRevision(Long roid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllCheckoutsOfRevisionDatabaseAction action = new GetAllCheckoutsOfRevisionDatabaseAction(session, this.getInternalAccessMethod(), roid);
            List<Checkout> list = session.executeAndCommitAction(action);
            Collections.sort(list, new CheckoutComparator());
            List<SCheckout> list2 = this.getBimServer().getSConverter().convertToSListCheckout(list);
            return list2;
        }
    }

    public void cleanupLongAction(Long topicId) throws UserException, ServerException {
        this.getBimServer().getLongActionManager().remove(topicId);
    }

    public Long downloadCompareResults(Long serializerOid, Long roid1, Long roid2, Long mcid, SCompareType type, Boolean sync) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DownloadParameters downloadParameters = new DownloadParameters(this.getBimServer(), DownloadParameters.DownloadType.DOWNLOAD_COMPARE);
        downloadParameters.setModelCompareIdentifier(mcid);
        downloadParameters.setCompareType(this.getBimServer().getSConverter().convertFromSObject(type));
        downloadParameters.setSerializerOid(serializerOid);
        HashSet<Long> roids = new HashSet<Long>();
        roids.add(roid1);
        roids.add(roid2);
        downloadParameters.setRoids(roids);
        return ((Bimsie1ServiceImpl)this.getServiceMap().getBimsie1ServiceInterface()).download(downloadParameters, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean deleteUser(Long uoid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteUserDatabaseAction action = new DeleteUserDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), uoid);
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeUserFromProject(Long uoid, Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RemoveUserFromProjectDatabaseAction action = new RemoveUserFromProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), uoid, poid, this.getAuthorization());
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAvailableClasses() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAvailableClassesDatabaseAction action = new GetAvailableClassesDatabaseAction(session, this.getInternalAccessMethod());
            List<String> list = session.executeAndCommitAction(action);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getAllNonAuthorizedProjectsOfUser(Long uoid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllNonAuthorizedProjectsOfUserDatabaseAction action = new GetAllNonAuthorizedProjectsOfUserDatabaseAction(session, this.getInternalAccessMethod(), uoid);
            List<SProject> list = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser getUserByUserName(String username) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetUserByUserNameDatabaseAction action = new GetUserByUserNameDatabaseAction(session, this.getInternalAccessMethod(), username);
            SUser convert = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            if (convert == null) {
                throw new UserException("User with username \"" + username + "\" not found");
            }
            SUser sUser = convert;
            return sUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean undeleteUser(Long uoid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UndeleteUserDatabaseAction action = new UndeleteUserDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), uoid);
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProject(SProject sProject) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UpdateProjectDatabaseAction action = new UpdateProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), sProject);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRevision(SRevision sRevision) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UpdateRevisionDatabaseAction action = new UpdateRevisionDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), sRevision);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCompareResult compare(Long roid1, Long roid2, SCompareType sCompareType, Long mcid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            CompareDatabaseAction action = new CompareDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), -1L, roid1, roid2, this.getBimServer().getSConverter().convertFromSObject(sCompareType), mcid);
            SCompareResult sCompareResult = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sCompareResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRevisionSummary getRevisionSummary(Long roid) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetRevisionSummaryDatabaseAction action = new GetRevisionSummaryDatabaseAction(session, this.getInternalAccessMethod(), roid);
            RevisionSummary revisionSummary = session.executeAndCommitAction(action);
            SRevisionSummary sRevisionSummary = this.getBimServer().getSConverter().convertToSObject(revisionSummary);
            return sRevisionSummary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean userHasCheckinRights(Long uoid, Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserHasCheckinRightsDatabaseAction action = new UserHasCheckinRightsDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), uoid, poid);
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCheckoutWarnings(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetCheckoutWarningsDatabaseAction action = new GetCheckoutWarningsDatabaseAction(session, this.getInternalAccessMethod(), poid, this.getAuthorization());
            Set<String> set = session.executeAndCommitAction(action);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCheckinWarnings(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetCheckinWarningsDatabaseAction action = new GetCheckinWarningsDatabaseAction(session, this.getInternalAccessMethod(), poid, this.getAuthorization());
            Set<String> set = session.executeAndCommitAction(action);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean userHasRights(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UserHasRightsDatabaseAction action = new UserHasRightsDatabaseAction(session, this.getInternalAccessMethod(), this.getCurrentUser(session).getOid(), this.getAuthorization(), poid);
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getOidByGuid(Long roid, String guid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetOidByGuidDatabaseAction action = new GetOidByGuidDatabaseAction(session, this.getInternalAccessMethod(), roid, guid);
            Long l = session.executeAndCommitAction(action);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SGeoTag getGeoTag(Long goid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetGeoTagDatabaseAction action = new GetGeoTagDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), goid);
            SGeoTag sGeoTag = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sGeoTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGeoTag(SGeoTag sGeoTag) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UpdateGeoTagDatabaseAction action = new UpdateGeoTagDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), sGeoTag);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser getUserByUoid(Long uoid) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetUserByUoidDatabaseAction action = new GetUserByUoidDatabaseAction(session, this.getInternalAccessMethod(), uoid);
            SUser sUser = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SUser> getAllNonAuthorizedUsersOfProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        if (this.getBimServer().getServerSettingsCache().getServerSettings().getHideUserListForNonAdmin().booleanValue() && this.getCurrentUser().getUserType() != SUserType.ADMIN) {
            throw new UserException("Admin rights required to list users");
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllNonAuthorizedUsersOfProjectDatabaseAction action = new GetAllNonAuthorizedUsersOfProjectDatabaseAction(session, this.getInternalAccessMethod(), poid);
            ArrayList<SUser> arrayList = new ArrayList<SUser>(this.getBimServer().getSConverter().convertToSSetUser((Collection<User>)session.executeAndCommitAction(action)));
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SUser> getAllAuthorizedUsersOfProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllAuthorizedUsersOfProjectDatabaseAction action = new GetAllAuthorizedUsersOfProjectDatabaseAction(session, this.getInternalAccessMethod(), poid);
            ArrayList<SUser> arrayList = new ArrayList<SUser>(this.getBimServer().getSConverter().convertToSSetUser((Collection<User>)session.executeAndCommitAction(action)));
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getUsersProjects(Long uoid) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetProjectsOfUserDatabaseAction action = new GetProjectsOfUserDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization(), uoid);
            List<SProject> list = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionTag(Long roid, String tag) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetRevisionTagDatabaseAction action = new SetRevisionTagDatabaseAction(session, this.getInternalAccessMethod(), roid, tag);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUserType(Long uoid, SUserType userType) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ChangeUserTypeDatabaseAction action = new ChangeUserTypeDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), uoid, userType);
            session.executeAndCommitAction(action);
        }
    }

    private SUser getCurrentUser(DatabaseSession databaseSession) throws UserException, ServerException {
        if (this.getAuthorization() == null) {
            return null;
        }
        try {
            User user = (User)databaseSession.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            return this.getBimServer().getSConverter().convertToSObject(user);
        }
        catch (Exception e) {
            return (SUser)this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCompareEmail(SCompareType sCompareType, Long mcid, Long poid, Long roid1, Long roid2, String address) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SUser currentUser = this.getCurrentUser(session);
            Revision revision1 = (Revision)session.get(StorePackage.eINSTANCE.getRevision(), (long)roid1, (QueryInterface)OldQuery.getDefault());
            Revision revision2 = (Revision)session.get(StorePackage.eINSTANCE.getRevision(), (long)roid2, (QueryInterface)OldQuery.getDefault());
            String senderName = currentUser.getName();
            String senderAddress = currentUser.getUsername();
            if (!senderAddress.contains("@") || !senderAddress.contains(".")) {
                senderAddress = this.getBimServer().getServerSettingsCache().getServerSettings().getEmailSenderAddress();
            }
            EmailMessage message = this.getBimServer().getMailSystem().createMessage();
            try {
                InternetAddress addressFrom = new InternetAddress(senderAddress);
                addressFrom.setPersonal(senderName);
                message.setFrom(addressFrom);
                InternetAddress[] addressTo = new InternetAddress[]{new InternetAddress(address)};
                message.setRecipients(Message.RecipientType.TO, addressTo);
                message.setSubject("BIMserver Model Comparator");
                SCompareResult compareResult = this.compare(roid1, roid2, sCompareType, mcid);
                String html = CompareWriter.writeCompareResult((SCompareResult)compareResult, (int)revision1.getId(), (int)revision2.getId(), (SCompareType)sCompareType, (SProject)this.getServiceMap().getBimsie1ServiceInterface().getProjectByPoid(poid), (boolean)false);
                message.setContent(html, "text/html");
                message.send();
            }
            catch (AddressException e) {
                throw new UserException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new UserException((Throwable)e);
            }
            catch (MessagingException e) {
                throw new UserException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getAllReadableProjects() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllReadableProjectsDatabaseAction action = new GetAllReadableProjectsDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization());
            List<SProject> list = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProject> getAllWritableProjects() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllWritableProjectsDatabaseAction action = new GetAllWritableProjectsDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization());
            List<SProject> list = this.getBimServer().getSConverter().convertToSListProject((Collection<Project>)session.executeAndCommitAction(action));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAvailableClassesInRevision(Long roid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAvailableClassesInRevisionDatabaseAction action = new GetAvailableClassesInRevisionDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid);
            List<String> list = session.executeAndCommitAction(action);
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addExtendedDataSchema(SExtendedDataSchema extendedDataSchema) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ExtendedDataSchema convert = this.getBimServer().getSConverter().convertFromSObject(extendedDataSchema, session);
            Long l = session.executeAndCommitAction(new AddExtendedDataSchemaDatabaseAction(session, this.getInternalAccessMethod(), convert));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToExtendedDataSchema(Long uoid, Long edsid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddUserToExtendedDataSchemaDatabaseAction action = new AddUserToExtendedDataSchemaDatabaseAction(session, this.getInternalAccessMethod(), uoid, edsid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserFromExtendedDataSchema(Long uoid, Long edsid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RemoveUserFromExtendedDataSchemaDatabaseAction action = new RemoveUserFromExtendedDataSchemaDatabaseAction(session, this.getInternalAccessMethod(), uoid, edsid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtendedDataToProject(Long poid, SExtendedData extendedData) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ExtendedData convert = this.getBimServer().getSConverter().convertFromSObject(extendedData, session);
            session.executeAndCommitAction(new AddExtendedDataToProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), poid, convert, this.getAuthorization()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SExtendedDataSchema> getAllExtendedDataSchemas() throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<SExtendedDataSchema> serializers;
            List<SExtendedDataSchema> list = serializers = this.getBimServer().getSConverter().convertToSListExtendedDataSchema((Collection<ExtendedDataSchema>)session.executeAndCommitAction(new GetAllExtendedDataSchemasDatabaseAction(session, this.getInternalAccessMethod())));
            return list;
        }
    }

    public String getQueryEngineExample(Long qeid, String key) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        SQueryEnginePluginConfiguration queryEngineById = this.getServiceMap().getBimsie1ServiceInterface().getQueryEngineById(qeid);
        SPluginDescriptor pluginDescriptor = this.getServiceMap().getPluginInterface().getPluginDescriptor(Long.valueOf(queryEngineById.getPluginDescriptorId()));
        QueryEnginePlugin queryEngine = this.getBimServer().getPluginManager().getQueryEngine(pluginDescriptor.getPluginClassName(), true);
        return queryEngine.getExample(key);
    }

    public List<String> getQueryEngineExampleKeys(Long qeid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        SQueryEnginePluginConfiguration queryEngineById = this.getServiceMap().getBimsie1ServiceInterface().getQueryEngineById(qeid);
        SPluginDescriptor pluginDescriptor = this.getServiceMap().getPluginInterface().getPluginDescriptor(Long.valueOf(queryEngineById.getPluginDescriptorId()));
        QueryEnginePlugin queryEngine = this.getBimServer().getPluginManager().getQueryEngine(pluginDescriptor.getPluginClassName(), true);
        return new ArrayList<String>(queryEngine.getExampleKeys());
    }

    public SServiceDescriptor getServiceDescriptor(String baseUrl, String serviceIdentifier) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            JsonBimServerClientFactory factory = new JsonBimServerClientFactory(baseUrl, this.getBimServer().getServicesMap(), this.getBimServer().getJsonSocketReflectorFactory(), this.getBimServer().getReflectorFactory(), this.getBimServer().getMetaDataManager());
            BimServerClientInterface client = factory.create();
            SServiceDescriptor service = client.getRemoteServiceInterface().getService(serviceIdentifier);
            if (service == null) {
                throw new UserException("No service found with identifier " + serviceIdentifier);
            }
            service.setUrl(baseUrl);
            return service;
        }
        catch (Exception e) {
            return (SServiceDescriptor)this.handleException(e);
        }
    }

    public List<SServiceDescriptor> getAllLocalServiceDescriptors() throws ServerException, UserException {
        return this.sort(this.getBimServer().getSConverter().convertToSListServiceDescriptor(this.getBimServer().getInternalServicesManager().getInternalServices(this.getAuthorization().getUoid()).values()));
    }

    public List<SServiceDescriptor> getAllServiceDescriptors() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            ArrayList<SServiceDescriptor> sServiceDescriptors = new ArrayList<SServiceDescriptor>();
            URL url = new URL(this.getServiceMap().get(SettingsInterface.class).getServiceRepositoryUrl() + "/services.json");
            String content = NetUtils.getContent((URL)url, (int)5000);
            JSONObject root = new JSONObject(new JSONTokener(content));
            JSONArray services = root.getJSONArray("services");
            for (int i = 0; i < services.length(); ++i) {
                JSONObject service = services.getJSONObject(i);
                SServiceDescriptor sServiceDescriptor = new SServiceDescriptor();
                sServiceDescriptor.setName(service.getString("name"));
                sServiceDescriptor.setIdentifier(service.getString("identifier"));
                sServiceDescriptor.setDescription(service.getString("description"));
                sServiceDescriptor.setNotificationProtocol(SAccessMethod.valueOf((String)service.getString("notificationProtocol")));
                sServiceDescriptor.setTrigger(STrigger.valueOf((String)service.getString("trigger")));
                sServiceDescriptor.setUrl(service.getString("url"));
                sServiceDescriptor.setCompanyUrl(service.getString("companyUrl"));
                sServiceDescriptor.setTokenUrl(service.getString("tokenUrl"));
                sServiceDescriptor.setNewProfileUrl(service.getString("newProfileUrl"));
                sServiceDescriptor.setProviderName(service.getString("providerName"));
                JSONObject rights = service.getJSONObject("rights");
                sServiceDescriptor.setReadRevision(rights.has("readRevision") && rights.getBoolean("readRevision"));
                sServiceDescriptor.setReadExtendedData(rights.has("readExtendedData") ? rights.getString("readExtendedData") : null);
                sServiceDescriptor.setWriteRevision(rights.has("writeRevision") && rights.getBoolean("writeRevision"));
                sServiceDescriptor.setWriteExtendedData(rights.has("writeExtendedData") ? rights.getString("writeExtendedData") : null);
                sServiceDescriptors.add(sServiceDescriptor);
            }
            this.sort(sServiceDescriptors);
            return sServiceDescriptors;
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    private List<SServiceDescriptor> sort(List<SServiceDescriptor> sServiceDescriptors) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new Comparator<SServiceDescriptor>(){

            @Override
            public int compare(SServiceDescriptor o1, SServiceDescriptor o2) {
                return o1.getProviderName().compareTo(o2.getProviderName());
            }
        });
        comparatorChain.addComparator((Comparator)new Comparator<SServiceDescriptor>(){

            @Override
            public int compare(SServiceDescriptor o1, SServiceDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.sort(sServiceDescriptors, comparatorChain);
        return sServiceDescriptors;
    }

    public List<SExtendedDataSchema> getAllRepositoryExtendedDataSchemas() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            ArrayList<SExtendedDataSchema> extendedDataSchemas = new ArrayList<SExtendedDataSchema>();
            String content = NetUtils.getContent((URL)new URL(this.getServiceMap().get(SettingsInterface.class).getServiceRepositoryUrl() + "/extendeddataschemas.json"), (int)5000);
            JSONObject root = new JSONObject(new JSONTokener(content));
            JSONArray extendedDataSchemasJson = root.getJSONArray("extendeddataschemas");
            for (int i = 0; i < extendedDataSchemasJson.length(); ++i) {
                JSONObject extendedDataSchemaJson = extendedDataSchemasJson.getJSONObject(i);
                SExtendedDataSchema sExtendedDataSchema = new SExtendedDataSchema();
                sExtendedDataSchema.setName(extendedDataSchemaJson.getString("name"));
                sExtendedDataSchema.setNamespace(extendedDataSchemaJson.getString("namespace"));
                sExtendedDataSchema.setUrl(extendedDataSchemaJson.getString("url"));
                sExtendedDataSchema.setDescription(extendedDataSchemaJson.getString("description"));
                sExtendedDataSchema.setType(SExtendedDataSchemaType.valueOf((String)extendedDataSchemaJson.getString("type")));
                extendedDataSchemas.add(sExtendedDataSchema);
            }
            return extendedDataSchemas;
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    public List<SModelCheckerInstance> getAllRepositoryModelCheckers() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            ArrayList<SModelCheckerInstance> modelCheckers = new ArrayList<SModelCheckerInstance>();
            String content = NetUtils.getContent((URL)new URL(this.getServiceMap().get(SettingsInterface.class).getServiceRepositoryUrl() + "/modelcheckers"), (int)5000);
            JSONObject root = new JSONObject(new JSONTokener(content));
            JSONArray modelCheckersJson = root.getJSONArray("modelcheckers");
            for (int i = 0; i < modelCheckersJson.length(); ++i) {
                JSONObject modelCheckerJson = modelCheckersJson.getJSONObject(i);
                SModelCheckerInstance sModelChecker = new SModelCheckerInstance();
                sModelChecker.setName(modelCheckerJson.getString("name"));
                sModelChecker.setCode(modelCheckerJson.getString("code"));
                sModelChecker.setDescription(modelCheckerJson.getString("description"));
                sModelChecker.setModelCheckerPluginClassName(modelCheckerJson.getString("modelCheckerPluginClassName"));
                modelCheckers.add(sModelChecker);
            }
            return modelCheckers;
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SService getService(Long soid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Service externalProfile = (Service)session.get(StorePackage.eINSTANCE.getService(), (long)soid, (QueryInterface)OldQuery.getDefault());
            SService sService = this.getBimServer().getSConverter().convertToSObject(externalProfile);
            return sService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalServiceToProject(Long poid, SService sService, Long internalServiceOid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddLocalServiceToProjectDatabaseAction action = new AddLocalServiceToProjectDatabaseAction(session, this.getInternalAccessMethod(), poid, this.getBimServer().getSConverter().convertFromSObject(sService, session), internalServiceOid, this.getAuthorization());
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addServiceToProject(Long poid, SService sService) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddServiceToProjectDatabaseAction action = new AddServiceToProjectDatabaseAction(session, this.getInternalAccessMethod(), poid, this.getBimServer().getSConverter().convertFromSObject(sService, session), this.getAuthorization());
            Long l = session.executeAndCommitAction(action);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteService(Long oid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            DeleteServiceDatabaseAction action = new DeleteServiceDatabaseAction(session, this.getInternalAccessMethod(), oid);
            session.executeAndCommitAction(action);
        }
    }

    public List<SProfileDescriptor> getAllPublicProfiles(String notificationsUrl, String serviceIdentifier) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            JsonBimServerClientFactory factory = new JsonBimServerClientFactory(notificationsUrl, this.getBimServer().getServicesMap(), this.getBimServer().getJsonSocketReflectorFactory(), this.getBimServer().getReflectorFactory(), this.getBimServer().getMetaDataManager());
            BimServerClientInterface client = factory.create();
            return client.getRemoteServiceInterface().getPublicProfiles(serviceIdentifier);
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    public List<SProfileDescriptor> getAllPrivateProfiles(String notificationsUrl, String serviceIdentifier, String token) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try {
            JsonBimServerClientFactory factory = new JsonBimServerClientFactory(notificationsUrl, this.getBimServer().getServicesMap(), this.getBimServer().getJsonSocketReflectorFactory(), this.getBimServer().getReflectorFactory(), this.getBimServer().getMetaDataManager());
            BimServerClientInterface client = factory.create();
            return client.getRemoteServiceInterface().getPrivateProfiles(serviceIdentifier, token);
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProfileDescriptor> getAllLocalProfiles(String serviceIdentifier) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        ArrayList<SProfileDescriptor> descriptors = new ArrayList<SProfileDescriptor>();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SUser currentUser = this.getCurrentUser();
            AttributeCondition condition = new AttributeCondition(StorePackage.eINSTANCE.getUser_Token(), new StringLiteral(currentUser.getToken()));
            User user = session.querySingle(condition, User.class, OldQuery.getDefault());
            if (user != null) {
                for (InternalServicePluginConfiguration internalServicePluginConfiguration : user.getUserSettings().getServices()) {
                    if (!serviceIdentifier.equals("" + internalServicePluginConfiguration.getOid())) continue;
                    SProfileDescriptor sProfileDescriptor = new SProfileDescriptor();
                    descriptors.add(sProfileDescriptor);
                    sProfileDescriptor.setIdentifier("" + internalServicePluginConfiguration.getOid());
                    sProfileDescriptor.setName(internalServicePluginConfiguration.getName());
                    sProfileDescriptor.setDescription(internalServicePluginConfiguration.getDescription());
                    sProfileDescriptor.setPublicProfile(false);
                }
            }
        }
        return descriptors;
    }

    public SExtendedDataSchema getExtendedDataSchemaFromRepository(String namespace) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try {
            String content = NetUtils.getContent((URL)new URL(this.getServiceMap().get(SettingsInterface.class).getServiceRepositoryUrl() + "/extendeddataschemas?namespace=" + namespace), (int)5000);
            JSONObject root = new JSONObject(new JSONTokener(content));
            SExtendedDataSchema sExtendedDataSchema = new SExtendedDataSchema();
            sExtendedDataSchema.setName(root.getString("name"));
            sExtendedDataSchema.setNamespace(root.getString("namespace"));
            sExtendedDataSchema.setUrl(root.getString("url"));
            sExtendedDataSchema.setType(SExtendedDataSchemaType.valueOf((String)root.getString("type")));
            return sExtendedDataSchema;
        }
        catch (Exception e) {
            return (SExtendedDataSchema)this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SFile getFile(Long fileId) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            File file = (File)session.get(StorePackage.eINSTANCE.getFile(), (long)fileId, (QueryInterface)OldQuery.getDefault());
            SFile sFile = this.getBimServer().getSConverter().convertToSObject(file);
            return sFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long uploadFile(SFile file) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            File convertFromSObject = this.getBimServer().getSConverter().convertFromSObject(file, session);
            UploadFileDatabaseAction action = new UploadFileDatabaseAction(session, this.getInternalAccessMethod(), convertFromSObject);
            Long l = session.executeAndCommitAction(action);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNewExtendedData(Long edid, Long soid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ExtendedData extendedData = (ExtendedData)session.get(StorePackage.eINSTANCE.getExtendedData(), (long)edid, (QueryInterface)OldQuery.getDefault());
            SExtendedDataAddedToRevision newExtendedData = new SExtendedDataAddedToRevision();
            newExtendedData.setRevisionId(extendedData.getRevision().getOid());
            newExtendedData.setExtendedDataId(edid.longValue());
            this.getBimServer().getNotificationsManager().notify(new NewExtendedDataOnRevisionNotification(this.getBimServer(), edid, extendedData.getRevision().getProject().getOid(), extendedData.getRevision().getOid(), soid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNewRevision(Long roid, Long soid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Revision revision = (Revision)session.get(StorePackage.eINSTANCE.getRevision(), (long)roid, (QueryInterface)OldQuery.getDefault());
            this.getBimServer().getNotificationsManager().notify(new NewRevisionNotification(this.getBimServer(), revision.getProject().getOid(), revision.getOid(), soid));
        }
    }

    public String shareRevision(Long roid) throws UserException, ServerException {
        ExplicitRightsAuthorization authorization = new ExplicitRightsAuthorization(this.getBimServer(), this.getCurrentUser().getOid(), -1L, new long[]{roid}, -1L, -1L, -1L);
        return authorization.asHexToken(this.getBimServer().getEncryptionKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUserSettings getUserSettings() throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            SUserSettings sUserSettings = this.getBimServer().getSConverter().convertToSObject(user.getUserSettings());
            return sUserSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SProjectSmall> getAllRelatedProjects(Long poid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAllRelatedProjectsDatabaseAction action = new GetAllRelatedProjectsDatabaseAction(this.getBimServer(), session, this.getAuthorization(), this.getInternalAccessMethod(), poid);
            Object object = action.execute();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SLogAction> getUserRelatedLogs(Long uoid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ArrayList<LogAction> logActions = new ArrayList<LogAction>();
            User user = (User)session.get(this.getAuthorization().getUoid(), OldQuery.getDefault());
            IfcModelInterface projectsModel = session.getAllOfType(StorePackage.eINSTANCE.getProject(), OldQuery.getDefault());
            logActions.addAll((Collection<LogAction>)user.getLogs());
            for (IdEObject idEObject : projectsModel.getValues()) {
                if (!(idEObject instanceof Project)) continue;
                Project project = (Project)idEObject;
                if (user.getUserType() != UserType.ADMIN && (project.getState() != ObjectState.ACTIVE || !this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project))) continue;
                logActions.addAll((Collection<LogAction>)project.getLogs());
            }
            Collections.sort(logActions, new Comparator<LogAction>(){

                @Override
                public int compare(LogAction o1, LogAction o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
            List<SLogAction> list = this.getBimServer().getSConverter().convertToSListLogAction(logActions);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SModelCheckerInstance getModelCheckerInstance(Long mcioid) throws UserException, ServerException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetModelCheckerOidDatabaseAction action = new GetModelCheckerOidDatabaseAction(session, this.getInternalAccessMethod(), mcioid);
            SModelCheckerInstance sModelCheckerInstance = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sModelCheckerInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addModelChecker(SModelCheckerInstance modelCheckerInstance) throws UserException, ServerException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ModelCheckerInstance convert = this.getBimServer().getSConverter().convertFromSObject(modelCheckerInstance, session);
            Long l = session.executeAndCommitAction(new AddModelCheckerDatabaseAction(session, this.getInternalAccessMethod(), convert));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SModelCheckerInstance> getAllModelCheckers() throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<SModelCheckerInstance> list = this.getBimServer().getSConverter().convertToSListModelCheckerInstance((Collection<ModelCheckerInstance>)session.executeAndCommitAction(new GetAllModelCheckersDatabaseAction(session, this.getInternalAccessMethod())));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModelChecker(SModelCheckerInstance modelCheckerInstance) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            UpdateModelCheckerDatabaseAction action = new UpdateModelCheckerDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getBimServer().getSConverter().convertFromSObject(modelCheckerInstance, session));
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateModelChecker(Long oid) throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ValidateModelCheckerDatabaseAction action = new ValidateModelCheckerDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), oid);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SModelCheckerInstance> getAllModelCheckersOfProject(Long poid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Project project = (Project)session.get(poid, OldQuery.getDefault());
            List<SModelCheckerInstance> list = this.getBimServer().getSConverter().convertToSListModelCheckerInstance((Collection<ModelCheckerInstance>)project.getModelCheckers());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelCheckerToProject(Long poid, Long modelCheckerOid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ModelCheckerInstance modelChecker = (ModelCheckerInstance)session.get(modelCheckerOid, OldQuery.getDefault());
            AddModelCheckerToProjectDatabaseAction action = new AddModelCheckerToProjectDatabaseAction(session, this.getInternalAccessMethod(), poid, modelChecker, this.getAuthorization());
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelCheckerFromProject(Long poid, Long modelCheckerOid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RemoveModelCheckerFromProjectDatabaseAction action = new RemoveModelCheckerFromProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), modelCheckerOid, poid, this.getAuthorization());
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceFromProject(Long poid, Long serviceOid) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RemoveServiceFromProjectDatabaseAction action = new RemoveServiceFromProjectDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), serviceOid, poid, this.getAuthorization());
            session.executeAndCommitAction(action);
        }
    }

    public void importData(String address, String username, String password, String path) {
        new BimServerImporter(this.getBimServer(), address, username, password, path).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIfcHeader getIfcHeader(Long croid) throws UserException, ServerException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetIfcHeaderDatabaseAction action = new GetIfcHeaderDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), croid, this.getAuthorization());
            SIfcHeader sIfcHeader = session.executeAndCommitAction(action);
            return sIfcHeader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getArea(Long roid, Long oid) throws UserException, ServerException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetAreaDatabaseAction action = new GetAreaDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, oid, this.getAuthorization());
            Double d = session.executeAndCommitAction(action);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getVolume(Long roid, Long oid) throws UserException, ServerException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetVolumeDatabaseAction action = new GetVolumeDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, oid, this.getAuthorization());
            Double d = session.executeAndCommitAction(action);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SGeometryInfo getGeometryInfo(Long roid, Long oid) throws UserException, ServerException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetGeometryInfoDatabaseAction action = new GetGeometryInfoDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, oid, this.getAuthorization());
            SGeometryInfo sGeometryInfo = session.executeAndCommitAction(action);
            return sGeometryInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNrPrimitives(Long roid) throws ServerException, UserException {
        this.requireAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetNrPrimitivesDatabaseAction action = new GetNrPrimitivesDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, this.getAuthorization());
            Long l = session.executeAndCommitAction(action);
            return l;
        }
    }
}

