/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.util.Collection;
import java.util.List;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ServerSettingsSetter;
import org.bimserver.database.actions.SetServerSettingDatabaseAction;
import org.bimserver.database.actions.SetServerSettingsDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.interfaces.objects.SServerSettings;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.ServerState;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;

public class SettingsServiceImpl
extends GenericServiceImpl
implements SettingsInterface {
    public SettingsServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public String getEmailSenderAddress() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getEmailSenderAddress();
    }

    public String getServiceRepositoryUrl() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getServiceRepositoryUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceRepositoryUrl(final String url) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setServiceRepositoryUrl(url);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolBuffersPort(final Integer port) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setProtocolBuffersPort(port);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public Integer getProtocolBuffersPort() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getProtocolBuffersPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmailSenderAddress(final String emailSenderAddress) throws ServerException, UserException {
        if (this.getBimServer().getServerInfo().getServerState() != ServerState.NOT_SETUP) {
            this.requireAdminAuthentication();
        }
        if (emailSenderAddress.trim().isEmpty()) {
            throw new UserException("Email sender address cannot be empty");
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setEmailSenderAddress(emailSenderAddress);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public String getSiteAddress() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSiteAddress(final String siteAddress) throws ServerException, UserException {
        if (this.getBimServer().getServerInfo().getServerState() != ServerState.NOT_SETUP) {
            this.requireAdminAuthentication();
        }
        if (siteAddress.trim().isEmpty()) {
            throw new UserException("Site Address cannot be empty");
        }
        if (!siteAddress.startsWith("http://") && !siteAddress.startsWith("https://")) {
            throw new UserException("Site Address must start with either \"http://\" or \"https://\"");
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setSiteAddress(siteAddress);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public String getSmtpServer() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getSmtpServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmtpServer(final String smtpServer) throws ServerException, UserException {
        if (this.getBimServer().getServerInfo().getServerState() != ServerState.NOT_SETUP) {
            this.requireAdminAuthentication();
        }
        if (smtpServer.trim().isEmpty()) {
            throw new UserException("SMTP server address cannot be empty");
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setSmtpServer(smtpServer);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public Boolean isAllowSelfRegistration() throws ServerException, UserException {
        return this.getBimServer().getServerSettingsCache().getServerSettings().getAllowSelfRegistration();
    }

    public Boolean isHideUserListForNonAdmin() throws ServerException, UserException {
        this.requireAuthentication();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getHideUserListForNonAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHideUserListForNonAdmin(final Boolean hideUserListForNonAdmin) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setHideUserListForNonAdmin(hideUserListForNonAdmin);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowSelfRegistration(final Boolean allowSelfRegistration) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setAllowSelfRegistration(allowSelfRegistration);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public Boolean isAllowUsersToCreateTopLevelProjects() throws ServerException, UserException {
        this.requireAuthentication();
        return this.getBimServer().getServerSettingsCache().getServerSettings().isAllowUsersToCreateTopLevelProjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowUsersToCreateTopLevelProjects(final Boolean allowUsersToCreateTopLevelProjects) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setAllowUsersToCreateTopLevelProjects(allowUsersToCreateTopLevelProjects.booleanValue());
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public Boolean isCheckinMergingEnabled() throws ServerException, UserException {
        this.requireAuthentication();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getCheckinMergingEnabled();
    }

    public Boolean isPluginStrictVersionChecking() throws ServerException, UserException {
        this.requireAuthentication();
        return this.getBimServer().getServerSettingsCache().getServerSettings().isPluginStrictVersionChecking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckinMergingEnabled(final Boolean checkinMergingEnabled) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setCheckinMergingEnabled(checkinMergingEnabled);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public Boolean isSendConfirmationEmailAfterRegistration() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().isSendConfirmationEmailAfterRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendConfirmationEmailAfterRegistration(final Boolean sendConfirmationEmailAfterRegistration) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setSendConfirmationEmailAfterRegistration(sendConfirmationEmailAfterRegistration.booleanValue());
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    public Boolean isCacheOutputFiles() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().getCacheOutputFiles();
    }

    public Boolean isGenerateGeometryOnCheckin() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        return this.getBimServer().getServerSettingsCache().getServerSettings().isGenerateGeometryOnCheckin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheOutputFiles(final Boolean cacheOutputFiles) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setCacheOutputFiles(cacheOutputFiles);
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerateGeometryOnCheckin(final Boolean generateGeometryOnCheckin) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setGenerateGeometryOnCheckin(generateGeometryOnCheckin.booleanValue());
                }
            });
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SServerSettings getServerSettings() throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getServerSettings(), OldQuery.getDefault());
            SServerSettings sServerSettings = this.getBimServer().getSConverter().convertToSObject((ServerSettings)allOfType.getAll(ServerSettings.class).get(0));
            return sServerSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhiteListedDomains(final List<String> domains) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.getWhitelistedDomains().clear();
                    serverSettings.getWhitelistedDomains().addAll((Collection)domains);
                }
            });
            session.executeAndCommitAction(action);
            this.getBimServer().getServerSettingsCache().updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerSettings(SServerSettings serverSettings) throws ServerException, UserException {
        if (this.getBimServer().getServerInfo().getServerState() != ServerState.NOT_SETUP) {
            this.requireAdminAuthentication();
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingsDatabaseAction action = new SetServerSettingsDatabaseAction(session, this.getInternalAccessMethod(), serverSettings);
            session.executeAndCommitAction(action);
            this.getBimServer().getServerSettingsCache().updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginStrictVersionChecking(final Boolean strict) throws UserException, ServerException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setPluginStrictVersionChecking(strict.booleanValue());
                }
            });
            session.executeAndCommitAction(action);
        }
    }
}

