package org.bimserver.database.migrations.steps;

/******************************************************************************
 * Copyright (C) 2009-2016  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/

import org.bimserver.database.DatabaseSession;
import org.bimserver.database.migrations.Migration;
import org.bimserver.database.migrations.Schema;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;

public class Step0003 extends Migration {

	@Override
	public void migrate(Schema schema, DatabaseSession databaseSession) {
		EClass serviceDescriptor = schema.getEClass("store", "ServiceDescriptor");
		schema.createEAttribute(serviceDescriptor, "companyUrl", EcorePackage.eINSTANCE.getEString());
		schema.createEAttribute(serviceDescriptor, "tokenUrl", EcorePackage.eINSTANCE.getEString());
		schema.createEAttribute(serviceDescriptor, "newProfileUrl", EcorePackage.eINSTANCE.getEString());
		schema.createEAttribute(serviceDescriptor, "registerUrl", EcorePackage.eINSTANCE.getEString());
		schema.createEAttribute(serviceDescriptor, "authorizeUrl", EcorePackage.eINSTANCE.getEString());
	}

	@Override
	public String getDescription() {
		return "A few additions to the IFC2x3tc1 schema";
	}
}
