/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Authenticator {
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int SALT_BYTES = 24;
    public static final int HASH_BYTES = 24;
    public static final int PBKDF2_ITERATIONS = 1000;

    public boolean validate(String givenPassword, byte[] hash, byte[] salt) {
        try {
            byte[] testHash = Authenticator.pbkdf2(givenPassword.toCharArray(), salt, 1000, hash.length);
            return Authenticator.slowEquals(hash, testHash);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (InvalidKeySpecException e) {
            return false;
        }
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    private static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, bytes * 8);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        return skf.generateSecret(spec).getEncoded();
    }

    public byte[] createHash(String password, byte[] salt) {
        try {
            byte[] hash = Authenticator.pbkdf2(password.toCharArray(), salt, 1000, 24);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (InvalidKeySpecException e) {
            return null;
        }
    }
}

