/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.CommandLine;
import org.bimserver.EmbeddedWebServerInterface;
import org.bimserver.JobScheduler;
import org.bimserver.JsonHandler;
import org.bimserver.MergerFactory;
import org.bimserver.MetricsRegistry;
import org.bimserver.ServerInfoManager;
import org.bimserver.ServerSettingsCache;
import org.bimserver.StateChangeListener;
import org.bimserver.WebModuleManager;
import org.bimserver.cache.CompareCache;
import org.bimserver.cache.DiskCacheManager;
import org.bimserver.cache.NewDiskCacheManager;
import org.bimserver.client.DirectBimServerClientFactory;
import org.bimserver.client.json.JsonSocketReflectorFactory;
import org.bimserver.client.protocolbuffers.ProtocolBuffersBimServerClientFactory;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.berkeley.BerkeleyKeyValueStore;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.database.migrations.InconsistentModelsException;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.literals.StringLiteral;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.endpoints.EndPointManager;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SInternalServicePluginConfiguration;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.interfaces.objects.SVersion;
import org.bimserver.longaction.LongActionManager;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ServerStarted;
import org.bimserver.models.store.BooleanType;
import org.bimserver.models.store.DoubleType;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.LongType;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.ObjectType;
import org.bimserver.models.store.Parameter;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PluginBundleType;
import org.bimserver.models.store.PluginBundleVersion;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.PluginDescriptor;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.ServerInfo;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.ServerState;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.models.store.WebModulePluginConfiguration;
import org.bimserver.notifications.InternalServicesManager;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.pb.server.ProtocolBuffersServer;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.NotificationsManagerInterface;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginBundleVersionIdentifier;
import org.bimserver.plugins.PluginChangeListener;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.plugins.services.ServicePlugin;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.renderengine.NoPoolingRenderEnginePoolFactory;
import org.bimserver.renderengine.RenderEnginePools;
import org.bimserver.schemaconverter.Ifc2x3tc1ToIfc4SchemaConverterFactory;
import org.bimserver.schemaconverter.Ifc4ToIfc2x3tc1SchemaConverterFactory;
import org.bimserver.schemaconverter.SchemaConverterManager;
import org.bimserver.serializers.SerializerFactory;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.InterfaceList;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.reflector.RealtimeReflectorFactoryBuilder;
import org.bimserver.shared.reflector.ReflectorFactory;
import org.bimserver.templating.TemplateEngine;
import org.bimserver.utils.PathUtils;
import org.bimserver.utils.StringUtils;
import org.bimserver.version.VersionChecker;
import org.bimserver.webservices.LongTransactionManager;
import org.bimserver.webservices.PublicInterfaceFactory;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BimServer {
    private static final String ENCRYPTIONKEY = "encryptionkey";
    private Logger LOGGER;
    private GregorianCalendar serverStartTime;
    private BimDatabase bimDatabase;
    private JobScheduler bimScheduler;
    private LongActionManager longActionManager;
    private SerializerFactory serializerFactory;
    private MergerFactory mergerFactory;
    private PluginManager pluginManager;
    private MailSystem mailSystem;
    private DiskCacheManager diskCacheManager;
    private NewDiskCacheManager newDiskCacheManager;
    private ServerInfoManager serverInfoManager;
    private PublicInterfaceFactory serviceFactory;
    private VersionChecker versionChecker;
    private TemplateEngine templateEngine;
    private NotificationsManager notificationsManager;
    private CompareCache compareCache;
    private ProtocolBuffersMetaData protocolBuffersMetaData;
    private SServicesMap servicesMap;
    private EmbeddedWebServerInterface embeddedWebServer;
    private final BimServerConfig config;
    private ProtocolBuffersServer protocolBuffersServer;
    private JsonHandler jsonHandler;
    private CommandLine commandLine;
    private ServerSettingsCache serverSettingsCache;
    private ReflectorFactory reflectorFactory;
    private final EndPointManager endPointManager;
    private final SConverter sConverter;
    private final LongTransactionManager longTransactionManager;
    private JsonSocketReflectorFactory jsonSocketReflectorFactory;
    private SecretKeySpec encryptionkey;
    private BimServerClientFactory bimServerClientFactory;
    private Map<String, WebModulePlugin> webModules;
    private WebModulePlugin defaultWebModule;
    private ExecutorService executorService;
    private InternalServicesManager internalServicesManager;
    private MetaDataManager metaDataManager;
    private SchemaConverterManager schemaConverterManager;
    private WebModuleManager webModuleManager;
    private MetricsRegistry metricsRegistry;
    private RenderEnginePools renderEnginePools;
    private MavenPluginRepository mavenPluginRepository;
    private final ConcurrentHashMap<Long, Long> checkinsInProgress;

    public BimServer(BimServerConfig config) {
        block13: {
            this.endPointManager = new EndPointManager();
            this.sConverter = new SConverter();
            this.longTransactionManager = new LongTransactionManager();
            this.webModules = new HashMap<String, WebModulePlugin>();
            this.executorService = Executors.newCachedThreadPool();
            this.schemaConverterManager = new SchemaConverterManager();
            this.checkinsInProgress = new ConcurrentHashMap();
            this.config = config;
            try {
                Path homeDirIncoming;
                if (config.getHomeDir() != null) {
                    BimServer.initHomeDir(config);
                }
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        if (e instanceof OutOfMemoryError) {
                            BimServer.this.serverInfoManager.setOutOfMemory();
                            BimServer.this.LOGGER.error("", e);
                        } else if (e instanceof Error) {
                            BimServer.this.serverInfoManager.setErrorMessage(e.getMessage());
                            BimServer.this.LOGGER.error("", e);
                        } else {
                            BimServer.this.LOGGER.error("", e);
                        }
                    }
                };
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.LOGGER = LoggerFactory.getLogger(BimServer.class);
                this.LOGGER.info("Starting BIMserver");
                if (config.getHomeDir() != null) {
                    this.LOGGER.info("Using \"" + config.getHomeDir().toString() + "\" as homedir");
                } else {
                    this.LOGGER.info("Not using a homedir");
                }
                this.servicesMap = InterfaceList.createSServicesMap();
                this.LOGGER.debug("SServiceMap Created");
                this.jsonSocketReflectorFactory = new JsonSocketReflectorFactory(this.servicesMap);
                this.LOGGER.debug("JsonSocketReflectorFactory created");
                this.serverInfoManager = new ServerInfoManager();
                this.LOGGER.debug("ServerInfoManager created");
                this.notificationsManager = new NotificationsManager(this, this.jsonSocketReflectorFactory);
                this.LOGGER.debug("NotificationsManager created");
                this.internalServicesManager = new InternalServicesManager(this, this.notificationsManager.getSiteAddress());
                this.LOGGER.debug("InternalServicesManager created");
                this.serviceFactory = new PublicInterfaceFactory(this);
                this.LOGGER.debug("PublicInterfaceFactory created");
                Path tmp = config.getHomeDir().resolve("tmp");
                if (!Files.exists(tmp, new LinkOption[0])) {
                    Files.createDirectories(tmp, new FileAttribute[0]);
                }
                if (!Files.exists(homeDirIncoming = config.getHomeDir().resolve("incoming"), new LinkOption[0])) {
                    Files.createDirectory(homeDirIncoming, new FileAttribute[0]);
                }
                MavenPluginRepository mavenPluginRepository = new MavenPluginRepository(config.getHomeDir().resolve("maven"));
                this.pluginManager = new PluginManager(tmp, config.getHomeDir().resolve("plugins"), mavenPluginRepository, config.getClassPath(), (ServiceFactory)this.serviceFactory, (NotificationsManagerInterface)this.internalServicesManager, this.servicesMap);
                this.metaDataManager = new MetaDataManager(tmp);
                this.pluginManager.setMetaDataManager(this.metaDataManager);
                this.LOGGER.debug("PluginManager created");
                try {
                    this.LOGGER.debug("Version Checker created");
                    this.versionChecker = new VersionChecker(config.getResourceFetcher());
                }
                catch (Exception e) {
                    this.LOGGER.error(e.getMessage());
                }
                this.compareCache = new CompareCache();
                this.LOGGER.debug("Compare cache created");
                if (config.isStartEmbeddedWebServer()) {
                    this.LOGGER.debug("Embedded webserver created");
                }
                this.LOGGER.debug("Done with initial setup");
            }
            catch (Throwable e) {
                if (this.LOGGER == null) {
                    e.printStackTrace();
                } else {
                    this.LOGGER.error("", e);
                }
                if (this.serverInfoManager == null) break block13;
                if (e.getMessage() != null) {
                    this.serverInfoManager.setErrorMessage(e.getMessage());
                }
                this.serverInfoManager.setErrorMessage(e.toString());
            }
        }
    }

    public Map<String, WebModulePlugin> getWebModules() {
        return this.webModules;
    }

    public WebModulePlugin getDefaultWebModule() {
        return this.defaultWebModule;
    }

    public JsonSocketReflectorFactory getJsonSocketReflectorFactory() {
        return this.jsonSocketReflectorFactory;
    }

    public ReflectorFactory getReflectorFactory() {
        return this.reflectorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws DatabaseInitException, BimserverDatabaseException, PluginException, DatabaseRestartRequiredException, ServerException {
        try {
            this.LOGGER.debug("Starting BIMserver");
            if (this.versionChecker != null) {
                SVersion localVersion = this.versionChecker.getLocalVersion();
                if (localVersion != null) {
                    this.LOGGER.info("Version: " + localVersion.getFullString());
                } else {
                    this.LOGGER.info("Unknown version");
                }
            } else {
                this.LOGGER.info("Unknown version");
            }
            try {
                this.pluginManager.setPluginChangeListener(new PluginChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pluginStateChanged(PluginContext pluginContext, boolean enabled) {
                        AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_PluginClassName(), new StringLiteral(pluginContext.getPlugin().getClass().getName()));
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Map<Long, PluginDescriptor> pluginsFound = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
                            if (pluginsFound.size() == 0) {
                                BimServer.this.LOGGER.error("Error changing plugin-state in database, plugin " + pluginContext.getPlugin().getClass().getName() + " not found");
                            } else if (pluginsFound.size() == 1) {
                                PluginDescriptor pluginConfiguration = pluginsFound.values().iterator().next();
                                pluginConfiguration.setEnabled(Boolean.valueOf(pluginContext.isEnabled()));
                                session.store((IdEObject)pluginConfiguration);
                            } else {
                                BimServer.this.LOGGER.error("Error, too many plugin-objects found in database for name " + pluginContext.getPlugin().getClass().getName());
                            }
                            session.commit();
                        }
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public long pluginBundleUpdated(PluginBundle pluginBundle) {
                        SPluginBundleVersion sPluginBundleVersion = pluginBundle.getPluginBundleVersion();
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            PluginBundleVersion current = null;
                            IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getPluginBundleVersion(), OldQuery.getDefault());
                            for (PluginBundleVersion pbv : allOfType.getAll(PluginBundleVersion.class)) {
                                if (!pbv.getGroupId().equals(pluginBundle.getPluginBundleVersion().getGroupId()) || !pbv.getArtifactId().equals(pluginBundle.getPluginBundleVersion().getArtifactId())) continue;
                                current = pbv;
                            }
                            if (current != null) {
                                current.setDescription(sPluginBundleVersion.getArtifactId());
                                current.setIcon(sPluginBundleVersion.getIcon());
                                current.setMismatch(sPluginBundleVersion.isMismatch());
                                current.setRepository(sPluginBundleVersion.getRepository());
                                current.setType(BimServer.this.getSConverter().convertFromSObject(sPluginBundleVersion.getType()));
                                current.setVersion(sPluginBundleVersion.getVersion());
                                current.setOrganization(sPluginBundleVersion.getOrganization());
                                current.setName(sPluginBundleVersion.getName());
                                current.setDate(sPluginBundleVersion.getDate());
                                session.store((IdEObject)current);
                                session.commit();
                            }
                            long l = current.getOid();
                            return l;
                        }
                        catch (BimserverDatabaseException e) {
                            BimServer.this.LOGGER.error("", (Throwable)e);
                            return -1L;
                        }
                        catch (ServiceException e) {
                            BimServer.this.LOGGER.error("", (Throwable)e);
                        }
                        return -1L;
                    }

                    public void pluginUpdated(long pluginBundleVersionId, PluginContext newPluginContext, SPluginInformation sPluginInformation) throws BimserverDatabaseException {
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Plugin plugin = newPluginContext.getPlugin();
                            AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), new StringLiteral(newPluginContext.getIdentifier()));
                            Map<Long, PluginDescriptor> pluginsFound = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
                            for (PluginDescriptor pluginDescriptor : pluginsFound.values()) {
                                IfcModelInterface allOfType;
                                pluginDescriptor.setIdentifier(newPluginContext.getIdentifier());
                                pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                                pluginDescriptor.setDescription(newPluginContext.getDescription());
                                pluginDescriptor.setName(sPluginInformation.getName());
                                pluginDescriptor.setLocation(newPluginContext.getLocation().toString());
                                pluginDescriptor.setPluginInterfaceClassName(BimServer.this.getPluginInterface(plugin.getClass()).getName());
                                pluginDescriptor.setEnabled(Boolean.valueOf(sPluginInformation.isEnabled()));
                                pluginDescriptor.setInstallForNewUsers(sPluginInformation.isInstallForNewUsers());
                                PluginBundleVersion value = (PluginBundleVersion)session.get(pluginBundleVersionId, OldQuery.getDefault());
                                pluginDescriptor.setPluginBundleVersion(value);
                                session.store((IdEObject)pluginDescriptor);
                                if (sPluginInformation.isInstallForAllUsers()) {
                                    allOfType = session.getAllOfType(StorePackage.eINSTANCE.getUser(), OldQuery.getDefault());
                                    for (User user : allOfType.getAll(User.class)) {
                                        if (user.getState() != ObjectState.ACTIVE) continue;
                                        BimServer.this.updateUserPlugin(session, user, pluginDescriptor, newPluginContext);
                                    }
                                }
                                if (newPluginContext.getPlugin() instanceof WebModulePlugin) {
                                    ServerSettings serverSettings = BimServer.this.getServerSettingsCache().getServerSettings();
                                    WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)BimServer.this.find((List)serverSettings.getWebModules(), newPluginContext.getIdentifier());
                                    if (webPluginConfiguration == null) {
                                        webPluginConfiguration = session.create(WebModulePluginConfiguration.class);
                                        serverSettings.getWebModules().add((Object)webPluginConfiguration);
                                    }
                                    BimServer.this.genericPluginConversion(newPluginContext, session, (PluginConfiguration)webPluginConfiguration, pluginDescriptor);
                                    String contextPath = "";
                                    for (Parameter parameter : webPluginConfiguration.getSettings().getParameters()) {
                                        if (!parameter.getName().equals("contextPath")) continue;
                                        contextPath = ((StringType)parameter.getValue()).getValue();
                                    }
                                    String identifier = webPluginConfiguration.getPluginDescriptor().getIdentifier();
                                    BimServer.this.webModules.put(contextPath, (WebModulePlugin)BimServer.this.pluginManager.getPlugin(identifier, true));
                                    continue;
                                }
                                if (!(newPluginContext.getPlugin() instanceof ServicePlugin)) continue;
                                allOfType = session.getAllOfType(StorePackage.eINSTANCE.getInternalServicePluginConfiguration(), OldQuery.getDefault());
                                ArrayList all = new ArrayList(allOfType.getAll(InternalServicePluginConfiguration.class));
                                for (InternalServicePluginConfiguration internalServicePluginConfiguration : all) {
                                    if (!internalServicePluginConfiguration.getPluginDescriptor().getIdentifier().equals(newPluginContext.getIdentifier())) continue;
                                    BimServer.this.activateService(internalServicePluginConfiguration.getUserSettings().getOid(), internalServicePluginConfiguration);
                                }
                            }
                            try {
                                session.commit();
                            }
                            catch (ServiceException e) {
                                BimServer.this.LOGGER.error("", (Throwable)e);
                            }
                        }
                    }

                    public void pluginInstalled(long pluginBundleVersionId, PluginContext pluginContext, SPluginInformation sPluginInformation) throws BimserverDatabaseException {
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Plugin plugin = pluginContext.getPlugin();
                            AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), new StringLiteral(pluginContext.getIdentifier()));
                            Map<Long, PluginDescriptor> pluginsFound = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
                            PluginDescriptor pluginDescriptor = null;
                            pluginDescriptor = pluginsFound.size() > 0 ? pluginsFound.values().iterator().next() : session.create(PluginDescriptor.class);
                            pluginDescriptor.setIdentifier(pluginContext.getIdentifier());
                            pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                            pluginDescriptor.setDescription(pluginContext.getDescription());
                            pluginDescriptor.setName(sPluginInformation.getName());
                            pluginDescriptor.setLocation(pluginContext.getLocation().toString());
                            pluginDescriptor.setPluginInterfaceClassName(BimServer.this.getPluginInterface(plugin.getClass()).getName());
                            pluginDescriptor.setEnabled(Boolean.valueOf(sPluginInformation.isEnabled()));
                            pluginDescriptor.setInstallForNewUsers(sPluginInformation.isInstallForNewUsers());
                            pluginDescriptor.setPluginBundleVersion((PluginBundleVersion)session.get(pluginBundleVersionId, OldQuery.getDefault()));
                            if (sPluginInformation.isInstallForAllUsers()) {
                                IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getUser(), OldQuery.getDefault());
                                for (User user : allOfType.getAll(User.class)) {
                                    if (user.getState() != ObjectState.ACTIVE) continue;
                                    BimServer.this.updateUserPlugin(session, user, pluginDescriptor, pluginContext);
                                }
                            }
                            if (pluginContext.getPlugin() instanceof WebModulePlugin) {
                                ServerSettings serverSettings = BimServer.this.getServerSettingsCache().getServerSettings();
                                WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)BimServer.this.find((List)serverSettings.getWebModules(), pluginContext.getIdentifier());
                                if (webPluginConfiguration == null) {
                                    webPluginConfiguration = session.create(WebModulePluginConfiguration.class);
                                    serverSettings.getWebModules().add((Object)webPluginConfiguration);
                                    BimServer.this.genericPluginConversion(pluginContext, session, (PluginConfiguration)webPluginConfiguration, pluginDescriptor);
                                    session.store((IdEObject)serverSettings);
                                }
                                String contextPath = "";
                                for (Parameter parameter : webPluginConfiguration.getSettings().getParameters()) {
                                    if (!parameter.getName().equals("contextPath")) continue;
                                    contextPath = ((StringType)parameter.getValue()).getValue();
                                }
                                BimServer.this.webModules.put(contextPath, (WebModulePlugin)BimServer.this.pluginManager.getPlugin(pluginContext.getIdentifier(), true));
                            }
                            try {
                                session.commit();
                            }
                            catch (ServiceException e) {
                                BimServer.this.LOGGER.error("", (Throwable)e);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pluginUninstalled(PluginContext pluginContext) {
                        AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), new StringLiteral(pluginContext.getIdentifier()));
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Map<Long, PluginDescriptor> pluginsFound = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
                            if (pluginsFound.size() == 0) {
                                BimServer.this.LOGGER.error("Error removing plugin-state in database, plugin " + pluginContext.getPlugin().getClass().getName() + " not found");
                            } else if (pluginsFound.size() == 1) {
                                PluginDescriptor pluginDescriptor = pluginsFound.values().iterator().next();
                                for (PluginConfiguration pluginConfiguration : pluginDescriptor.getConfigurations()) {
                                    session.delete((IdEObject)pluginConfiguration, -1);
                                }
                                if (pluginContext.getPlugin() instanceof WebModulePlugin) {
                                    ServerSettings serverSettings = BimServer.this.getServerSettingsCache().getServerSettings();
                                    WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)BimServer.this.find((List)serverSettings.getWebModules(), pluginContext.getIdentifier());
                                    serverSettings.getWebModules().remove((Object)webPluginConfiguration);
                                    session.store((IdEObject)serverSettings);
                                    String contextPath = "";
                                    for (Parameter parameter : webPluginConfiguration.getSettings().getParameters()) {
                                        if (!parameter.getName().equals("contextPath")) continue;
                                        contextPath = ((StringType)parameter.getValue()).getValue();
                                    }
                                    BimServer.this.webModules.remove(contextPath);
                                }
                                session.delete((IdEObject)pluginDescriptor, -1);
                            } else {
                                BimServer.this.LOGGER.error("Error, too many plugin-objects found in database for name " + pluginContext.getPlugin().getClass().getName());
                            }
                            session.commit();
                        }
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public long pluginBundleInstalled(PluginBundle pluginBundle) {
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            PluginBundleVersion current = null;
                            IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getPluginBundleVersion(), OldQuery.getDefault());
                            for (PluginBundleVersion pbv : allOfType.getAll(PluginBundleVersion.class)) {
                                if (!pbv.getGroupId().equals(pluginBundle.getPluginBundleVersion().getGroupId()) || !pbv.getArtifactId().equals(pluginBundle.getPluginBundleVersion().getArtifactId())) continue;
                                current = pbv;
                            }
                            PluginBundleVersion pluginBundleVersion = null;
                            if (current != null) {
                                pluginBundleVersion = current;
                                session.store((IdEObject)pluginBundleVersion);
                            } else {
                                pluginBundleVersion = session.create(PluginBundleVersion.class);
                            }
                            SPluginBundleVersion sPluginBundleVersion = pluginBundle.getPluginBundleVersion();
                            pluginBundleVersion.setArtifactId(sPluginBundleVersion.getArtifactId());
                            pluginBundleVersion.setDescription(sPluginBundleVersion.getArtifactId());
                            pluginBundleVersion.setGroupId(sPluginBundleVersion.getGroupId());
                            pluginBundleVersion.setIcon(sPluginBundleVersion.getIcon());
                            pluginBundleVersion.setMismatch(sPluginBundleVersion.isMismatch());
                            pluginBundleVersion.setRepository(sPluginBundleVersion.getRepository());
                            pluginBundleVersion.setType(BimServer.this.getSConverter().convertFromSObject(sPluginBundleVersion.getType()));
                            pluginBundleVersion.setVersion(sPluginBundleVersion.getVersion());
                            pluginBundleVersion.setOrganization(sPluginBundleVersion.getOrganization());
                            pluginBundleVersion.setName(sPluginBundleVersion.getName());
                            pluginBundleVersion.setDate(sPluginBundleVersion.getDate());
                            session.commit();
                            long l = pluginBundleVersion.getOid();
                            return l;
                        }
                        catch (BimserverDatabaseException e) {
                            BimServer.this.LOGGER.error("", (Throwable)e);
                            return -1L;
                        }
                        catch (ServiceException e) {
                            BimServer.this.LOGGER.error("", (Throwable)e);
                        }
                        return -1L;
                    }

                    public void pluginBundleUninstalled(PluginBundle pluginBundle) {
                    }
                });
            }
            catch (Exception e) {
                this.LOGGER.error("", (Throwable)e);
            }
            try {
                this.metaDataManager.init();
                this.pluginManager.initAllLoadedPlugins();
            }
            catch (PluginException e) {
                this.LOGGER.error("", (Throwable)e);
            }
            this.serverStartTime = new GregorianCalendar();
            this.longActionManager = new LongActionManager();
            LinkedHashSet<Object> packages = new LinkedHashSet<Object>();
            packages.add(Ifc2x3tc1Package.eINSTANCE);
            packages.add(Ifc4Package.eINSTANCE);
            this.templateEngine = new TemplateEngine();
            URL emailTemplates = this.config.getResourceFetcher().getResource("emailtemplates/");
            if (emailTemplates != null) {
                this.templateEngine.init(emailTemplates);
            } else {
                this.LOGGER.info("No email templates found");
            }
            Path databaseDir = this.config.getHomeDir().resolve("database");
            BerkeleyKeyValueStore keyValueStore = new BerkeleyKeyValueStore(databaseDir);
            this.schemaConverterManager.registerConverter(new Ifc2x3tc1ToIfc4SchemaConverterFactory());
            this.schemaConverterManager.registerConverter(new Ifc4ToIfc2x3tc1SchemaConverterFactory());
            this.metricsRegistry = new MetricsRegistry();
            Path mavenPath = this.config.getHomeDir().resolve("maven");
            if (!Files.exists(mavenPath, new LinkOption[0])) {
                Files.createDirectories(mavenPath, new FileAttribute[0]);
            }
            this.mavenPluginRepository = new MavenPluginRepository(mavenPath, "http://central.maven.org/maven2", "~/.m2/repository");
            OldQuery.setPackageMetaDataForDefaultQuery(this.metaDataManager.getPackageMetaData("store"));
            this.bimDatabase = new Database(this, packages, keyValueStore, this.metaDataManager);
            try {
                this.bimDatabase.init();
            }
            catch (DatabaseRestartRequiredException e) {
                this.bimDatabase.close();
                keyValueStore = new BerkeleyKeyValueStore(databaseDir);
                this.bimDatabase = new Database(this, packages, keyValueStore, this.metaDataManager);
                try {
                    this.bimDatabase.init();
                }
                catch (InconsistentModelsException e1) {
                    this.LOGGER.error("", (Throwable)e);
                    this.serverInfoManager.setServerState(ServerState.FATAL_ERROR);
                    this.serverInfoManager.setErrorMessage("Inconsistent models");
                }
            }
            catch (InconsistentModelsException e) {
                this.LOGGER.error("", (Throwable)e);
                this.serverInfoManager.setServerState(ServerState.FATAL_ERROR);
                this.serverInfoManager.setErrorMessage("Inconsistent models");
            }
            try (DatabaseSession encsession = this.bimDatabase.createSession();){
                byte[] encryptionkeyBytes = null;
                if (!this.bimDatabase.getRegistry().has(ENCRYPTIONKEY, encsession)) {
                    encryptionkeyBytes = new byte[16];
                    new SecureRandom().nextBytes(encryptionkeyBytes);
                    this.bimDatabase.getRegistry().save(ENCRYPTIONKEY, encryptionkeyBytes, encsession);
                    encsession.commit();
                } else {
                    encryptionkeyBytes = this.bimDatabase.getRegistry().readByteArray(ENCRYPTIONKEY, encsession);
                }
                this.encryptionkey = new SecretKeySpec(encryptionkeyBytes, "AES");
            }
            this.protocolBuffersMetaData = new ProtocolBuffersMetaData();
            this.protocolBuffersMetaData.load(this.servicesMap, ProtocolBuffersBimServerClientFactory.class);
            this.serverInfoManager.init(this);
            this.webModuleManager = new WebModuleManager(this);
            this.jsonHandler = new JsonHandler(this);
            this.serializerFactory = new SerializerFactory();
            this.serverSettingsCache = new ServerSettingsCache(this.bimDatabase);
            this.serverInfoManager.update();
            NoPoolingRenderEnginePoolFactory renderEnginePoolFactory = new NoPoolingRenderEnginePoolFactory();
            this.renderEnginePools = new RenderEnginePools(this, renderEnginePoolFactory);
            if (this.serverInfoManager.getServerState() == ServerState.MIGRATION_REQUIRED) {
                this.serverInfoManager.registerStateChangeListener(new StateChangeListener(){

                    @Override
                    public void stateChanged(ServerState oldState, ServerState newState) {
                        if (oldState == ServerState.MIGRATION_REQUIRED && newState == ServerState.RUNNING) {
                            try {
                                BimServer.this.initDatabaseDependantItems();
                            }
                            catch (BimserverDatabaseException e) {
                                BimServer.this.LOGGER.error("", (Throwable)e);
                            }
                        }
                    }
                });
            } else {
                this.initDatabaseDependantItems();
            }
            this.mailSystem = new MailSystem(this);
            this.diskCacheManager = new DiskCacheManager(this, this.config.getHomeDir().resolve("cache"));
            this.newDiskCacheManager = new NewDiskCacheManager(this, this.config.getHomeDir().resolve("cache"));
            this.mergerFactory = new MergerFactory(this);
            RealtimeReflectorFactoryBuilder factoryBuilder = new RealtimeReflectorFactoryBuilder(this.servicesMap);
            this.reflectorFactory = factoryBuilder.newReflectorFactory();
            if (this.reflectorFactory == null) {
                throw new RuntimeException("No reflector factory!");
            }
            this.servicesMap.setReflectorFactory(this.reflectorFactory);
            this.bimScheduler = new JobScheduler(this);
            this.bimScheduler.start();
            if (this.config.isStartEmbeddedWebServer()) {
                this.embeddedWebServer.start();
            }
            if (this.config.isStartCommandLine()) {
                this.commandLine = new CommandLine(this);
                this.commandLine.start();
            }
            if (this.getServerInfoManager().getServerState() == ServerState.SETUP) {
                this.getServerInfoManager().setServerState(ServerState.RUNNING);
            }
        }
        catch (Throwable e) {
            this.LOGGER.error("", e);
            this.serverInfoManager.setErrorMessage(e.getMessage());
        }
    }

    public MavenPluginRepository getMavenPluginRepository() {
        return this.mavenPluginRepository;
    }

    public SecretKeySpec getEncryptionKey() {
        return this.encryptionkey;
    }

    public NewDiskCacheManager getNewDiskCacheManager() {
        return this.newDiskCacheManager;
    }

    private <T extends PluginConfiguration> T find(List<T> list, String identifier) {
        for (PluginConfiguration t : list) {
            if (t.getPluginDescriptor() == null || !t.getPluginDescriptor().getIdentifier().equals(identifier)) continue;
            return (T)t;
        }
        return null;
    }

    private void genericPluginConversion(PluginContext pluginContext, DatabaseSession session, PluginConfiguration pluginConfiguration, PluginDescriptor pluginDescriptor) throws BimserverDatabaseException {
        try {
            Plugin plugin = pluginContext.getPlugin();
            pluginConfiguration.setName(pluginDescriptor.getName());
            pluginConfiguration.setPluginDescriptor(pluginDescriptor);
            pluginConfiguration.setDescription(pluginContext.getDescription());
            pluginConfiguration.setEnabled(Boolean.valueOf(true));
            pluginConfiguration.setSettings(this.convertSettings(session, plugin));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private PluginDescriptor getPluginDescriptor(DatabaseSession session, String identifier) throws BimserverDatabaseException {
        return (PluginDescriptor)session.querySingle(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), identifier);
    }

    public Class<?> getPluginInterface(Class<?> plugin) {
        for (Class<?> inter : plugin.getInterfaces()) {
            if (inter == Plugin.class) {
                return plugin;
            }
            for (Class<?> inter2 : inter.getInterfaces()) {
                if (inter2 != Plugin.class) continue;
                return inter;
            }
        }
        if (plugin.getSuperclass() != null) {
            return this.getPluginInterface(plugin.getSuperclass());
        }
        return null;
    }

    public void updateUserPlugin(DatabaseSession session, User user, PluginDescriptor pluginDescriptor, PluginContext pluginContext) throws BimserverDatabaseException {
        if (pluginDescriptor.isInstallForNewUsers()) {
            EReference listReference;
            UserSettings userSettings = user.getUserSettings();
            if (userSettings == null) {
                userSettings = session.create(UserSettings.class);
                user.setUserSettings(userSettings);
                session.store((IdEObject)user);
            }
            Class<?> pluginInterface = this.getPluginInterface(pluginContext.getPlugin().getClass());
            String originalPluginInterfaceName = pluginInterface.getSimpleName();
            String pluginInterfaceName = pluginInterface.getSimpleName();
            if (pluginInterfaceName.endsWith("Plugin")) {
                pluginInterfaceName = pluginInterfaceName.substring(0, pluginInterfaceName.length() - 6);
            }
            if (pluginInterfaceName.equals("StreamingSerializer")) {
                pluginInterfaceName = "Serializer";
            } else if (pluginInterfaceName.equals("MessagingStreamingSerializer")) {
                pluginInterfaceName = "MessagingSerializer";
            }
            if (pluginInterfaceName.equals("StreamingDeserializer")) {
                pluginInterfaceName = "Deserializer";
            }
            if (pluginInterfaceName.equals("ModelChecker") || pluginInterfaceName.equals("WebModule")) {
                return;
            }
            EClass userSettingsClass = StorePackage.eINSTANCE.getUserSettings();
            String listRefName = StringUtils.firstLowerCase((String)pluginInterfaceName) + "s";
            if (listRefName.equals("messagingSerializers")) {
                listRefName = "serializers";
            }
            if ((listReference = (EReference)userSettingsClass.getEStructuralFeature(listRefName)) == null) {
                this.LOGGER.warn(listRefName + " not found");
                return;
            }
            EReference defaultReference = (EReference)userSettingsClass.getEStructuralFeature("default" + pluginInterfaceName);
            EClass pluginConfigurationClass = (EClass)StorePackage.eINSTANCE.getEClassifier((pluginInterfaceName.equals("Service") ? "Internal" : "") + pluginInterfaceName + "PluginConfiguration");
            List list = (List)userSettings.eGet((EStructuralFeature)listReference);
            Object pluginConfiguration = this.find(list, pluginContext.getIdentifier());
            if (pluginConfiguration == null) {
                pluginConfiguration = (PluginConfiguration)session.create(pluginConfigurationClass);
                if (pluginConfiguration instanceof SerializerPluginConfiguration) {
                    boolean streaming = originalPluginInterfaceName.equals("StreamingSerializerPlugin") || originalPluginInterfaceName.equals("MessagingStreamingSerializerPlugin");
                    ((SerializerPluginConfiguration)pluginConfiguration).setStreaming(streaming);
                } else if (pluginConfiguration instanceof InternalServicePluginConfiguration) {
                    ((InternalServicePluginConfiguration)pluginConfiguration).setUserSettings(userSettings);
                }
                list.add(pluginConfiguration);
                this.genericPluginConversion(pluginContext, session, (PluginConfiguration)pluginConfiguration, pluginDescriptor);
            }
            if (pluginInterfaceName.equals("Service")) {
                this.activateService(user.getOid(), (InternalServicePluginConfiguration)pluginConfiguration);
            }
            if (defaultReference != null && (userSettings.eGet((EStructuralFeature)defaultReference) == null || pluginConfiguration.getName().equals("IfcOpenShell"))) {
                userSettings.eSet((EStructuralFeature)defaultReference, pluginConfiguration);
            }
            session.store((IdEObject)userSettings);
        }
    }

    public void updateUserSettings(DatabaseSession session, User user) throws BimserverLockConflictException, BimserverDatabaseException {
        UserSettings userSettings = user.getUserSettings();
        if (userSettings == null) {
            userSettings = session.create(UserSettings.class);
            user.setUserSettings(userSettings);
            session.store((IdEObject)user);
        }
        for (Map.Entry pluginEntry : this.pluginManager.getAllPlugins(true).entrySet()) {
            if (pluginEntry.getValue() instanceof WebModulePlugin || pluginEntry.getValue() instanceof ModelCheckerPlugin) continue;
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(session, ((PluginContext)pluginEntry.getKey()).getIdentifier());
            if (pluginDescriptor == null) {
                this.LOGGER.error("No plugin descriptor found: " + ((PluginContext)pluginEntry.getKey()).getIdentifier());
                continue;
            }
            this.updateUserPlugin(session, user, pluginDescriptor, (PluginContext)pluginEntry.getKey());
        }
        session.store((IdEObject)userSettings);
    }

    public RenderEnginePools getRenderEnginePools() {
        return this.renderEnginePools;
    }

    public ObjectType convertSettings(DatabaseSession session, Plugin plugin) throws BimserverDatabaseException {
        ObjectType settings = session.create(ObjectType.class);
        ObjectDefinition settingsDefinition = plugin.getSettingsDefinition();
        if (plugin.getSettingsDefinition() != null) {
            for (ParameterDefinition parameterDefinition : settingsDefinition.getParameters()) {
                Parameter parameter = session.create(Parameter.class);
                parameter.setName(parameterDefinition.getName());
                parameter.setIdentifier(parameterDefinition.getIdentifier());
                if (parameterDefinition.getDefaultValue() != null) {
                    Type value = this.cloneAndAdd(session, parameterDefinition.getDefaultValue());
                    parameter.setValue(value);
                }
                settings.getParameters().add((Object)parameter);
            }
        }
        return settings;
    }

    public Type cloneAndAdd(DatabaseSession session, Type input) throws BimserverDatabaseException {
        if (input instanceof BooleanType) {
            BooleanType booleanType = session.create(BooleanType.class);
            booleanType.setValue(((BooleanType)input).isValue());
            session.store((IdEObject)booleanType);
            return booleanType;
        }
        if (input instanceof StringType) {
            StringType stringType = session.create(StringType.class);
            stringType.setValue(((StringType)input).getValue());
            session.store((IdEObject)stringType);
            return stringType;
        }
        if (input instanceof DoubleType) {
            DoubleType doubleType = session.create(DoubleType.class);
            doubleType.setValue(((DoubleType)input).getValue());
            session.store((IdEObject)doubleType);
            return doubleType;
        }
        if (input instanceof LongType) {
            LongType longType = session.create(LongType.class);
            longType.setValue(((LongType)input).getValue());
            session.store((IdEObject)longType);
            return longType;
        }
        return null;
    }

    private WebModulePluginConfiguration findWebModule(ServerSettings serverSettings, String identifier) {
        for (Map.Entry entry : this.pluginManager.getAllWebPlugins(true).entrySet()) {
            WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)this.find((List)serverSettings.getWebModules(), identifier);
            if (!((PluginContext)entry.getKey()).getIdentifier().equals(identifier)) continue;
            return webPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabaseDependantItems() throws BimserverDatabaseException {
        this.notificationsManager.init();
        this.getSerializerFactory().init(this.pluginManager, this.bimDatabase, this);
        try {
            try (DatabaseSession session = this.bimDatabase.createSession();){
                this.updatePlugins(session);
                session.commit();
            }
            session = this.bimDatabase.createSession();
            ServerSettings serverSettings = this.serverSettingsCache.getServerSettings();
            for (Map.Entry entry : this.pluginManager.getAllWebPlugins(true).entrySet()) {
                WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)this.find((List)serverSettings.getWebModules(), ((PluginContext)entry.getKey()).getIdentifier());
                if (webPluginConfiguration == null) {
                    webPluginConfiguration = session.create(WebModulePluginConfiguration.class);
                    serverSettings.getWebModules().add((Object)webPluginConfiguration);
                    PluginDescriptor pluginDescriptor = this.getPluginDescriptor(session, ((PluginContext)entry.getKey()).getIdentifier());
                    if (pluginDescriptor == null) {
                        throw new BimserverDatabaseException("No plugin descriptor found: " + ((PluginContext)entry.getKey()).getIdentifier());
                    }
                    this.genericPluginConversion((PluginContext)entry.getKey(), session, (PluginConfiguration)webPluginConfiguration, pluginDescriptor);
                    continue;
                }
                if (webPluginConfiguration != serverSettings.getWebModule()) continue;
                this.setDefaultWebModule((WebModulePlugin)entry.getValue());
            }
            session.store((IdEObject)serverSettings);
            AttributeCondition condition = new AttributeCondition(StorePackage.eINSTANCE.getUser_Username(), new StringLiteral("system"));
            User systemUser = session.querySingle(condition, User.class, OldQuery.getDefault());
            ServerStarted serverStarted = session.create(ServerStarted.class);
            serverStarted.setDate(new Date());
            serverStarted.setAccessMethod(AccessMethod.INTERNAL);
            serverStarted.setExecutor(systemUser);
            try {
                session.store((IdEObject)serverStarted);
                session.commit();
            }
            catch (BimserverLockConflictException e) {
                throw new BimserverDatabaseException((Throwable)((Object)e));
            }
            catch (ServiceException e) {
                throw new BimserverDatabaseException((Throwable)e);
            }
            finally {
                session.close();
            }
            this.webModules = new HashMap<String, WebModulePlugin>();
            try (DatabaseSession ses = this.bimDatabase.createSession();){
                EList webModuleConfigurations = this.serverSettingsCache.getServerSettings().getWebModules();
                for (WebModulePluginConfiguration webModulePluginConfiguration : webModuleConfigurations) {
                    String contextPath = "";
                    for (Parameter parameter : webModulePluginConfiguration.getSettings().getParameters()) {
                        if (!parameter.getName().equals("contextPath")) continue;
                        contextPath = ((StringType)parameter.getValue()).getValue();
                    }
                    String identifier = webModulePluginConfiguration.getPluginDescriptor().getIdentifier();
                    this.webModules.put(contextPath, (WebModulePlugin)this.pluginManager.getPlugin(identifier, true));
                }
            }
            Integer protocolBuffersPort = this.getServerSettingsCache().getServerSettings().getProtocolBuffersPort();
            if (protocolBuffersPort >= 1 && protocolBuffersPort <= 65535) {
                try {
                    this.protocolBuffersServer = new ProtocolBuffersServer(this.protocolBuffersMetaData, this.serviceFactory, this.servicesMap, protocolBuffersPort);
                    this.protocolBuffersServer.start();
                }
                catch (Exception e) {
                    this.LOGGER.error("", (Throwable)e);
                }
            }
            this.bimServerClientFactory = new DirectBimServerClientFactory(this.serverSettingsCache.getServerSettings().getSiteAddress(), (ServiceFactory)this.serviceFactory, this.servicesMap, this.pluginManager, this.metaDataManager);
            this.pluginManager.setBimServerClientFactory(this.bimServerClientFactory);
            try (DatabaseSession session2 = this.bimDatabase.createSession();){
                IfcModelInterface pluginBundleVersions = session2.getAllOfType(StorePackage.eINSTANCE.getPluginBundleVersion(), OldQuery.getDefault());
                for (PluginBundleVersion pluginBundleVersion : pluginBundleVersions.getAll(PluginBundleVersion.class)) {
                    if (pluginBundleVersion.getType() != PluginBundleType.MAVEN && pluginBundleVersion.getType() != PluginBundleType.LOCAL) continue;
                    PluginBundleVersionIdentifier pluginBundleVersionIdentifier = new PluginBundleVersionIdentifier(pluginBundleVersion.getGroupId(), pluginBundleVersion.getArtifactId(), pluginBundleVersion.getVersion());
                    IfcModelInterface pluginDescriptors = session2.getAllOfType(StorePackage.eINSTANCE.getPluginDescriptor(), OldQuery.getDefault());
                    ArrayList<SPluginInformation> plugins = new ArrayList<SPluginInformation>();
                    for (PluginDescriptor pluginDescriptor : pluginDescriptors.getAll(PluginDescriptor.class)) {
                        if (pluginDescriptor.getPluginBundleVersion() != pluginBundleVersion || !pluginDescriptor.getEnabled().booleanValue()) continue;
                        SPluginInformation sPluginInformation = new SPluginInformation();
                        sPluginInformation.setEnabled(true);
                        sPluginInformation.setDescription(pluginDescriptor.getDescription());
                        sPluginInformation.setIdentifier(pluginDescriptor.getIdentifier());
                        sPluginInformation.setInstallForAllUsers(pluginDescriptor.isInstallForNewUsers());
                        sPluginInformation.setInstallForNewUsers(pluginDescriptor.isInstallForNewUsers());
                        sPluginInformation.setName(pluginDescriptor.getName());
                        sPluginInformation.setType(this.pluginManager.getPluginTypeFromClass(pluginDescriptor.getPluginClassName()));
                        plugins.add(sPluginInformation);
                    }
                    try {
                        this.pluginManager.loadFromPluginDir(pluginBundleVersionIdentifier, this.getSConverter().convertToSObject(pluginBundleVersion), plugins, this.serverSettingsCache.getServerSettings().isPluginStrictVersionChecking());
                    }
                    catch (Exception e) {
                        this.LOGGER.error("", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                throw new BimserverDatabaseException((Throwable)e);
            }
        }
        catch (BimserverLockConflictException e) {
            throw new BimserverDatabaseException((Throwable)((Object)e));
        }
    }

    public void activateServices() throws BimserverDatabaseException, BimserverLockConflictException {
        try (DatabaseSession session = this.bimDatabase.createSession();){
            IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getUser(), OldQuery.getDefault());
            for (User user : allOfType.getAll(User.class)) {
                this.updateUserSettings(session, user);
                UserSettings userSettings = user.getUserSettings();
                for (InternalServicePluginConfiguration internalServicePluginConfiguration : userSettings.getServices()) {
                    this.activateService(user.getOid(), internalServicePluginConfiguration);
                }
            }
        }
    }

    public void activateService(long uoid, InternalServicePluginConfiguration internalServicePluginConfiguration) {
        ServicePlugin servicePlugin = this.getPluginManager().getServicePlugin(internalServicePluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
        if (servicePlugin == null) {
            this.LOGGER.warn("Plugin " + internalServicePluginConfiguration.getPluginDescriptor().getPluginClassName() + " not found");
        } else {
            SInternalServicePluginConfiguration sInternalService = this.getSConverter().convertToSObject(internalServicePluginConfiguration);
            try {
                servicePlugin.unregister(sInternalService);
                servicePlugin.register(uoid, sInternalService, new org.bimserver.plugins.PluginConfiguration(internalServicePluginConfiguration.getSettings()));
            }
            catch (Throwable e) {
                this.LOGGER.error("", e);
            }
        }
    }

    public WebModuleManager getWebModuleManager() {
        return this.webModuleManager;
    }

    private void updatePlugins(DatabaseSession session) throws BimserverDatabaseException {
        Map allPlugins = this.pluginManager.getAllPlugins(false);
        for (PluginContext pluginContext : allPlugins.keySet()) {
            PluginDescriptor pluginDescriptor;
            Plugin plugin = pluginContext.getPlugin();
            AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), new StringLiteral(pluginContext.getIdentifier()));
            Map<Long, PluginDescriptor> results = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
            if (results.size() == 0) {
                pluginDescriptor = session.create(PluginDescriptor.class);
                pluginDescriptor.setIdentifier(pluginContext.getIdentifier());
                pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                pluginDescriptor.setName(plugin.getClass().getSimpleName());
                pluginDescriptor.setDescription(pluginContext.getDescription());
                pluginDescriptor.setLocation(pluginContext.getLocation().toString());
                pluginDescriptor.setPluginInterfaceClassName(this.getPluginInterface(plugin.getClass()).getName());
                pluginDescriptor.setEnabled(Boolean.valueOf(true));
                continue;
            }
            if (results.size() == 1) {
                pluginDescriptor = results.values().iterator().next();
                pluginDescriptor.setIdentifier(pluginContext.getIdentifier());
                pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                pluginDescriptor.setName(plugin.getClass().getSimpleName());
                pluginDescriptor.setDescription(pluginContext.getDescription());
                pluginDescriptor.setLocation(pluginContext.getLocation().toString());
                pluginDescriptor.setPluginInterfaceClassName(this.getPluginInterface(plugin.getClass()).getName());
                session.store((IdEObject)pluginDescriptor);
                this.pluginManager.getPluginContext(plugin).setEnabled(pluginDescriptor.getEnabled().booleanValue(), false);
                continue;
            }
            this.LOGGER.error("Multiple plugin descriptor objects found with the same name: " + plugin.getClass().getName());
        }
    }

    public Path getHomeDir() {
        return this.config.getHomeDir();
    }

    public LongActionManager getLongActionManager() {
        return this.longActionManager;
    }

    public void setDefaultWebModule(WebModulePlugin defaultWebModule) {
        this.defaultWebModule = defaultWebModule;
    }

    public static void initHomeDir(BimServerConfig config) throws IOException {
        String[] filesToCheck = new String[]{"logs", "tmp", "logback.xml", "emailtemplates"};
        if (!Files.exists(config.getHomeDir(), new LinkOption[0])) {
            Files.createDirectories(config.getHomeDir(), new FileAttribute[0]);
        }
        if (Files.exists(config.getHomeDir(), new LinkOption[0]) && Files.isDirectory(config.getHomeDir(), new LinkOption[0])) {
            for (String fileToCheck : filesToCheck) {
                Path destFile;
                Path sourceFile = config.getResourceFetcher().getFile(fileToCheck);
                if (sourceFile == null || !Files.exists(sourceFile, new LinkOption[0]) || Files.exists(destFile = config.getHomeDir().resolve(fileToCheck), new LinkOption[0])) continue;
                if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                    Files.createDirectories(destFile, new FileAttribute[0]);
                    for (Path f : PathUtils.list((Path)sourceFile)) {
                        if (Files.isDirectory(f, new LinkOption[0])) {
                            Path destDir2 = destFile.resolve(f.getFileName().toString());
                            for (Path x : PathUtils.list((Path)f)) {
                                FileUtils.copyFile((File)x.toFile(), (File)destDir2.resolve(x.getFileName().toString()).toFile());
                            }
                            continue;
                        }
                        FileUtils.copyFile((File)f.toFile(), (File)destFile.resolve(f.getFileName().toString()).toFile());
                    }
                    continue;
                }
                FileUtils.copyFile((File)sourceFile.toFile(), (File)destFile.toFile());
            }
        }
    }

    public BimDatabase getDatabase() {
        return this.bimDatabase;
    }

    public ResourceFetcher getResourceFetcher() {
        return this.config.getResourceFetcher();
    }

    public GregorianCalendar getServerStartTime() {
        return this.serverStartTime;
    }

    public MergerFactory getMergerFactory() {
        return this.mergerFactory;
    }

    public void stop() {
        this.LOGGER.info("Stopping BIMserver");
        this.executorService.shutdown();
        if (this.bimDatabase != null) {
            try {
                this.bimDatabase.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.bimScheduler != null) {
            this.bimScheduler.close();
        }
        if (this.longActionManager != null) {
            this.longActionManager.shutdown();
        }
        if (this.notificationsManager != null) {
            this.notificationsManager.shutdown();
        }
        if (this.embeddedWebServer != null) {
            this.embeddedWebServer.shutdown();
        }
        if (this.protocolBuffersServer != null) {
            this.protocolBuffersServer.shutdown();
        }
        if (this.commandLine != null) {
            this.commandLine.shutdown();
        }
        this.pluginManager.close();
        this.LOGGER.info("BIMserver stopped");
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public MailSystem getMailSystem() {
        return this.mailSystem;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public DiskCacheManager getDiskCacheManager() {
        return this.diskCacheManager;
    }

    public String getClassPath() {
        return this.config.getClassPath();
    }

    public ServerInfo getServerInfo() {
        return this.serverInfoManager.getServerInfo();
    }

    public BimServerClientFactory getBimServerClientFactory() {
        return this.bimServerClientFactory;
    }

    public PublicInterfaceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public CompareCache getCompareCache() {
        return this.compareCache;
    }

    public NotificationsManager getNotificationsManager() {
        return this.notificationsManager;
    }

    public InternalServicesManager getInternalServicesManager() {
        return this.internalServicesManager;
    }

    public ServerInfoManager getServerInfoManager() {
        return this.serverInfoManager;
    }

    public ProtocolBuffersMetaData getProtocolBuffersMetaData() {
        return this.protocolBuffersMetaData;
    }

    public BimServerConfig getConfig() {
        return this.config;
    }

    public EmbeddedWebServerInterface getEmbeddedWebServer() {
        return this.embeddedWebServer;
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public SConverter getSConverter() {
        return this.sConverter;
    }

    public EndPointManager getEndPointManager() {
        return this.endPointManager;
    }

    public ServerSettingsCache getServerSettingsCache() {
        return this.serverSettingsCache;
    }

    public <T extends PublicInterface> T getService(Class<T> clazz) {
        return this.getServiceFactory().get(new SystemAuthorization(this.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS), AccessMethod.INTERNAL).get(clazz);
    }

    public LongTransactionManager getLongTransactionManager() {
        return this.longTransactionManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public SchemaConverterManager getSchemaConverterManager() {
        return this.schemaConverterManager;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setEmbeddedWebServer(EmbeddedWebServerInterface embeddedWebServer) {
        this.embeddedWebServer = embeddedWebServer;
    }

    public ConcurrentHashMap<Long, Long> getCheckinsInProgress() {
        return this.checkinsInProgress;
    }
}

