/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.ByteBuffer;
import java.util.TreeMap;

public class FloatingPointTest {
    public static void main(String[] args) {
        TreeMap<ByteArray, Float> floats = new TreeMap<ByteArray, Float>();
        floats.put(new ByteArray(1000000.5f), Float.valueOf(1000000.5f));
        floats.put(new ByteArray(0.5f), Float.valueOf(0.5f));
        floats.put(new ByteArray(1.5f), Float.valueOf(1.5f));
        floats.put(new ByteArray(5.0E-6f), Float.valueOf(5.0E-6f));
        floats.put(new ByteArray(0.005f), Float.valueOf(0.005f));
        for (ByteArray f : floats.keySet()) {
            System.out.println(f);
        }
    }

    public static class ByteArray
    implements Comparable<ByteArray> {
        private float f;
        private byte[] bytes;

        public ByteArray(float f) {
            this.f = f;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putFloat(f);
            this.bytes = buffer.array();
        }

        public String toString() {
            return "" + this.f;
        }

        @Override
        public int compareTo(ByteArray o) {
            for (int i = 0; i < 32; i = (int)((byte)(i + 1))) {
                byte a = o.bytes[i / 8];
                int x = a & i % 8;
                byte b = this.bytes[i / 8];
                int y = b & i % 8;
                if (x > y) {
                    return 1;
                }
                if (x >= y) continue;
                return -1;
            }
            return 0;
        }
    }
}

