/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.util.Random;
import org.bimserver.geometry.Matrix;
import org.bimserver.geometry.Vector;

public class GenericGeometryGenerator {
    private static boolean almostTheSame(float f1, float f2, float maxDiff) {
        return Math.abs(f1 - f2) < maxDiff;
    }

    private static float[] getTransformationMatrix(float[] originalV1, float[] originalV2, float[] originalV3, float[] u1, float[] u2, float[] u3, float maxDiff) {
        float[] v1 = GenericGeometryGenerator.copy(originalV1);
        float[] v2 = GenericGeometryGenerator.copy(originalV2);
        float[] v3 = GenericGeometryGenerator.copy(originalV3);
        u1 = GenericGeometryGenerator.copy(u1);
        u2 = GenericGeometryGenerator.copy(u2);
        u3 = GenericGeometryGenerator.copy(u3);
        float transX = u1[0] - v1[0];
        float transY = u1[1] - v1[1];
        float transZ = u1[2] - v1[2];
        float[] translation = new float[16];
        Matrix.setIdentityM((float[])translation, (int)0);
        Matrix.translateM((float[])translation, (int)0, (float)u1[0], (float)u1[1], (float)u1[2]);
        float[] toZeroTranslation = new float[16];
        Matrix.setIdentityM((float[])toZeroTranslation, (int)0);
        Matrix.translateM((float[])toZeroTranslation, (int)0, (float)(-v1[0]), (float)(-v1[1]), (float)(-v1[2]));
        if (GenericGeometryGenerator.almostTheSame(v2[0] + transX, u2[0], maxDiff) && GenericGeometryGenerator.almostTheSame(v2[1] + transY, u2[1], maxDiff) && GenericGeometryGenerator.almostTheSame(v2[2] + transZ, u2[2], maxDiff) && GenericGeometryGenerator.almostTheSame(v3[0] + transX, u3[0], maxDiff) && GenericGeometryGenerator.almostTheSame(v3[1] + transY, u3[1], maxDiff) && GenericGeometryGenerator.almostTheSame(v3[2] + transZ, u3[2], maxDiff)) {
            return translation;
        }
        GenericGeometryGenerator.subtract(u2, u1);
        GenericGeometryGenerator.subtract(u3, u1);
        GenericGeometryGenerator.subtract(u1, u1);
        GenericGeometryGenerator.subtract(v2, v1);
        GenericGeometryGenerator.subtract(v3, v1);
        GenericGeometryGenerator.subtract(v1, v1);
        float[] u2CrossV2 = Vector.crossProduct((float[])u2, (float[])v2);
        float[] r2 = new float[16];
        Matrix.setIdentityM((float[])r2, (int)0);
        float[] r2v2 = new float[4];
        if (!GenericGeometryGenerator.equalsAlmost(u2, v2, maxDiff)) {
            float u2InV2 = Vector.dot((float[])u2, (float[])v2);
            float[] axis = u2CrossV2;
            if (axis[0] == 0.0f && axis[1] == 0.0f && axis[2] == 0.0f) {
                axis = new float[]{u2[1], -u2[0], 0.0f, 0.0f};
            }
            Matrix.rotateM((float[])r2, (int)0, (float)((float)Math.toDegrees(Math.atan2(Vector.length((float[])u2CrossV2), u2InV2))), (float)axis[0], (float)axis[1], (float)axis[2]);
            Matrix.multiplyMV((float[])r2v2, (int)0, (float[])r2, (int)0, (float[])new float[]{v2[0], v2[1], v2[2], 1.0f}, (int)0);
            if (!GenericGeometryGenerator.equalsAlmost(r2v2, u2, maxDiff)) {
                Matrix.setIdentityM((float[])r2, (int)0);
                Matrix.rotateM((float[])r2, (int)0, (float)(-((float)Math.toDegrees(Math.atan2(Vector.length((float[])u2CrossV2), u2InV2)))), (float)axis[0], (float)axis[1], (float)axis[2]);
                Matrix.multiplyMV((float[])r2v2, (int)0, (float[])r2, (int)0, (float[])new float[]{v2[0], v2[1], v2[2], 1.0f}, (int)0);
                if (!GenericGeometryGenerator.equalsAlmost(r2v2, u2, maxDiff)) {
                    return null;
                }
            }
        } else {
            r2v2 = GenericGeometryGenerator.copy(v2);
        }
        float[] r2v3 = new float[4];
        Matrix.multiplyMV((float[])r2v3, (int)0, (float[])r2, (int)0, (float[])new float[]{v3[0], v3[1], v3[2], 1.0f}, (int)0);
        float[] r3 = new float[16];
        Matrix.setIdentityM((float[])r3, (int)0);
        float angleDegrees = (float)Math.toDegrees(GenericGeometryGenerator.getPlaneAngle(v1, r2v2, r2v3, u1, u2, u3));
        Matrix.rotateM((float[])r3, (int)0, (float)angleDegrees, (float)r2v2[0], (float)r2v2[1], (float)r2v2[2]);
        float[] r3v3 = new float[4];
        Matrix.multiplyMV((float[])r3v3, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v3[0], r2v3[1], r2v3[2], 1.0f}, (int)0);
        float[] r2v1 = new float[4];
        Matrix.multiplyMV((float[])r2v1, (int)0, (float[])r2, (int)0, (float[])new float[]{v1[0], v1[1], v1[2], 1.0f}, (int)0);
        float[] r3v1 = new float[4];
        Matrix.multiplyMV((float[])r3v1, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v1[0], r2v1[1], r2v1[2], 1.0f}, (int)0);
        if (!GenericGeometryGenerator.equalsAlmost(r3v3, u3, maxDiff)) {
            Matrix.setIdentityM((float[])r3, (int)0);
            Matrix.rotateM((float[])r3, (int)0, (float)(-angleDegrees), (float)r2v2[0], (float)r2v2[1], (float)r2v2[2]);
            Matrix.multiplyMV((float[])r3v3, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v3[0], r2v3[1], r2v3[2], 1.0f}, (int)0);
            float[] r3v2 = new float[4];
            Matrix.multiplyMV((float[])r3v2, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v2[0], r2v2[1], r2v2[2], 1.0f}, (int)0);
            if (!GenericGeometryGenerator.equalsAlmost(r3v3, u3, maxDiff) || !GenericGeometryGenerator.equalsAlmost(r3v2, u2, maxDiff)) {
                return null;
            }
        }
        float[] subResult = new float[16];
        float[] subResult2 = new float[16];
        float[] subResult3 = new float[16];
        float[] totalResult = new float[16];
        float[] startMatrix = new float[16];
        Matrix.setIdentityM((float[])startMatrix, (int)0);
        Matrix.multiplyMM((float[])subResult, (int)0, (float[])toZeroTranslation, (int)0, (float[])startMatrix, (int)0);
        Matrix.multiplyMM((float[])subResult2, (int)0, (float[])r2, (int)0, (float[])subResult, (int)0);
        Matrix.multiplyMM((float[])subResult3, (int)0, (float[])r3, (int)0, (float[])subResult2, (int)0);
        Matrix.multiplyMM((float[])totalResult, (int)0, (float[])translation, (int)0, (float[])subResult3, (int)0);
        return totalResult;
    }

    private static double getPlaneAngle(float[] v1, float[] v2, float[] v3, float[] u1, float[] u2, float[] u3) {
        double result;
        float den;
        float[] cross1 = Vector.crossProduct((float[])new float[]{v2[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]}, (float[])new float[]{v3[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]});
        float[] fArray = new float[]{u2[0] - u1[0], u2[1] - u1[1], u2[2] - u1[2]};
        float[] fArray2 = new float[]{u3[0] - u1[0], u3[1] - u1[1], u3[2] - u1[2]};
        float[] cross2 = Vector.crossProduct((float[])fArray, (float[])fArray2);
        float num = Vector.dot((float[])cross1, (float[])cross2);
        float a = num / (den = Vector.length((float[])cross1) * Vector.length((float[])cross2));
        if (a > 1.0f) {
            a = 1.0f;
        }
        if (a < -1.0f) {
            a = -1.0f;
        }
        if (Double.isNaN(result = Math.acos(a))) {
            System.out.println();
        }
        return result;
    }

    private static boolean equalsAlmost(float[] r2v2, float[] u2, float maxDiff) {
        for (int i = 0; i < 3; ++i) {
            if (GenericGeometryGenerator.almostTheSame(r2v2[i], u2[i], maxDiff)) continue;
            return false;
        }
        return true;
    }

    private static float[] copy(float[] v1) {
        float[] result = new float[v1.length];
        System.arraycopy(v1, 0, result, 0, v1.length);
        return result;
    }

    private static boolean test(float[] v1, float[] v2, float[] transformationMatrix, float maxDiff) {
        float[] resultVector = new float[4];
        Matrix.multiplyMV((float[])resultVector, (int)0, (float[])transformationMatrix, (int)0, (float[])new float[]{v1[0], v1[1], v1[2], 1.0f}, (int)0);
        GenericGeometryGenerator.normalize(resultVector);
        boolean theSame = true;
        for (int i = 0; i < 3; ++i) {
            if (GenericGeometryGenerator.almostTheSame(resultVector[i], v2[i], maxDiff)) continue;
            theSame = false;
        }
        if (!theSame) {
            System.out.println("Difference");
            Vector.dump((String)"Was", (float[])v1);
            Vector.dump((String)"Became", (float[])resultVector);
            Vector.dump((String)"Should be", (float[])v2);
            System.out.println();
            return false;
        }
        return true;
    }

    private static void normalize(float[] resultVector) {
        resultVector[0] = resultVector[0] * resultVector[3];
        resultVector[1] = resultVector[1] * resultVector[3];
        resultVector[2] = resultVector[2] * resultVector[3];
        resultVector[3] = 1.0f;
    }

    private static void subtract(float[] u2, float[] v1) {
        u2[0] = u2[0] - v1[0];
        u2[1] = u2[1] - v1[1];
        u2[2] = u2[2] - v1[2];
    }

    public static void main(String[] args) {
        float maxDiff = 0.1f;
        GenericGeometryGenerator.test1(maxDiff);
        GenericGeometryGenerator.test2(maxDiff);
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            float[] matrix = new float[16];
            Matrix.setIdentityM((float[])matrix, (int)0);
            for (int j = 0; j < 10; ++j) {
                Matrix.rotateM((float[])matrix, (int)0, (float)(random.nextFloat() * 360.0f), (float)random.nextFloat(), (float)random.nextFloat(), (float)random.nextFloat());
            }
            float[] v1 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] v2 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] v3 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] r1 = new float[4];
            float[] r2 = new float[4];
            float[] r3 = new float[4];
            Matrix.multiplyMV((float[])r1, (int)0, (float[])matrix, (int)0, (float[])v1, (int)0);
            Matrix.multiplyMV((float[])r2, (int)0, (float[])matrix, (int)0, (float[])v2, (int)0);
            Matrix.multiplyMV((float[])r3, (int)0, (float[])matrix, (int)0, (float[])v3, (int)0);
            float[] calculatedMatrix = GenericGeometryGenerator.getTransformationMatrix(v1, v2, v3, r1, r2, r3, maxDiff);
            GenericGeometryGenerator.test(v1, r1, calculatedMatrix, maxDiff);
            GenericGeometryGenerator.test(v2, r2, calculatedMatrix, maxDiff);
            GenericGeometryGenerator.test(v3, r3, calculatedMatrix, maxDiff);
            for (int j = 0; j < 10; ++j) {
                float[] q1 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] q2 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] q3 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] b1 = new float[4];
                float[] b2 = new float[4];
                float[] b3 = new float[4];
                Matrix.multiplyMV((float[])b1, (int)0, (float[])matrix, (int)0, (float[])q1, (int)0);
                Matrix.multiplyMV((float[])b2, (int)0, (float[])matrix, (int)0, (float[])q2, (int)0);
                Matrix.multiplyMV((float[])b3, (int)0, (float[])matrix, (int)0, (float[])q3, (int)0);
                GenericGeometryGenerator.test(q1, b1, calculatedMatrix, maxDiff);
                GenericGeometryGenerator.test(q2, b2, calculatedMatrix, maxDiff);
                GenericGeometryGenerator.test(q3, b3, calculatedMatrix, maxDiff);
            }
        }
    }

    private static void test1(float maxDiff) {
        float[] v1 = new float[]{1.0f, 2.0f, 0.0f};
        float[] v2 = new float[]{1.0f, 1.0f, 0.0f};
        float[] v3 = new float[]{3.0f, 2.0f, 0.0f};
        float[] u1 = new float[]{0.0f, 2.0f, 0.0f};
        float[] u2 = new float[]{-1.0f, 2.0f, 0.0f};
        float[] u3 = new float[]{0.0f, 2.0f, 2.0f};
        float[] transformationMatrix = GenericGeometryGenerator.getTransformationMatrix(v1, v2, v3, u1, u2, u3, maxDiff);
        GenericGeometryGenerator.test(v1, u1, transformationMatrix, maxDiff);
        GenericGeometryGenerator.test(v2, u2, transformationMatrix, maxDiff);
        GenericGeometryGenerator.test(v3, u3, transformationMatrix, maxDiff);
    }

    private static void test2(float maxDiff) {
        float[] v1 = new float[]{3.0f, 0.0f, 0.0f};
        float[] v2 = new float[]{4.0f, 0.0f, 0.0f};
        float[] v3 = new float[]{4.0f, 1.0f, 0.0f};
        float[] u1 = new float[]{1.0f, 3.0f, 0.0f};
        float[] u2 = new float[]{0.0f, 3.0f, 0.0f};
        float[] u3 = new float[]{0.0f, 2.0f, 0.0f};
        float[] transformationMatrix = GenericGeometryGenerator.getTransformationMatrix(v1, v2, v3, u1, u2, u3, maxDiff);
        GenericGeometryGenerator.test(v1, u1, transformationMatrix, maxDiff);
        GenericGeometryGenerator.test(v2, u2, transformationMatrix, maxDiff);
        GenericGeometryGenerator.test(v3, u3, transformationMatrix, maxDiff);
    }
}

