/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GenericGeometryGenerator;
import org.bimserver.GeometryCache;
import org.bimserver.GeometryCacheEntry;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.Schema;
import org.bimserver.geometry.Matrix;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryFactory;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.models.ifc2x3tc1.IfcBoundingBox;
import org.bimserver.models.ifc2x3tc1.IfcShapeRepresentation;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.ObjectAlreadyExistsException;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.objectidms.HideAllInversesObjectIDM;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.plugins.renderengine.EntityNotFoundException;
import org.bimserver.plugins.renderengine.IndexFormat;
import org.bimserver.plugins.renderengine.Precision;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineGeometry;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.bimserver.plugins.serializers.Serializer;
import org.bimserver.plugins.serializers.SerializerInputstream;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.plugins.serializers.StreamingReader;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;
import org.bimserver.utils.Formatters;
import org.bimserver.utils.GeometryUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryGenerator
extends GenericGeometryGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryGenerator.class);
    private final BimServer bimServer;
    private final Map<Integer, GeometryData> hashes = new ConcurrentHashMap<Integer, GeometryData>();
    private EClass productClass;
    private EClass productRepresentationClass;
    private EStructuralFeature geometryFeature;
    private EStructuralFeature representationFeature;
    private EStructuralFeature representationsFeature;
    private PackageMetaData packageMetaData;
    private AtomicLong bytesSaved = new AtomicLong();
    private AtomicLong totalBytes = new AtomicLong();

    public GeometryGenerator(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    public GenerateGeometryResult generateGeometry(RenderEnginePool renderEnginePool, PluginManager pluginManager, final DatabaseSession databaseSession, IfcModelInterface model, int pid, int rid, boolean store, GeometryCache geometryCache) throws BimserverDatabaseException, GeometryGeneratingException {
        GenerateGeometryResult generateGeometryResult = new GenerateGeometryResult();
        this.packageMetaData = model.getPackageMetaData();
        this.productClass = this.packageMetaData.getEClass("IfcProduct");
        this.productRepresentationClass = this.packageMetaData.getEClass("IfcProductRepresentation");
        this.geometryFeature = this.productClass.getEStructuralFeature("geometry");
        this.representationFeature = this.productClass.getEStructuralFeature("Representation");
        this.representationsFeature = this.productRepresentationClass.getEStructuralFeature("Representations");
        if (geometryCache != null && !geometryCache.isEmpty()) {
            this.returnCachedData(model, geometryCache, databaseSession, pid, rid);
            return null;
        }
        long start = System.nanoTime();
        String pluginName = "";
        if (model.getPackageMetaData().getSchema() == Schema.IFC4) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc4StepSerializerPlugin";
        } else if (model.getPackageMetaData().getSchema() == Schema.IFC2X3TC1) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc2x3tc1StepSerializerPlugin";
        }
        try {
            SerializerPlugin ifcSerializerPlugin = (SerializerPlugin)pluginManager.getPlugin(pluginName, true);
            if (ifcSerializerPlugin == null) {
                throw new UserException("No IFC serializer found");
            }
            int maxSimultanousThreads = Math.min(this.bimServer.getServerSettingsCache().getServerSettings().getRenderEngineProcesses(), Runtime.getRuntime().availableProcessors());
            maxSimultanousThreads = 1;
            RenderEngineSettings settings = new RenderEngineSettings();
            settings.setPrecision(Precision.SINGLE);
            settings.setIndexFormat(IndexFormat.AUTO_DETECT);
            settings.setGenerateNormals(true);
            settings.setGenerateTriangles(true);
            settings.setGenerateWireFrame(false);
            RenderEngineFilter renderEngineFilter = new RenderEngineFilter();
            if (maxSimultanousThreads == 1) {
                Runner runner = new Runner(null, renderEnginePool, databaseSession, settings, store, model, ifcSerializerPlugin, model, pid, rid, null, renderEngineFilter, generateGeometryResult);
                runner.run();
            } else {
                HashSet<EClass> classes = new HashSet<EClass>();
                for (IdEObject object : model.getAllWithSubTypes(this.packageMetaData.getEClass("IfcProduct"))) {
                    IdEObject representation = (IdEObject)object.eGet(this.representationFeature);
                    if (representation == null || ((List)representation.eGet(this.representationsFeature)).size() <= 0) continue;
                    classes.add(object.eClass());
                }
                if (classes.size() == 0) {
                    return null;
                }
                classes.remove(this.packageMetaData.getEClass("IfcAnnotation"));
                classes.remove(this.packageMetaData.getEClass("IfcOpeningElement"));
                LOGGER.debug("Using " + maxSimultanousThreads + " processes for geometry generation");
                ThreadPoolExecutor executor = new ThreadPoolExecutor(maxSimultanousThreads, maxSimultanousThreads, 24L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(classes.size()));
                HashMap<IdEObject, IdEObject> bigMap = new HashMap<IdEObject, IdEObject>();
                HideAllInversesObjectIDM idm = new HideAllInversesObjectIDM(CollectionUtils.singleSet((Object)this.packageMetaData.getEPackage()), model.getPackageMetaData());
                OidProvider oidProvider = new OidProvider(){

                    public long newOid(EClass eClass) {
                        return databaseSession.newOid(eClass);
                    }
                };
                for (EClass eClass : classes) {
                    BasicIfcModel targetModel = new BasicIfcModel(model.getPackageMetaData(), null);
                    ModelHelper modelHelper = new ModelHelper(this.bimServer.getMetaDataManager(), (IfcModelInterface)targetModel);
                    modelHelper.setOidProvider(oidProvider);
                    modelHelper.setObjectIDM((ObjectIDM)idm);
                    IdEObject newOwnerHistory = modelHelper.copyBasicObjects(model, bigMap);
                    for (IdEObject idEObject : model.getAll(eClass)) {
                        IdEObject newObject = modelHelper.copy(idEObject, false, ModelHelper.createObjectIdm((EClass)idEObject.eClass()));
                        modelHelper.copyDecomposes(idEObject, newOwnerHistory);
                        bigMap.put(newObject, idEObject);
                        if (!this.packageMetaData.getEClass("IfcElement").isSuperTypeOf(eClass)) continue;
                        EStructuralFeature hasOpeningsFeature = idEObject.eClass().getEStructuralFeature("HasOpenings");
                        for (IdEObject ifcRelVoidsElement : (List)idEObject.eGet(hasOpeningsFeature)) {
                            bigMap.put(modelHelper.copy(ifcRelVoidsElement, false), ifcRelVoidsElement);
                            EStructuralFeature relatedOpeningElementFeature = ifcRelVoidsElement.eClass().getEStructuralFeature("RelatedOpeningElement");
                            IdEObject relatedOpeningElement = (IdEObject)ifcRelVoidsElement.eGet(relatedOpeningElementFeature);
                            if (relatedOpeningElement == null) continue;
                            bigMap.put(modelHelper.copy(relatedOpeningElement, false), relatedOpeningElement);
                        }
                    }
                    executor.submit(new Runner(eClass, renderEnginePool, databaseSession, settings, store, (IfcModelInterface)targetModel, ifcSerializerPlugin, model, pid, rid, bigMap, renderEngineFilter, generateGeometryResult));
                }
                executor.shutdown();
                executor.awaitTermination(24L, TimeUnit.HOURS);
            }
            long end = System.nanoTime();
            LOGGER.info("Rendertime: " + (end - start) / 1000000L + "ms, Reused: " + Formatters.bytesToString((long)this.bytesSaved.get()) + ", Total: " + Formatters.bytesToString((long)this.totalBytes.get()) + ", Final: " + Formatters.bytesToString((long)(this.totalBytes.get() - this.bytesSaved.get())));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new GeometryGeneratingException(e);
        }
        return generateGeometryResult;
    }

    private int hash(GeometryData geometryData) {
        int hashCode = 0;
        if (geometryData.getIndices() != null) {
            hashCode += Arrays.hashCode(geometryData.getIndices());
        }
        if (geometryData.getVertices() != null) {
            hashCode += Arrays.hashCode(geometryData.getVertices());
        }
        if (geometryData.getNormals() != null) {
            hashCode += Arrays.hashCode(geometryData.getNormals());
        }
        if (geometryData.getMaterialIndices() != null) {
            hashCode += Arrays.hashCode(geometryData.getMaterialIndices());
        }
        if (geometryData.getMaterials() != null) {
            hashCode += Arrays.hashCode(geometryData.getMaterials());
        }
        return hashCode;
    }

    private void processExtendsUntranslated(GeometryInfo geometryInfo, float[] vertices, int index, GenerateGeometryResult generateGeometryResult2) throws BimserverDatabaseException {
        double x = vertices[index];
        double y = vertices[index + 1];
        double z = vertices[index + 2];
        Vector3f minBounds = geometryInfo.getMinBoundsUntranslated();
        Vector3f maxBounds = geometryInfo.getMaxBoundsUntranslated();
        minBounds.setX(Math.min(x, minBounds.getX()));
        minBounds.setY(Math.min(y, minBounds.getY()));
        minBounds.setZ(Math.min(z, minBounds.getZ()));
        maxBounds.setX(Math.max(x, maxBounds.getX()));
        maxBounds.setY(Math.max(y, maxBounds.getY()));
        maxBounds.setZ(Math.max(z, maxBounds.getZ()));
    }

    private void processExtends(GeometryInfo geometryInfo, double[] transformationMatrix, float[] vertices, int index, GenerateGeometryResult generateGeometryResult) {
        double x = vertices[index];
        double y = vertices[index + 1];
        double z = vertices[index + 2];
        double[] result = new double[4];
        Matrix.multiplyMV((double[])result, (int)0, (double[])transformationMatrix, (int)0, (double[])new double[]{x, y, z, 1.0}, (int)0);
        x = result[0];
        y = result[1];
        z = result[2];
        geometryInfo.getMinBounds().setX(Math.min(x, geometryInfo.getMinBounds().getX()));
        geometryInfo.getMinBounds().setY(Math.min(y, geometryInfo.getMinBounds().getY()));
        geometryInfo.getMinBounds().setZ(Math.min(z, geometryInfo.getMinBounds().getZ()));
        geometryInfo.getMaxBounds().setX(Math.max(x, geometryInfo.getMaxBounds().getX()));
        geometryInfo.getMaxBounds().setY(Math.max(y, geometryInfo.getMaxBounds().getY()));
        geometryInfo.getMaxBounds().setZ(Math.max(z, geometryInfo.getMaxBounds().getZ()));
        generateGeometryResult.setMinX(Math.min(x, generateGeometryResult.getMinX()));
        generateGeometryResult.setMinY(Math.min(y, generateGeometryResult.getMinY()));
        generateGeometryResult.setMinZ(Math.min(z, generateGeometryResult.getMinZ()));
        generateGeometryResult.setMaxX(Math.max(x, generateGeometryResult.getMaxX()));
        generateGeometryResult.setMaxY(Math.max(y, generateGeometryResult.getMaxY()));
        generateGeometryResult.setMaxZ(Math.max(z, generateGeometryResult.getMaxZ()));
    }

    private void setTransformationMatrix(GeometryInfo geometryInfo, double[] transformationMatrix) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer asDoubleBuffer = byteBuffer.asDoubleBuffer();
        for (double f : transformationMatrix) {
            asDoubleBuffer.put(f);
        }
        geometryInfo.setTransformation(byteBuffer.array());
    }

    private void returnCachedData(IfcModelInterface model, GeometryCache geometryCache, DatabaseSession databaseSession, int pid, int rid) throws BimserverDatabaseException {
        EClass productClass = model.getPackageMetaData().getEClass("IfcProduct");
        List products = model.getAllWithSubTypes(productClass);
        for (IdEObject ifcProduct : products) {
            GeometryCacheEntry geometryCacheEntry = geometryCache.get(ifcProduct.getExpressId());
            if (geometryCacheEntry == null) continue;
            GeometryData geometryData = (GeometryData)databaseSession.create(GeometryPackage.eINSTANCE.getGeometryData(), pid, rid);
            geometryData.setVertices(geometryCacheEntry.getVertices().array());
            geometryData.setNormals(geometryCacheEntry.getNormals().array());
            GeometryInfo geometryInfo = (GeometryInfo)databaseSession.create(GeometryPackage.eINSTANCE.getGeometryInfo(), pid, rid);
            Vector3f min = (Vector3f)databaseSession.create(GeometryPackage.eINSTANCE.getVector3f(), pid, rid);
            min.setX(geometryCacheEntry.getGeometryInfo().getMinBounds().getX());
            min.setY(geometryCacheEntry.getGeometryInfo().getMinBounds().getY());
            min.setZ(geometryCacheEntry.getGeometryInfo().getMinBounds().getZ());
            Vector3f max = (Vector3f)databaseSession.create(GeometryPackage.eINSTANCE.getVector3f(), pid, rid);
            max.setX(geometryCacheEntry.getGeometryInfo().getMaxBounds().getX());
            max.setY(geometryCacheEntry.getGeometryInfo().getMaxBounds().getY());
            max.setZ(geometryCacheEntry.getGeometryInfo().getMaxBounds().getZ());
            geometryInfo.setMinBounds(min);
            geometryInfo.setMaxBounds(max);
            geometryInfo.setData(geometryData);
            ifcProduct.eSet(ifcProduct.eClass().getEStructuralFeature("geometry"), (Object)geometryInfo);
        }
    }

    private Vector3f createVector3f(PackageMetaData packageMetaData, IfcModelInterface model, double defaultValue, DatabaseSession session, boolean store, int pid, int rid) throws BimserverDatabaseException, IfcModelInterfaceException, ObjectAlreadyExistsException {
        Vector3f vector3f = null;
        if (store) {
            vector3f = (Vector3f)model.createAndAdd(GeometryPackage.eINSTANCE.getVector3f(), session.newOid(GeometryPackage.eINSTANCE.getVector3f()));
            session.store((IdEObject)vector3f, pid, rid);
        } else {
            vector3f = GeometryFactory.eINSTANCE.createVector3f();
        }
        vector3f.setX(defaultValue);
        vector3f.setY(defaultValue);
        vector3f.setZ(defaultValue);
        return vector3f;
    }

    public class Runner
    implements Runnable {
        private EClass eClass;
        private DatabaseSession databaseSession;
        private RenderEngineSettings renderEngineSettings;
        private RenderEngineFilter renderEngineFilter;
        private RenderEngineFilter renderEngineFilterTransformed = new RenderEngineFilter(true);
        private boolean store;
        private IfcModelInterface targetModel;
        private SerializerPlugin ifcSerializerPlugin;
        private IfcModelInterface model;
        private int pid;
        private int rid;
        private Map<IdEObject, IdEObject> bigMap;
        private GenerateGeometryResult generateGeometryResult;
        private RenderEnginePool renderEnginePool;

        public Runner(EClass eClass, RenderEnginePool renderEnginePool, DatabaseSession databaseSession, RenderEngineSettings renderEngineSettings, boolean store, IfcModelInterface targetModel, SerializerPlugin ifcSerializerPlugin, IfcModelInterface model, int pid, int rid, Map<IdEObject, IdEObject> bigMap, RenderEngineFilter renderEngineFilter, GenerateGeometryResult generateGeometryResult) {
            this.eClass = eClass;
            this.renderEnginePool = renderEnginePool;
            this.databaseSession = databaseSession;
            this.renderEngineSettings = renderEngineSettings;
            this.store = store;
            this.targetModel = targetModel;
            this.ifcSerializerPlugin = ifcSerializerPlugin;
            this.model = model;
            this.pid = pid;
            this.rid = rid;
            this.bigMap = bigMap;
            this.renderEngineFilter = renderEngineFilter;
            this.generateGeometryResult = generateGeometryResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.targetModel.generateMinimalExpressIds();
            Serializer ifcSerializer = this.ifcSerializerPlugin.createSerializer(new PluginConfiguration());
            RenderEngine renderEngine = null;
            try {
                renderEngine = this.renderEnginePool.borrowObject();
                ifcSerializer.init(this.targetModel, null, true);
                boolean debug = false;
                Object in = null;
                if (debug) {
                    File file = new File((this.eClass == null ? "all" : this.eClass.getName()) + ".ifc");
                    FileOutputStream fos = new FileOutputStream(file);
                    ifcSerializer.writeToOutputStream((OutputStream)fos, null);
                    fos.close();
                    in = new FileInputStream(file);
                } else {
                    in = new SerializerInputstream((StreamingReader)ifcSerializer);
                }
                RenderEngineModel renderEngineModel = renderEngine.openModel((InputStream)in);
                try {
                    renderEngineModel.setSettings(this.renderEngineSettings);
                    renderEngineModel.setFilter(this.renderEngineFilter);
                    renderEngineModel.generateGeneralGeometry();
                    List allWithSubTypes = null;
                    allWithSubTypes = this.eClass == null ? this.targetModel.getAllWithSubTypes(GeometryGenerator.this.packageMetaData.getEClass("IfcProduct")) : this.targetModel.getAll(this.eClass);
                    for (IdEObject ifcProduct : allWithSubTypes) {
                        IdEObject representation = (IdEObject)ifcProduct.eGet(GeometryGenerator.this.representationFeature);
                        if (representation == null || ((List)representation.eGet(GeometryGenerator.this.representationsFeature)).size() <= 0) continue;
                        List representations = (List)representation.eGet(GeometryGenerator.this.representationsFeature);
                        GeometryInfo geometryInfo = null;
                        try {
                            RenderEngineInstance renderEngineInstance = renderEngineModel.getInstanceFromExpressId(ifcProduct.getExpressId());
                            RenderEngineGeometry geometry = renderEngineInstance.generateGeometry();
                            boolean translate = true;
                            if (geometry == null || geometry.getIndices().length == 0) {
                                renderEngineModel.setFilter(this.renderEngineFilterTransformed);
                                geometry = renderEngineInstance.generateGeometry();
                                if (geometry != null) {
                                    translate = false;
                                }
                                renderEngineModel.setFilter(this.renderEngineFilter);
                            }
                            if (geometry == null || geometry.getNrIndices() <= 0) continue;
                            if (this.store) {
                                geometryInfo = (GeometryInfo)this.model.createAndAdd(GeometryPackage.eINSTANCE.getGeometryInfo(), this.databaseSession.newOid(GeometryPackage.eINSTANCE.getGeometryInfo()));
                                this.databaseSession.store((IdEObject)geometryInfo, this.pid, this.rid);
                            } else {
                                geometryInfo = GeometryFactory.eINSTANCE.createGeometryInfo();
                            }
                            geometryInfo.setMinBounds(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Double.POSITIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
                            geometryInfo.setMaxBounds(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Double.NEGATIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
                            geometryInfo.setMinBoundsUntranslated(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Double.POSITIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
                            geometryInfo.setMaxBoundsUntranslated(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Double.NEGATIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
                            try {
                                double area = renderEngineInstance.getArea();
                                geometryInfo.setArea(area);
                                double volume = renderEngineInstance.getVolume();
                                if (volume < 0.0) {
                                    volume = -volume;
                                }
                                geometryInfo.setVolume(volume);
                            }
                            catch (UnsupportedOperationException area) {
                                // empty catch block
                            }
                            GeometryData geometryData = null;
                            if (this.store) {
                                geometryData = (GeometryData)this.model.createAndAdd(GeometryPackage.eINSTANCE.getGeometryData(), this.databaseSession.newOid(GeometryPackage.eINSTANCE.getGeometryData()));
                                this.databaseSession.store((IdEObject)geometryData, this.pid, this.rid);
                            } else {
                                geometryData = GeometryFactory.eINSTANCE.createGeometryData();
                            }
                            geometryData.setIndices(GeometryUtils.intArrayToByteArray((int[])geometry.getIndices()));
                            geometryData.setVertices(GeometryUtils.floatArrayToByteArray((float[])geometry.getVertices()));
                            geometryData.setNormals(GeometryUtils.floatArrayToByteArray((float[])geometry.getNormals()));
                            geometryInfo.setPrimitiveCount(Integer.valueOf(geometry.getIndices().length / 3));
                            if (geometry.getMaterialIndices() != null && geometry.getMaterialIndices().length > 0) {
                                boolean hasMaterial = false;
                                float[] vertex_colors = new float[geometry.getVertices().length / 3 * 4];
                                for (int i = 0; i < geometry.getMaterialIndices().length; ++i) {
                                    int c = geometry.getMaterialIndices()[i];
                                    for (int j = 0; j < 3; ++j) {
                                        int k = geometry.getIndices()[i * 3 + j];
                                        if (c <= -1) continue;
                                        hasMaterial = true;
                                        for (int l = 0; l < 4; ++l) {
                                            vertex_colors[4 * k + l] = geometry.getMaterials()[4 * c + l];
                                        }
                                    }
                                }
                                if (hasMaterial) {
                                    geometryData.setMaterials(GeometryUtils.floatArrayToByteArray((float[])vertex_colors));
                                }
                            }
                            double[] tranformationMatrix = new double[16];
                            Matrix.setIdentityM((double[])tranformationMatrix, (int)0);
                            if (translate && renderEngineInstance.getTransformationMatrix() != null) {
                                tranformationMatrix = renderEngineInstance.getTransformationMatrix();
                            }
                            for (int i = 0; i < geometry.getIndices().length; ++i) {
                                GeometryGenerator.this.processExtendsUntranslated(geometryInfo, geometry.getVertices(), geometry.getIndices()[i] * 3, this.generateGeometryResult);
                                GeometryGenerator.this.processExtends(geometryInfo, tranformationMatrix, geometry.getVertices(), geometry.getIndices()[i] * 3, this.generateGeometryResult);
                            }
                            geometryInfo.setData(geometryData);
                            long length = (geometryData.getIndices() != null ? geometryData.getIndices().length : 0) + (geometryData.getVertices() != null ? geometryData.getVertices().length : 0) + (geometryData.getNormals() != null ? geometryData.getNormals().length : 0) + (geometryData.getMaterials() != null ? geometryData.getMaterials().length : 0) + (geometryData.getMaterialIndices() != null ? geometryData.getMaterialIndices().length : 0);
                            GeometryGenerator.this.setTransformationMatrix(geometryInfo, tranformationMatrix);
                            if (this.store && GeometryGenerator.this.bimServer.getServerSettingsCache().getServerSettings().isReuseGeometry()) {
                                int hash = GeometryGenerator.this.hash(geometryData);
                                if (GeometryGenerator.this.hashes.containsKey(hash)) {
                                    this.databaseSession.removeFromCommit((IdEObject)geometryData);
                                    geometryInfo.setData((GeometryData)GeometryGenerator.this.hashes.get(hash));
                                    GeometryGenerator.this.bytesSaved.addAndGet(length);
                                } else {
                                    GeometryGenerator.this.hashes.put(hash, geometryData);
                                }
                            }
                            GeometryGenerator.this.totalBytes.addAndGet(length);
                            if (this.bigMap == null) {
                                ifcProduct.eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                                if (!this.store) continue;
                                this.databaseSession.store(ifcProduct, this.pid, this.rid);
                                continue;
                            }
                            this.bigMap.get(ifcProduct).eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                            ifcProduct.eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                            if (!this.store) continue;
                            this.databaseSession.store(this.bigMap.get(ifcProduct), this.pid, this.rid);
                        }
                        catch (EntityNotFoundException e) {
                            boolean ignoreNotFound = true;
                            for (Object rep : representations) {
                                IfcShapeRepresentation ifcShapeRepresentation;
                                if (!(rep instanceof IfcShapeRepresentation) || "Curve2D".equals((ifcShapeRepresentation = (IfcShapeRepresentation)rep).getRepresentationType())) continue;
                                ignoreNotFound = false;
                            }
                            if (ignoreNotFound) continue;
                            LOGGER.info("Entity not found " + ifcProduct.eClass().getName() + " " + ifcProduct.getExpressId() + "/" + ifcProduct.getOid());
                        }
                        catch (BimserverDatabaseException | RenderEngineException e) {
                            LOGGER.error("", e);
                        }
                        catch (IfcModelInterfaceException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                }
                finally {
                    ((InputStream)in).close();
                    renderEngineModel.close();
                    if (renderEngine != null) {
                        this.renderEnginePool.returnObject(renderEngine);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }

        private float[] doubleToFloat(double[] tranformationMatrix) {
            float[] result = new float[tranformationMatrix.length];
            for (int i = 0; i < tranformationMatrix.length; ++i) {
                result[i] = (float)tranformationMatrix[i];
            }
            return result;
        }

        private void createBoundingBoxGeometry(IfcBoundingBox ifcBoundingBox, IdEObject ifcProduct) throws IfcModelInterfaceException, BimserverDatabaseException, ObjectAlreadyExistsException {
            System.out.println("bb " + ifcProduct.getOid());
            GeometryInfo geometryInfo = (GeometryInfo)this.model.createAndAdd(GeometryPackage.eINSTANCE.getGeometryInfo(), this.databaseSession.newOid(GeometryPackage.eINSTANCE.getGeometryInfo()));
            this.databaseSession.store((IdEObject)geometryInfo, this.pid, this.rid);
            geometryInfo.setMinBounds(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Double.POSITIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
            geometryInfo.setMaxBounds(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Double.NEGATIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
            GeometryData geometryData = (GeometryData)this.model.createAndAdd(GeometryPackage.eINSTANCE.getGeometryData(), this.databaseSession.newOid(GeometryPackage.eINSTANCE.getGeometryData()));
            this.databaseSession.store((IdEObject)geometryData, this.pid, this.rid);
            int[] indices = new int[]{0, 1, 2, 0, 2, 3, 5, 6, 1, 1, 6, 2, 2, 6, 7, 2, 7, 3, 5, 6, 7, 7, 4, 5, 1, 5, 4, 0, 1, 4, 7, 3, 0, 0, 4, 7};
            float[] vertices = new float[]{0.0f, 0.0f, 0.0f, (float)ifcBoundingBox.getXDim(), 0.0f, 0.0f, (float)ifcBoundingBox.getXDim(), (float)ifcBoundingBox.getYDim(), 0.0f, 0.0f, (float)ifcBoundingBox.getYDim(), 0.0f, 0.0f, 0.0f, (float)ifcBoundingBox.getZDim(), (float)ifcBoundingBox.getXDim(), 0.0f, (float)ifcBoundingBox.getZDim(), (float)ifcBoundingBox.getXDim(), (float)ifcBoundingBox.getYDim(), (float)ifcBoundingBox.getZDim(), 0.0f, (float)ifcBoundingBox.getYDim(), (float)ifcBoundingBox.getZDim()};
            float[] normals = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            geometryData.setIndices(GeometryUtils.intArrayToByteArray((int[])indices));
            geometryData.setVertices(GeometryUtils.floatArrayToByteArray((float[])vertices));
            geometryData.setNormals(GeometryUtils.floatArrayToByteArray((float[])normals));
            geometryInfo.setPrimitiveCount(Integer.valueOf(12));
            geometryInfo.setData(geometryData);
            double[] tranformationMatrix = new double[16];
            Matrix.setIdentityM((double[])tranformationMatrix, (int)0);
            Matrix.translateM((double[])tranformationMatrix, (int)0, (double)((Double)ifcBoundingBox.getCorner().getCoordinates().get(0)), (double)((Double)ifcBoundingBox.getCorner().getCoordinates().get(1)), (double)((Double)ifcBoundingBox.getCorner().getCoordinates().get(2)));
            GeometryGenerator.this.setTransformationMatrix(geometryInfo, tranformationMatrix);
            if (this.bigMap == null) {
                ifcProduct.eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                if (this.store) {
                    this.databaseSession.store(ifcProduct, this.pid, this.rid);
                }
            } else {
                this.bigMap.get(ifcProduct).eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                ifcProduct.eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                if (this.store) {
                    this.databaseSession.store(this.bigMap.get(ifcProduct), this.pid, this.rid);
                }
            }
        }
    }
}

