/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.eclipse.emf.ecore.EClass;

public class GeometrySimplifier {
    private final Map<EClass, Map<Integer, Set<GeometryData>>> data = new HashMap<EClass, Map<Integer, Set<GeometryData>>>();

    public void add(IfcProduct ifcProduct, GeometryData geometryData) {
        Set<GeometryData> set;
        Map<Integer, Set<GeometryData>> ofType = this.data.get(ifcProduct.eClass());
        if (ofType == null) {
            ofType = new HashMap<Integer, Set<GeometryData>>();
            this.data.put(ifcProduct.eClass(), ofType);
        }
        if ((set = ofType.get(geometryData.getVertices().length)) == null) {
            set = new HashSet<GeometryData>();
            ofType.put(geometryData.getVertices().length, set);
        }
        set.add(geometryData);
    }

    public Set<GeometryData> getMatchingGeometry(IfcProduct ifcProduct, GeometryData geometryData) {
        Set<GeometryData> set;
        HashSet<GeometryData> result = new HashSet<GeometryData>();
        Map<Integer, Set<GeometryData>> ofType = this.data.get(ifcProduct.eClass());
        if (ofType != null && (set = ofType.get(geometryData.getVertices().length)) != null) {
            for (GeometryData d : set) {
                if (d == ifcProduct.getGeometry().getData()) continue;
                if (this.matchExactlyTheSame(geometryData, d)) {
                    result.add(d);
                    continue;
                }
                if (!this.matchSameOrder(geometryData, d)) continue;
                result.add(d);
            }
        }
        return result;
    }

    private boolean matchSameOrder(GeometryData geometryDate, GeometryData d) {
        ByteBuffer bb1 = ByteBuffer.wrap(geometryDate.getVertices());
        bb1.order(ByteOrder.nativeOrder());
        FloatBuffer buffer1 = bb1.asFloatBuffer();
        ByteBuffer bb2 = ByteBuffer.wrap(d.getVertices());
        bb2.order(ByteOrder.nativeOrder());
        FloatBuffer buffer2 = bb2.asFloatBuffer();
        float lastX1 = buffer1.get(0);
        float lastY1 = buffer1.get(1);
        float lastZ1 = buffer1.get(2);
        float lastX2 = buffer2.get(0);
        float lastY2 = buffer2.get(1);
        float lastZ2 = buffer2.get(2);
        for (int i = 3; i < buffer1.capacity(); i += 3) {
            double distance2;
            double distance1 = Math.sqrt(Math.pow(buffer1.get(i) - lastX1, 2.0) + Math.pow(buffer1.get(i + 1) - lastY1, 2.0) + Math.pow(buffer1.get(i + 2) - lastZ1, 2.0));
            double diff = distance1 - (distance2 = Math.sqrt(Math.pow(buffer2.get(i) - lastX2, 2.0) + Math.pow(buffer2.get(i + 1) - lastY2, 2.0) + Math.pow(buffer2.get(i + 2) - lastZ2, 2.0)));
            if (diff > 0.1 || diff < -0.1) {
                return false;
            }
            lastX1 = buffer1.get(i);
            lastY1 = buffer1.get(i + 1);
            lastZ1 = buffer1.get(i + 2);
            lastX2 = buffer2.get(i);
            lastY2 = buffer2.get(i + 1);
            lastZ2 = buffer2.get(i + 2);
        }
        return true;
    }

    private boolean matchExactlyTheSame(GeometryData geometryDate, GeometryData d) {
        ByteBuffer bb1 = ByteBuffer.wrap(geometryDate.getVertices());
        bb1.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer buffer1 = bb1.asFloatBuffer();
        ByteBuffer bb2 = ByteBuffer.wrap(d.getVertices());
        bb2.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer buffer2 = bb2.asFloatBuffer();
        if (buffer1.capacity() != buffer2.capacity()) {
            return false;
        }
        for (int i = 0; i < buffer1.capacity(); ++i) {
            float a = buffer1.get();
            float b = buffer1.get();
            if (b == a) continue;
            return false;
        }
        return true;
    }
}

