/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.PluginManager;
import org.bimserver.shared.exceptions.PluginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDevPluginLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDevPluginLoader.class);

    public static void loadPlugins(PluginManager pluginManager, Path[] pluginDirectories) throws PluginException {
        if (pluginDirectories != null) {
            for (Path pluginDirectory : pluginDirectories) {
                try {
                    pluginManager.loadPluginsFromEclipseProject(pluginDirectory);
                }
                catch (PluginException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    public static PluginManager createPluginManager(Path home) throws PluginException {
        return LocalDevPluginLoader.createPluginManager(home, null);
    }

    public static PluginManager createPluginManager(Path home, Path[] pluginDirectories) throws PluginException {
        if (!Files.exists(home, new LinkOption[0])) {
            try {
                Files.createDirectories(home, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MavenPluginRepository mavenPluginRepository = new MavenPluginRepository(home.resolve("maven"));
        PluginManager pluginManager = new PluginManager(home.resolve("tmp"), home.resolve("plugins"), mavenPluginRepository, System.getProperty("java.class.path"), null, null, null);
        LocalDevPluginLoader.loadPlugins(pluginManager, pluginDirectories);
        pluginManager.initAllLoadedPlugins();
        return pluginManager;
    }
}

