/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.util.ArrayList;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.StateChangeListener;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.migrations.InconsistentModelsException;
import org.bimserver.database.migrations.MigrationException;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.store.ServerInfo;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.ServerState;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerInfoManager.class);
    private BimServer bimServer;
    private final ArrayList<StateChangeListener> stateChangeListeners = new ArrayList();
    private final ServerInfo serverInfo = StoreFactory.eINSTANCE.createServerInfo();

    public void registerStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListeners.add(0, stateChangeListener);
    }

    private void notifyStateChangeListeners(ServerState oldState, ServerState newState) {
        for (StateChangeListener stateChangeListener : this.stateChangeListeners) {
            stateChangeListener.stateChanged(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        try {
            if (this.bimServer.getVersionChecker() != null) {
                this.serverInfo.setVersion(this.bimServer.getSConverter().convertFromSObject(this.bimServer.getVersionChecker().getLocalVersion()));
            }
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        if (this.bimServer.getDatabase().getMigrator().migrationRequired()) {
            this.setServerState(ServerState.MIGRATION_REQUIRED);
            if (this.bimServer.getConfig().isAutoMigrate()) {
                try {
                    this.bimServer.getDatabase().getMigrator().migrate();
                    this.setServerState(ServerState.SETUP);
                }
                catch (InconsistentModelsException | MigrationException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        } else if (this.bimServer.getDatabase().getMigrator().migrationImpossible()) {
            this.setServerState(ServerState.MIGRATION_IMPOSSIBLE);
        } else {
            try (DatabaseSession session = this.bimServer.getDatabase().createSession();){
                boolean adminFound = false;
                ServerSettings settings = this.bimServer.getServerSettingsCache().getServerSettings();
                IfcModelInterface users = session.getAllOfType(StorePackage.eINSTANCE.getUser(), OldQuery.getDefault());
                for (IdEObject idEObject : users.getValues()) {
                    User user;
                    if (!(idEObject instanceof User) || (user = (User)idEObject).getUserType() != UserType.ADMIN) continue;
                    adminFound = true;
                    break;
                }
                if (settings.getSiteAddress().isEmpty() || !adminFound) {
                    this.setServerState(ServerState.NOT_SETUP);
                } else {
                    this.setServerState(ServerState.RUNNING);
                }
            }
        }
    }

    public boolean isAvailable() {
        return this.serverInfo.getErrorMessage() == null && this.serverInfo.getServerState() == ServerState.RUNNING;
    }

    public void setOutOfMemory() {
        this.serverInfo.setErrorMessage("This server is out of memory, more info on how to fix this can be found on <a href=\"http://support.opensourcebim.org/\">support.opensourcebim.org</a>. Or let us handle the hosting stuff and join our VIP hosting solutions at <a href=\"http://vip.bimserver.org/\">vip.bimserver.org</a>.  ");
    }

    public void setServerState(ServerState serverState) {
        ServerState oldState = this.serverInfo.getServerState();
        this.serverInfo.setServerState(serverState);
        LOGGER.info("Changing server state to " + serverState);
        this.notifyStateChangeListeners(oldState, serverState);
    }

    public void setErrorMessage(String message) {
        this.serverInfo.setErrorMessage(message);
    }

    public ServerState getServerState() {
        return this.serverInfo.getServerState();
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void init(BimServer bimServer) {
        this.bimServer = bimServer;
    }
}

