/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.bimserver.LocalDevPluginLoader;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.json.JsonBimServerClientFactory;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.plugins.PluginManager;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.UsernamePasswordAuthenticationInfo;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;

public class TriggerImportDataRemote {
    public static void main(String[] args) {
        try {
            Path home = Paths.get("home", new String[0]);
            Path tmp = home.resolve("tmp");
            PluginManager pluginManager = LocalDevPluginLoader.createPluginManager(home);
            MetaDataManager metaDataManager = new MetaDataManager(tmp);
            pluginManager.setMetaDataManager(metaDataManager);
            try (JsonBimServerClientFactory factory = new JsonBimServerClientFactory(metaDataManager, args[0]);){
                BimServerClient client = factory.create((AuthenticationInfo)new UsernamePasswordAuthenticationInfo(args[1], args[2]));
                client.getServiceInterface().importData(args[3], args[1], args[2], args[4]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        catch (PublicInterfaceNotFoundException e) {
            e.printStackTrace();
        }
    }
}

