/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.emf.PackageMetaData;

public class DownloadDescriptor {
    private static final HashFunction hf = Hashing.md5();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Set<Long> roids;
    private Query query;
    private long serializerOid;
    private String fileNameWithoutExtension;
    private PackageMetaData packageMetaData;
    private String jsonQuery;

    public long getSerializerOid() {
        return this.serializerOid;
    }

    public DownloadDescriptor(PackageMetaData packageMetaData, String jsonQuery, Set<Long> roids, Query query, long serializerOid, String fileNameWithoutExtension) {
        this.packageMetaData = packageMetaData;
        this.jsonQuery = jsonQuery;
        this.roids = roids;
        this.query = query;
        this.serializerOid = serializerOid;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
    }

    public String getCacheKey() {
        Hasher hasher = hf.newHasher();
        hasher.putLong(this.serializerOid);
        for (long roid : this.roids) {
            hasher.putLong(roid);
        }
        if (this.jsonQuery != null) {
            hasher.putString((CharSequence)this.jsonQuery, Charsets.UTF_8);
            HashCode hashcode = hasher.hash();
            return hashcode.toString();
        }
        ObjectNode json = new JsonQueryObjectModelConverter(this.packageMetaData).toJson(this.query);
        try {
            StringWriter stringWriter = new StringWriter();
            OBJECT_MAPPER.writeValue((Writer)stringWriter, (Object)json);
            System.out.println(this.query.toString());
            hasher.putString((CharSequence)stringWriter.toString(), Charsets.UTF_8);
            HashCode hashcode = hasher.hash();
            return hashcode.toString();
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }
}

