/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bimserver.cache.GenericCacheKey;
import org.bimserver.cache.GenericCacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericCache<K extends GenericCacheKey, V extends GenericCacheValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericCache.class);
    private final Map<K, V> cache = new HashMap();

    protected void store(K key, V value) {
        this.cache.put(key, value);
    }

    protected V getValue(K key) {
        return (V)((GenericCacheValue)this.cache.get(key));
    }

    public synchronized void cleanup() {
        Iterator<K> iterator = this.cache.keySet().iterator();
        while (iterator.hasNext()) {
            GenericCacheKey key = (GenericCacheKey)iterator.next();
            if (!((GenericCacheValue)this.cache.get(key)).shouldCleanUp()) continue;
            LOGGER.info("Removing one cache item");
            iterator.remove();
        }
    }
}

