/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import org.bimserver.BimServer;
import org.bimserver.cache.DownloadDescriptor;
import org.bimserver.cache.FileInputStreamDataSource;
import org.bimserver.cache.NewDiskCacheOutputStream;
import org.bimserver.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDiskCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewDiskCacheManager.class);
    private final Path cacheDir;
    private final BimServer bimServer;
    private final Set<String> cachedFileNames = new HashSet<String>();
    private final Map<String, NewDiskCacheOutputStream> busyCaching = new HashMap<String, NewDiskCacheOutputStream>();

    public NewDiskCacheManager(BimServer bimServer, Path cacheDir) {
        this.bimServer = bimServer;
        this.cacheDir = cacheDir;
        try {
            if (!Files.exists(cacheDir, new LinkOption[0])) {
                Files.createDirectory(cacheDir, new FileAttribute[0]);
            }
            for (Path file : PathUtils.list((Path)this.cacheDir)) {
                if (file.getFileName().toString().endsWith(".__tmp")) {
                    Files.delete(file);
                    continue;
                }
                this.cachedFileNames.add(file.getFileName().toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(DownloadDescriptor downloadDescriptor) {
        if (this.isEnabled()) {
            String cacheKey = downloadDescriptor.getCacheKey();
            Object object = this.busyCaching;
            synchronized (object) {
                if (this.busyCaching.containsKey(cacheKey)) {
                    return true;
                }
            }
            object = this.cachedFileNames;
            synchronized (object) {
                return this.cachedFileNames.contains(cacheKey);
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.bimServer.getServerSettingsCache().getServerSettings().getCacheOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource get(DownloadDescriptor downloadDescriptor) {
        if (this.isEnabled()) {
            Path file;
            String cacheKey = downloadDescriptor.getCacheKey();
            NewDiskCacheOutputStream diskCacheOutputStream = null;
            Map<String, NewDiskCacheOutputStream> map = this.busyCaching;
            synchronized (map) {
                diskCacheOutputStream = this.busyCaching.get(cacheKey);
            }
            if (diskCacheOutputStream != null) {
                try {
                    LOGGER.info("Waiting for " + cacheKey);
                    diskCacheOutputStream.waitForFinish();
                }
                catch (InterruptedException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            if (!Files.exists(file = this.cacheDir.resolve(cacheKey), new LinkOption[0])) {
                this.cachedFileNames.remove(file.getFileName().toString());
                this.busyCaching.remove(downloadDescriptor.getCacheKey());
                LOGGER.error("File " + file.getFileName().toString() + " not found in cache");
            } else {
                LOGGER.info("Reading from cache " + cacheKey);
                FileInputStreamDataSource fileInputStreamDataSource = new FileInputStreamDataSource(file);
                fileInputStreamDataSource.setName(downloadDescriptor.getFileNameWithoutExtension());
                return fileInputStreamDataSource;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewDiskCacheOutputStream startCaching(DownloadDescriptor downloadDescriptor) {
        try {
            String cacheKey = downloadDescriptor.getCacheKey();
            LOGGER.info("Start caching " + cacheKey);
            NewDiskCacheOutputStream out = new NewDiskCacheOutputStream(this, this.cacheDir.resolve(cacheKey), downloadDescriptor);
            Map<String, NewDiskCacheOutputStream> map = this.busyCaching;
            synchronized (map) {
                this.busyCaching.put(cacheKey, out);
            }
            return out;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public synchronized Integer cleanup() {
        int removed = 0;
        try {
            for (Path file : PathUtils.list((Path)this.cacheDir)) {
                try {
                    Files.delete(file);
                    ++removed;
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.cachedFileNames.clear();
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneGenerating(NewDiskCacheOutputStream diskCacheOutputStream) {
        Map<String, NewDiskCacheOutputStream> map = this.busyCaching;
        synchronized (map) {
            String cacheKey = diskCacheOutputStream.getDownloadDescriptor().getCacheKey();
            LOGGER.info("Done caching " + cacheKey);
            this.busyCaching.remove(cacheKey);
            this.cachedFileNames.add(cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NewDiskCacheOutputStream diskCacheOutputStream) {
        String cacheKey = diskCacheOutputStream.getDownloadDescriptor().getCacheKey();
        LOGGER.info("Removing cache " + cacheKey);
        this.cachedFileNames.remove(cacheKey);
        Map<String, NewDiskCacheOutputStream> map = this.busyCaching;
        synchronized (map) {
            this.busyCaching.remove(cacheKey);
        }
    }
}

