/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.io.IOException;
import java.util.Collections;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.changes.Transaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

public class AddReferenceChange
implements Change {
    private final long oid;
    private final String referenceName;
    private final long referenceOid;

    public AddReferenceChange(long oid, String referenceName, long referenceOid) {
        this.oid = oid;
        this.referenceName = referenceName;
        this.referenceOid = referenceOid;
    }

    @Override
    public void execute(Transaction transaction) throws UserException, BimserverLockConflictException, BimserverDatabaseException, IOException, QueryException {
        PackageMetaData packageMetaData = transaction.getDatabaseSession().getMetaDataManager().getPackageMetaData(transaction.getProject().getSchema());
        HashMapVirtualObject object = transaction.get(this.oid);
        if (object == null) {
            Query query = new Query(packageMetaData);
            QueryPart queryPart = query.createQueryPart();
            queryPart.addOid(this.oid);
            QueryObjectProvider queryObjectProvider = new QueryObjectProvider(transaction.getDatabaseSession(), transaction.getBimServer(), query, Collections.singleton(transaction.getPreviousRevision().getOid()), packageMetaData);
            object = queryObjectProvider.next();
            transaction.updated(object);
        }
        EClass eClass = transaction.getDatabaseSession().getEClassForOid(this.oid);
        if (object == null) {
            throw new UserException("No object of type \"" + eClass.getName() + "\" with oid " + this.oid + " found in project with pid " + transaction.getProject().getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.referenceName);
        if (eReference == null) {
            throw new UserException("No reference with the name \"" + this.referenceName + "\" found in class \"" + eClass.getName() + "\"");
        }
        if (!eReference.isMany()) {
            throw new UserException("Reference is not of type 'many'");
        }
        EClass eClassForOid = transaction.getDatabaseSession().getEClassForOid(this.referenceOid);
        object.addReference(eReference, eClassForOid, this.referenceOid);
    }
}

