/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.changes.Transaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;

public class RemoveAttributeChange
implements Change {
    private final long oid;
    private final String attributeName;
    private final int index;

    public RemoveAttributeChange(long oid, String attributeName, int index) {
        this.oid = oid;
        this.attributeName = attributeName;
        this.index = index;
    }

    @Override
    public void execute(Transaction transaction) throws UserException, BimserverLockConflictException, BimserverDatabaseException, IOException, QueryException {
        HashMapVirtualObject object;
        PackageMetaData packageMetaData = transaction.getDatabaseSession().getMetaDataManager().getPackageMetaData(transaction.getProject().getSchema());
        if (transaction.getDatabaseSession().getEClassForOid(this.oid).getName().equals("IfcFurnishingElement")) {
            System.out.println();
        }
        if ((object = transaction.get(this.oid)) == null) {
            Query query = new Query(packageMetaData);
            QueryPart queryPart = query.createQueryPart();
            queryPart.addOid(this.oid);
            QueryObjectProvider queryObjectProvider = new QueryObjectProvider(transaction.getDatabaseSession(), transaction.getBimServer(), query, Collections.singleton(transaction.getPreviousRevision().getOid()), packageMetaData);
            object = queryObjectProvider.next();
            transaction.updated(object);
        }
        EClass eClass = transaction.getDatabaseSession().getEClassForOid(this.oid);
        if (object == null) {
            throw new UserException("No object of type \"" + eClass.getName() + "\" with oid " + this.oid + " found in project with pid " + transaction.getProject().getId());
        }
        EAttribute eAttribute = packageMetaData.getEAttribute(eClass.getName(), this.attributeName);
        if (eAttribute == null) {
            throw new UserException("No attribute with the name \"" + this.attributeName + "\" found in class \"" + eClass.getName() + "\"");
        }
        if (eAttribute.isMany()) {
            List list = (List)object.get(eAttribute.getName());
            list.remove(this.index);
        }
    }
}

