/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.io.IOException;
import java.util.Collections;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.changes.Transaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SetReferenceChange
implements Change {
    private final long oid;
    private final String referenceName;
    private final long referenceOid;

    public SetReferenceChange(long oid, String referenceName, long referenceOid) {
        this.oid = oid;
        this.referenceName = referenceName;
        this.referenceOid = referenceOid;
    }

    @Override
    public void execute(Transaction transaction) throws UserException, BimserverLockConflictException, BimserverDatabaseException, IOException, QueryException {
        PackageMetaData packageMetaData = transaction.getDatabaseSession().getMetaDataManager().getPackageMetaData(transaction.getProject().getSchema());
        Query query = new Query(packageMetaData);
        QueryPart queryPart = query.createQueryPart();
        queryPart.addOid(this.oid);
        HashMapVirtualObject object = transaction.get(this.oid);
        if (object == null) {
            QueryObjectProvider queryObjectProvider = new QueryObjectProvider(transaction.getDatabaseSession(), transaction.getBimServer(), query, Collections.singleton(transaction.getPreviousRevision().getOid()), packageMetaData);
            object = queryObjectProvider.next();
            transaction.updated(object);
        }
        EClass eClass = transaction.getDatabaseSession().getEClassForOid(this.oid);
        if (object == null) {
            throw new UserException("No object of type \"" + eClass.getName() + "\" with oid " + this.oid + " found in project with pid " + transaction.getProject().getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.referenceName);
        if (eReference == null) {
            throw new UserException("No reference with the name \"" + this.referenceName + "\" found in class \"" + eClass.getName() + "\"");
        }
        if (eReference.isMany()) {
            throw new UserException("Attribute is not of type 'single'");
        }
        object.setReference((EStructuralFeature)eReference, this.referenceOid, 0);
    }
}

