/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.changes.Transaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc2x3tc1.Tristate;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class SetWrappedAttributeChange
implements Change {
    private Long oid;
    private String attributeName;
    private String type;
    private Object value;

    public SetWrappedAttributeChange(Long oid, String attributeName, String type, Object value) {
        this.oid = oid;
        this.attributeName = attributeName;
        this.type = type;
        this.value = value;
    }

    @Override
    public void execute(Transaction transaction) throws UserException, BimserverLockConflictException, BimserverDatabaseException, IOException, QueryException {
        PackageMetaData packageMetaData = transaction.getDatabaseSession().getMetaDataManager().getPackageMetaData(transaction.getProject().getSchema());
        Query query = new Query(packageMetaData);
        QueryPart queryPart = query.createQueryPart();
        queryPart.addOid(this.oid.longValue());
        HashMapVirtualObject object = transaction.get(this.oid);
        if (object == null) {
            QueryObjectProvider queryObjectProvider = new QueryObjectProvider(transaction.getDatabaseSession(), transaction.getBimServer(), query, Collections.singleton(transaction.getPreviousRevision().getOid()), packageMetaData);
            object = queryObjectProvider.next();
            transaction.updated(object);
        }
        EClass eClass = transaction.getDatabaseSession().getEClassForOid(this.oid);
        if (object == null) {
            throw new UserException("No object of type \"" + eClass.getName() + "\" with oid " + this.oid + " found in project with pid " + transaction.getProject().getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.attributeName);
        if (eReference == null) {
            throw new UserException("No reference with the name \"" + this.attributeName + "\" found in class \"" + eClass.getName() + "\"");
        }
        if (this.value instanceof List && eReference.isMany()) {
            List sourceList = (List)this.value;
            if (!eReference.isMany()) {
                throw new UserException("Attribute is not of type 'many'");
            }
            List list = (List)object.eGet((EStructuralFeature)eReference);
            for (Object o : sourceList) {
                if (eReference.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
                    List asStringList = (List)object.eGet(object.eClass().getEStructuralFeature(this.attributeName + "AsString"));
                    asStringList.add(String.valueOf(o));
                }
                list.add(o);
            }
        } else {
            if (eReference.isMany()) {
                throw new UserException("Attribute is not of type 'single'");
            }
            if (eReference.getEType() instanceof EEnum) {
                EEnum eEnum = (EEnum)eReference.getEType();
                object.set(eReference.getName(), (Object)eEnum.getEEnumLiteral(((String)this.value).toUpperCase()).getInstance());
            } else {
                EClass typeEClass = (EClass)packageMetaData.getEClassifier(this.type);
                if (typeEClass.getEAnnotation("wrapped") == null) {
                    throw new UserException("Not a wrapped type");
                }
                HashMapWrappedVirtualObject wrappedObject = new HashMapWrappedVirtualObject(typeEClass);
                if (typeEClass == Ifc2x3tc1Package.eINSTANCE.getIfcBoolean()) {
                    this.value = (Boolean)this.value == true ? Tristate.TRUE : Tristate.FALSE;
                }
                wrappedObject.set(wrappedObject.eClass().getEStructuralFeature("wrappedValue").getName(), this.value);
                object.set(eReference.getName(), (Object)wrappedObject);
            }
        }
    }
}

