/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.database.DatabaseSession;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.HashMapVirtualObject;

public class Transaction {
    private Map<Long, HashMapVirtualObject> created = new HashMap<Long, HashMapVirtualObject>();
    private Map<Long, HashMapVirtualObject> updated = new HashMap<Long, HashMapVirtualObject>();
    private Map<Long, HashMapVirtualObject> deleted = new HashMap<Long, HashMapVirtualObject>();
    private Revision previousRevision;
    private Project project;
    private ConcreteRevision concreteRevision;
    private DatabaseSession databaseSession;
    private BimServer bimServer;

    public Transaction(BimServer bimServer, Revision previousRevision, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession) {
        this.bimServer = bimServer;
        this.previousRevision = previousRevision;
        this.project = project;
        this.concreteRevision = concreteRevision;
        this.databaseSession = databaseSession;
    }

    public DatabaseSession getDatabaseSession() {
        return this.databaseSession;
    }

    public Project getProject() {
        return this.project;
    }

    public ConcreteRevision getConcreteRevision() {
        return this.concreteRevision;
    }

    public Revision getPreviousRevision() {
        return this.previousRevision;
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public HashMapVirtualObject get(long oid) {
        if (this.created.containsKey(oid)) {
            return this.created.get(oid);
        }
        if (this.updated.containsKey(oid)) {
            return this.updated.get(oid);
        }
        return null;
    }

    public void created(HashMapVirtualObject object) {
        this.created.put(object.getOid(), object);
    }

    public Collection<HashMapVirtualObject> getCreated() {
        return this.created.values();
    }

    public Collection<HashMapVirtualObject> getUpdated() {
        return this.updated.values();
    }

    public void updated(HashMapVirtualObject object) {
        this.updated.put(object.getOid(), object);
    }
}

