/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OldQuery
implements QueryInterface {
    private final int pid;
    private final int rid;
    private final long roid;
    private final ObjectIDM objectIDM;
    private final Deep deep;
    private final int stopRid;
    private PackageMetaData packageMetaData;
    private Map<EClass, Long> oidCounters;
    private static final OldQuery DEFAULT = new OldQuery();

    public static final void setPackageMetaDataForDefaultQuery(PackageMetaData packageMetaData) {
        OldQuery.DEFAULT.packageMetaData = packageMetaData;
    }

    public static OldQuery getDefault() {
        return DEFAULT;
    }

    public void setOidCounters(Map<EClass, Long> oidCounters) {
        this.oidCounters = oidCounters;
    }

    public Map<EClass, Long> getOidCounters() {
        return this.oidCounters;
    }

    private OldQuery() {
        this.packageMetaData = null;
        this.pid = 1;
        this.roid = -1L;
        this.rid = Integer.MAX_VALUE;
        this.stopRid = Integer.MIN_VALUE;
        this.objectIDM = null;
        this.deep = Deep.NO;
    }

    public OldQuery(PackageMetaData packageMetaData, int pid, int rid, long roid) {
        this.packageMetaData = packageMetaData;
        this.pid = pid;
        this.rid = rid;
        this.roid = roid;
        this.stopRid = Integer.MIN_VALUE;
        this.objectIDM = null;
        this.deep = Deep.NO;
    }

    public OldQuery(PackageMetaData packageMetaData, boolean deep) {
        this.packageMetaData = packageMetaData;
        this.pid = 1;
        this.rid = Integer.MAX_VALUE;
        this.roid = -1L;
        this.stopRid = Integer.MIN_VALUE;
        this.objectIDM = null;
        this.deep = deep ? Deep.YES : Deep.NO;
    }

    public OldQuery(PackageMetaData packageMetaData, int pid, int rid, long roid, Deep deep) {
        this.packageMetaData = packageMetaData;
        this.objectIDM = null;
        this.pid = pid;
        this.rid = rid;
        this.roid = roid;
        this.stopRid = Integer.MIN_VALUE;
        this.deep = deep;
    }

    public OldQuery(PackageMetaData packageMetaData, int pid, int rid, long roid, ObjectIDM objectIDM, Deep deep) {
        this.packageMetaData = packageMetaData;
        this.pid = pid;
        this.rid = rid;
        this.roid = roid;
        this.stopRid = Integer.MIN_VALUE;
        this.objectIDM = objectIDM;
        this.deep = deep;
    }

    public OldQuery(PackageMetaData packageMetaData, int pid, int rid, long roid, ObjectIDM objectIDM, Deep deep, int stopRid) {
        this.packageMetaData = packageMetaData;
        this.pid = pid;
        this.rid = rid;
        this.roid = roid;
        this.stopRid = stopRid;
        this.objectIDM = objectIDM;
        this.deep = deep;
    }

    public void updateOidCounters(ConcreteRevision subRevision, DatabaseSession databaseSession) throws BimserverDatabaseException {
        if (subRevision.getOidCounters() != null) {
            HashMap<EClass, Long> oidCounters = new HashMap<EClass, Long>();
            ByteBuffer buffer = ByteBuffer.wrap(subRevision.getOidCounters());
            for (int i = 0; i < buffer.capacity() / 8; ++i) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                long oid = buffer.getLong();
                buffer.order(ByteOrder.BIG_ENDIAN);
                EClass eClass = databaseSession.getEClass((short)oid);
                oidCounters.put(eClass, oid);
            }
            this.setOidCounters(oidCounters);
        }
    }

    public int getStopRid() {
        return this.stopRid;
    }

    public int getPid() {
        return this.pid;
    }

    public int getRid() {
        return this.rid;
    }

    public boolean isDeep() {
        return this.deep == Deep.YES;
    }

    public ObjectIDM getObjectIDM() {
        return this.objectIDM;
    }

    public boolean shouldIncludeClass(EClass eClass) {
        return this.objectIDM == null || this.objectIDM.shouldIncludeClass(eClass, eClass);
    }

    public boolean shouldFollowReference(EClass originalQueryClass, EClass eClass, EStructuralFeature feature) {
        return this.objectIDM == null || this.objectIDM.shouldFollowReference(originalQueryClass, eClass, feature);
    }

    public PackageMetaData getPackageMetaData() {
        return this.packageMetaData;
    }

    public long getRoid() {
        return this.roid;
    }

    public static enum Deep {
        NO,
        YES;

    }
}

