/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractDownloadDatabaseAction<T>
extends BimDatabaseAction<T> {
    private Authorization authorization;
    private BimServer bimServer;

    public AbstractDownloadDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
    }

    protected void checkGeometry(PluginConfiguration serializerPluginConfiguration, PluginManager pluginManager, IfcModelInterface model, Project project, ConcreteRevision concreteRevision, Revision revision) throws BimserverDatabaseException, GeometryGeneratingException {
        boolean needsGeometry = false;
        Plugin plugin = pluginManager.getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
        if (plugin instanceof SerializerPlugin) {
            needsGeometry = ((SerializerPlugin)plugin).needsGeometry();
        }
        if (needsGeometry && revision.isHasGeometry()) {
            EClass productClass = model.getPackageMetaData().getEClass("IfcProduct");
            ArrayList allWithSubTypes = new ArrayList(model.getAllWithSubTypes(productClass));
            for (IdEObject ifcProduct : allWithSubTypes) {
                ifcProduct.forceLoad();
                GeometryInfo geometryInfo = (GeometryInfo)ifcProduct.eGet(productClass.getEStructuralFeature("geometry"));
                if (geometryInfo == null) continue;
                geometryInfo.forceLoad();
                geometryInfo.getData().forceLoad();
                geometryInfo.getTransformation();
                geometryInfo.getMinBounds().forceLoad();
                geometryInfo.getMaxBounds().forceLoad();
            }
        }
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public static int findHighestStopRid(Project project, ConcreteRevision subRevision) {
        int highestStopId = Integer.MIN_VALUE;
        for (ConcreteRevision concreteRevision : project.getConcreteRevisions()) {
            if (concreteRevision.getId() > subRevision.getId() || !concreteRevision.isClear() || concreteRevision.getId() <= highestStopId) continue;
            highestStopId = concreteRevision.getId();
        }
        return highestStopId;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }
}

