/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AddDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.ObjectType;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.Plugin;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddInternalServiceDatabaseAction
extends AddDatabaseAction<InternalServicePluginConfiguration> {
    private Authorization authorization;
    private BimServer bimServer;

    public AddInternalServiceDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, InternalServicePluginConfiguration eService) {
        super(databaseSession, accessMethod, eService);
        this.bimServer = bimServer;
        this.authorization = authorization;
    }

    @Override
    public Long execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = (User)this.getDatabaseSession().get(StorePackage.eINSTANCE.getUser(), this.authorization.getUoid(), (QueryInterface)OldQuery.getDefault());
        InternalServicePluginConfiguration idEObject = (InternalServicePluginConfiguration)this.getIdEObject();
        idEObject.setUserSettings(user.getUserSettings());
        Plugin plugin = this.bimServer.getPluginManager().getPlugin(idEObject.getPluginDescriptor().getIdentifier(), true);
        ObjectType settings = this.bimServer.convertSettings(this.getDatabaseSession(), plugin);
        user.getUserSettings().getServices().add((Object)idEObject);
        idEObject.setSettings(settings);
        this.getDatabaseSession().store((IdEObject)user.getUserSettings());
        return super.execute();
    }
}

