/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddLocalServiceToProjectDatabaseAction
extends BimDatabaseAction<Void> {
    private long poid;
    private Authorization authorization;
    private Service service;
    private long internalServiceOid;

    public AddLocalServiceToProjectDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Service service, long internalServiceOid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.poid = poid;
        this.service = service;
        this.internalServiceOid = internalServiceOid;
        this.authorization = authorization;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = (Project)this.getDatabaseSession().get(StorePackage.eINSTANCE.getProject(), this.poid, (QueryInterface)OldQuery.getDefault());
        User user = (User)this.getDatabaseSession().get(StorePackage.eINSTANCE.getUser(), this.authorization.getUoid(), (QueryInterface)OldQuery.getDefault());
        this.service.setUser(user);
        for (Service existing : project.getServices()) {
            if (!existing.getName().equals(this.service.getName())) continue;
            throw new UserException("Service name \"" + this.service.getName() + "\" already used in this project");
        }
        this.service.setInternalService((InternalServicePluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getInternalServicePluginConfiguration(), this.internalServiceOid, (QueryInterface)OldQuery.getDefault()));
        project.getServices().add((Object)this.service);
        this.service.setProject(project);
        this.getDatabaseSession().store((IdEObject)this.service);
        this.service.setProfileIdentifier("" + this.service.getOid());
        this.getDatabaseSession().store((IdEObject)project);
        return null;
    }
}

