/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Action;
import org.bimserver.models.store.NewService;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.ServiceStatus;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddNewServiceToProjectDatabaseAction
extends BimDatabaseAction<Long> {
    private long poid;
    private NewService service;
    private Action action;

    public AddNewServiceToProjectDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long poid, NewService service, Action action, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.poid = poid;
        this.service = service;
        this.action = action;
    }

    @Override
    public Long execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = (Project)this.getDatabaseSession().get(StorePackage.eINSTANCE.getProject(), this.poid, (QueryInterface)OldQuery.getDefault());
        for (Service existing : project.getServices()) {
            if (!existing.getName().equals(this.service.getName())) continue;
            throw new UserException("Service name \"" + this.service.getName() + "\" already used in this project");
        }
        this.service.setAction(this.action);
        this.service.setStatus(ServiceStatus.NEW);
        if (this.service.getAuthorizationUrl() == null) {
            this.service.setStatus(ServiceStatus.NO_AUTHENTICATION);
        }
        project.getNewServices().add((Object)this.service);
        this.service.setProject(project);
        long serviceOid = this.getDatabaseSession().store((IdEObject)this.service);
        this.getDatabaseSession().store((IdEObject)this.action);
        this.getDatabaseSession().store((IdEObject)project);
        return serviceOid;
    }
}

