/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.NewProjectAdded;
import org.bimserver.models.store.GeoTag;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.SIPrefix;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.notifications.NewProjectNotification;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddProjectDatabaseAction
extends BimDatabaseAction<Project> {
    private final String name;
    private final long parentPoid;
    private final BimServer bimServer;
    private Authorization authorization;
    private String schema;

    public AddProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, String name, String schema, Authorization authorization) {
        this(bimServer, databaseSession, accessMethod, name, -1L, schema, authorization);
        this.schema = schema;
    }

    public AddProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, String projectName, long parentPoid, String schema, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.name = projectName;
        this.parentPoid = parentPoid;
        this.schema = schema;
        this.authorization = authorization;
    }

    @Override
    public Project execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        String trimmedName = this.name.trim();
        if (trimmedName.equals("")) {
            throw new UserException("Invalid project name");
        }
        final Project project = this.getDatabaseSession().create(Project.class);
        Project parentProject = null;
        if (this.parentPoid != -1L) {
            parentProject = this.getProjectByPoid(this.parentPoid);
            project.setParent(parentProject);
            parentProject.getSubProjects().add((Object)project);
            this.getDatabaseSession().store((IdEObject)parentProject);
        }
        if (actingUser.getUserType() != UserType.SYSTEM && this.parentPoid == -1L && actingUser.getUserType() != UserType.ADMIN && !this.bimServer.getServerSettingsCache().getServerSettings().isAllowUsersToCreateTopLevelProjects()) {
            throw new UserException("Only administrators can create new projects");
        }
        if (project.getParent() == null) {
            for (Project project2 : this.getProjectsByName(trimmedName)) {
                if (project2.getParent() != null) continue;
                throw new UserException("Project name must be unique");
            }
        } else {
            Project parent = project.getParent();
            for (Project subProject : parent.getSubProjects()) {
                if (subProject == project || !subProject.getName().equals(trimmedName)) continue;
                throw new UserException("Project name must be unique within parent project (" + parent.getName() + ")");
            }
            project.setGeoTag(parent.getGeoTag());
        }
        if (this.schema == null || !this.schema.equals("ifc2x3tc1") && !this.schema.equals("ifc4")) {
            throw new UserException("Invalid schema, the only 2 valid options are: \"ifc2x3tc1\" and \"ifc4\"");
        }
        NewProjectAdded newProjectAdded = this.getDatabaseSession().create(NewProjectAdded.class);
        newProjectAdded.setDate(new Date());
        newProjectAdded.setExecutor(actingUser);
        newProjectAdded.setParentProject(parentProject);
        newProjectAdded.setProject(project);
        newProjectAdded.setAccessMethod(this.getAccessMethod());
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                AddProjectDatabaseAction.this.bimServer.getNotificationsManager().notify(new NewProjectNotification(AddProjectDatabaseAction.this.bimServer, project.getOid()));
            }
        });
        project.setSendEmailOnNewRevision(this.bimServer.getServerSettingsCache().getServerSettings().isSendEmailOnNewRevision());
        project.setId(Integer.valueOf(this.getDatabaseSession().newPid()));
        project.setName(trimmedName);
        project.setSchema(this.schema);
        project.getHasAuthorizedUsers().add((Object)actingUser);
        project.setCreatedBy(actingUser);
        project.setCreatedDate(new Date());
        project.setDescription("");
        project.setExportLengthMeasurePrefix(SIPrefix.METER);
        if (project.getParent() == null) {
            GeoTag geoTag = this.getDatabaseSession().create(GeoTag.class);
            geoTag.setEnabled(Boolean.valueOf(false));
            project.setGeoTag(geoTag);
            this.getDatabaseSession().store((IdEObject)geoTag);
        } else {
            GeoTag geoTag = parentProject.getGeoTag();
            project.setGeoTag(geoTag);
            this.getDatabaseSession().store((IdEObject)geoTag);
        }
        this.getDatabaseSession().store((IdEObject)project);
        this.getDatabaseSession().store((IdEObject)actingUser);
        this.getDatabaseSession().store((IdEObject)newProjectAdded);
        return project;
    }
}

