/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ExtendedDataSchema;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;

public class AddUserToExtendedDataSchemaDatabaseAction
extends BimDatabaseAction<Void> {
    private final long uoid;
    private final long edsid;

    public AddUserToExtendedDataSchemaDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long uoid, long edsid) {
        super(databaseSession, accessMethod);
        this.uoid = uoid;
        this.edsid = edsid;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = (User)this.getDatabaseSession().get(StorePackage.eINSTANCE.getUser(), this.uoid, (QueryInterface)OldQuery.getDefault());
        if (user == null) {
            throw new UserException("User with oid " + this.uoid + " not found");
        }
        ExtendedDataSchema extendedDataSchema = (ExtendedDataSchema)this.getDatabaseSession().get(StorePackage.eINSTANCE.getExtendedDataSchema(), this.edsid, (QueryInterface)OldQuery.getDefault());
        if (extendedDataSchema == null) {
            throw new UserException("ExtendedDataSchema with oid " + this.edsid + " not found");
        }
        user.getSchemas().add((Object)extendedDataSchema);
        this.getDatabaseSession().store((IdEObject)user);
        this.getDatabaseSession().store((IdEObject)extendedDataSchema);
        return null;
    }
}

