/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.UserAddedToProject;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddUserToProjectDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final long uoid;
    private final long poid;
    private Authorization authorization;
    private BimServer bimServer;

    public AddUserToProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long uoid, long poid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.uoid = uoid;
        this.poid = poid;
    }

    @Override
    public Boolean execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        Project project = this.getProjectByPoid(this.poid);
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        if (this.authorization.hasRightsOnProject(actingUser, project)) {
            User user = this.getUserByUoid(this.uoid);
            project.getHasAuthorizedUsers().add((Object)user);
            user.getHasRightsOn().add((Object)project);
            final UserAddedToProject userAddedToProject = this.getDatabaseSession().create(UserAddedToProject.class);
            userAddedToProject.setExecutor(actingUser);
            userAddedToProject.setDate(new Date());
            userAddedToProject.setAccessMethod(this.getAccessMethod());
            userAddedToProject.setUser(user);
            userAddedToProject.setProject(project);
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    AddUserToProjectDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(userAddedToProject));
                }
            });
            this.getDatabaseSession().store((IdEObject)user);
            this.getDatabaseSession().store((IdEObject)project);
            return true;
        }
        throw new UserException("User has no rights to grant permission on '" + project.getName() + "'");
    }
}

