/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public abstract class BimDatabaseAction<T> {
    private final Set<ProgressListener> progressListeners = new HashSet<ProgressListener>();
    private DatabaseSession databaseSession;
    private final AccessMethod accessMethod;

    public abstract T execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException;

    public BimDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod) {
        this.databaseSession = databaseSession;
        this.accessMethod = accessMethod;
    }

    public AccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public DatabaseSession getDatabaseSession() {
        return this.databaseSession;
    }

    public Project getProjectByPoid(long poid) throws BimserverDatabaseException {
        return (Project)this.databaseSession.get(StorePackage.eINSTANCE.getProject(), poid, (QueryInterface)OldQuery.getDefault());
    }

    public User getUserByUoid(long uoid) throws BimserverDatabaseException {
        return (User)this.databaseSession.get(StorePackage.eINSTANCE.getUser(), uoid, (QueryInterface)OldQuery.getDefault());
    }

    public User getAdminUser() throws BimserverDatabaseException, BimserverLockConflictException {
        return this.getUserByUserName("admin");
    }

    public void setProgress(String state, int progress) {
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.updateProgress(state, progress);
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    public User getSystemUser() throws BimserverDatabaseException, BimserverLockConflictException {
        return this.getUserByUserName("system");
    }

    public Project getProjectById(int pid) throws BimserverDatabaseException, BimserverLockConflictException {
        return (Project)this.databaseSession.query(StorePackage.eINSTANCE.getProject_Id(), pid);
    }

    public List<Project> getProjectsByName(String projectName) throws BimserverDatabaseException, BimserverLockConflictException {
        return this.databaseSession.query(StorePackage.eINSTANCE.getProject_Name(), projectName);
    }

    public User getUserByUserName(String username) throws BimserverDatabaseException, BimserverLockConflictException {
        return (User)this.databaseSession.querySingle(StorePackage.eINSTANCE.getUser_Username(), username, OldQuery.getDefault().getPid(), OldQuery.getDefault().getRid());
    }

    public Revision getRevisionByRoid(long roid) throws BimserverDatabaseException {
        return (Revision)this.databaseSession.get(StorePackage.eINSTANCE.getRevision(), roid, (QueryInterface)OldQuery.getDefault());
    }

    public ConcreteRevision getConcreteRevision(long croid) throws BimserverLockConflictException, BimserverDatabaseException {
        return (ConcreteRevision)this.databaseSession.get(StorePackage.eINSTANCE.getConcreteRevision(), croid, (QueryInterface)OldQuery.getDefault());
    }

    public void setDatabaseSession(DatabaseSession session) {
        this.databaseSession = session;
    }

    public void rollback() throws BimserverDatabaseException {
    }

    public void close() throws IOException {
    }
}

