/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.security.SecureRandom;
import java.util.Date;
import org.bimserver.Authenticator;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.PasswordChanged;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class ChangePasswordDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final String oldPassword;
    private final String newPassword;
    private final long uoid;
    private Authorization authorization;
    private BimServer bimServer;

    public ChangePasswordDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long uoid, String oldPassword, String newPassword, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.uoid = uoid;
        this.oldPassword = oldPassword;
        this.newPassword = newPassword;
        this.authorization = authorization;
    }

    @Override
    public Boolean execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        User user = this.getUserByUoid(this.uoid);
        if (user.getUserType() == UserType.SYSTEM) {
            throw new UserException("Password of system user cannot be changed");
        }
        if (this.uoid == this.authorization.getUoid()) {
            return this.changePassword(this.getDatabaseSession(), actingUser, false);
        }
        if (actingUser.getUserType() == UserType.ADMIN || actingUser.getUserType() == UserType.SYSTEM) {
            return this.changePassword(this.getDatabaseSession(), actingUser, true);
        }
        throw new UserException("Insufficient rights to change the password of this user");
    }

    private boolean changePassword(DatabaseSession databaseSession, User actingUser, boolean skipCheck) throws BimserverLockConflictException, BimserverDatabaseException, UserException {
        User user = this.getUserByUoid(this.uoid);
        Authenticator authenticator = new Authenticator();
        if (skipCheck || authenticator.validate(this.oldPassword, user.getPasswordHash(), user.getPasswordSalt())) {
            byte[] salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            user.setPasswordHash(authenticator.createHash(this.newPassword, salt));
            user.setPasswordSalt(salt);
            final PasswordChanged passwordchanged = databaseSession.create(PasswordChanged.class);
            passwordchanged.setAccessMethod(this.getAccessMethod());
            passwordchanged.setDate(new Date());
            passwordchanged.setExecutor(actingUser);
            passwordchanged.setUser(user);
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    ChangePasswordDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(passwordchanged));
                }
            });
            databaseSession.store((IdEObject)user);
            return true;
        }
        throw new UserException("Old password does not match user's password");
    }
}

