/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.interfaces.objects.SUserType;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.UserChanged;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class ChangeUserTypeDatabaseAction
extends BimDatabaseAction<Void> {
    private final long uoid;
    private final SUserType userType;
    private Authorization authorization;
    private BimServer bimServer;

    public ChangeUserTypeDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long uoid, SUserType userType) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.uoid = uoid;
        this.userType = userType;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        if (actingUser.getUserType() != UserType.ADMIN) {
            throw new UserException("Only admin users can change other user's types");
        }
        User user = this.getUserByUoid(this.uoid);
        if (user.getUserType() == UserType.SYSTEM) {
            throw new UserException("Type of system user cannot be changed");
        }
        user.setUserType(UserType.get((int)this.userType.getOrdinal()));
        final UserChanged userChanged = this.getDatabaseSession().create(UserChanged.class);
        userChanged.setAccessMethod(this.getAccessMethod());
        userChanged.setDate(new Date());
        userChanged.setExecutor(actingUser);
        userChanged.setUser(user);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                ChangeUserTypeDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(userChanged));
            }
        });
        this.getDatabaseSession().store((IdEObject)user);
        return null;
    }
}

