/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GeometryCache;
import org.bimserver.GeometryGenerator;
import org.bimserver.SummaryMap;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.CreateRevisionResult;
import org.bimserver.database.actions.GenericCheckinDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.OidProvider;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.NewRevisionAdded;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.ModelCheckerInstance;
import org.bimserver.models.store.ModelCheckerResult;
import org.bimserver.models.store.NewService;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.notifications.NewRevisionNotification;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.modelchecker.ModelChecker;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckinDatabaseAction
extends GenericCheckinDatabaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckinDatabaseAction.class);
    private final String comment;
    private final long poid;
    private final boolean merge;
    private final BimServer bimServer;
    private ConcreteRevision concreteRevision;
    private Project project;
    private Authorization authorization;
    private final GeometryCache geometryCache = new GeometryCache();
    private String fileName;
    private long fileSize;
    private IfcModelInterface model;
    private long newServiceId;

    public CheckinDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization, IfcModelInterface model, String comment, String fileName, boolean merge, long newServiceId) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.poid = poid;
        this.authorization = authorization;
        this.model = model;
        this.comment = comment;
        this.fileName = fileName;
        this.merge = merge;
        this.newServiceId = newServiceId;
    }

    public IfcModelInterface getModel() {
        return this.model;
    }

    @Override
    public ConcreteRevision execute() throws UserException, BimserverDatabaseException {
        try {
            ExplicitRightsAuthorization explicitRightsAuthorization;
            this.bimServer.getCheckinsInProgress().put(this.poid, this.getActingUid());
            if (this.fileSize == -1L) {
                this.setProgress("Deserializing IFC file...", -1);
            } else {
                this.setProgress("Deserializing IFC file...", 0);
            }
            if (this.getModel().size() == 0L) {
                throw new DeserializeException("Cannot checkin empty model");
            }
            this.authorization.canCheckin(this.poid);
            this.project = this.getProjectByPoid(this.poid);
            int nrConcreteRevisionsBefore = this.project.getConcreteRevisions().size();
            User user = this.getUserByUoid(this.authorization.getUoid());
            if (this.project == null) {
                throw new UserException("Project with poid " + this.poid + " not found");
            }
            if (!this.authorization.hasRightsOnProjectOrSuperProjects(user, this.project)) {
                throw new UserException("User has no rights to checkin models to this project");
            }
            if (!MailSystem.isValidEmailAddress(user.getUsername())) {
                throw new UserException("Users must have a valid e-mail address to checkin");
            }
            if (this.getModel() != null) {
                this.checkCheckSum(this.project, this.getModel());
            }
            long size = 0L;
            if (this.getModel() != null) {
                for (IdEObject idEObject : this.getModel().getValues()) {
                    if (idEObject.eClass().getEAnnotation("hidden") != null) continue;
                    ++size;
                }
                this.getModel().fixInverseMismatches();
            }
            for (ModelCheckerInstance modelCheckerInstance : this.project.getModelCheckers()) {
                ModelChecker modelChecker;
                ModelCheckerResult result;
                ModelCheckerPlugin modelCheckerPlugin;
                if (!modelCheckerInstance.isValid() || (modelCheckerPlugin = this.bimServer.getPluginManager().getModelCheckerPlugin(modelCheckerInstance.getModelCheckerPluginClassName(), true)) == null || (result = (modelChecker = modelCheckerPlugin.createModelChecker(null)).check(this.getModel(), modelCheckerInstance.getCompiled())).isValid()) continue;
                throw new UserException("Model is not valid according to " + modelCheckerInstance.getName());
            }
            CreateRevisionResult result = this.createNewConcreteRevision(this.getDatabaseSession(), size, this.project, user, this.comment.trim());
            this.concreteRevision = result.getConcreteRevision();
            IfcHeader ifcHeader = this.getModel().getModelMetaData().getIfcHeader();
            if (ifcHeader != null) {
                this.getDatabaseSession().store((IdEObject)ifcHeader);
                this.concreteRevision.setIfcHeader(ifcHeader);
            }
            this.project.getConcreteRevisions().add((Object)this.concreteRevision);
            if (this.getModel() != null) {
                this.concreteRevision.setChecksum(this.getModel().getModelMetaData().getChecksum());
            }
            NewRevisionAdded newRevisionAdded = this.getDatabaseSession().create(NewRevisionAdded.class);
            newRevisionAdded.setDate(new Date());
            newRevisionAdded.setExecutor(user);
            final Revision revision = (Revision)this.concreteRevision.getRevisions().get(0);
            if (this.newServiceId != -1L) {
                NewService newService = (NewService)this.getDatabaseSession().get(this.newServiceId, OldQuery.getDefault());
                revision.getServicesLinked().add((Object)newService);
            }
            this.concreteRevision.setSummary(new SummaryMap(this.getModel()).toRevisionSummary(this.getDatabaseSession()));
            if (this.authorization instanceof ExplicitRightsAuthorization && (explicitRightsAuthorization = (ExplicitRightsAuthorization)this.authorization).getSoid() != -1L) {
                Service service = (Service)this.getDatabaseSession().get(explicitRightsAuthorization.getSoid(), OldQuery.getDefault());
                revision.setService(service);
            }
            newRevisionAdded.setRevision(revision);
            newRevisionAdded.setProject(this.project);
            newRevisionAdded.setAccessMethod(this.getAccessMethod());
            Revision lastRevision = this.project.getLastRevision();
            IfcModelInterface ifcModel = null;
            ifcModel = this.merge && lastRevision != null ? this.checkinMerge(lastRevision) : this.getModel();
            ifcModel.fixOidsFlat((OidProvider)this.getDatabaseSession());
            if (this.bimServer.getServerSettingsCache().getServerSettings().isGenerateGeometryOnCheckin()) {
                this.setProgress("Generating Geometry...", -1);
                UserSettings userSettings = user.getUserSettings();
                RenderEnginePluginConfiguration defaultRenderEngine = userSettings.getDefaultRenderEngine();
                if (defaultRenderEngine == null) {
                    throw new UserException("No default render engine has been selected for this user");
                }
                RenderEnginePool pool = this.bimServer.getRenderEnginePools().getRenderEnginePool(this.model.getPackageMetaData().getSchema(), defaultRenderEngine.getPluginDescriptor().getPluginClassName(), new PluginConfiguration(defaultRenderEngine.getSettings()));
                GenerateGeometryResult generateGeometry = new GeometryGenerator(this.bimServer).generateGeometry(pool, this.bimServer.getPluginManager(), this.getDatabaseSession(), ifcModel, this.project.getId(), this.concreteRevision.getId(), true, this.geometryCache);
                this.concreteRevision.setMinBounds(generateGeometry.getMinBoundsAsVector3f());
                this.concreteRevision.setMaxBounds(generateGeometry.getMaxBoundsAsVector3f());
                for (Revision other : this.concreteRevision.getRevisions()) {
                    other.setHasGeometry(true);
                }
            }
            if (nrConcreteRevisionsBefore != 0 && !this.merge) {
                this.concreteRevision.setClear(true);
            }
            Set eClasses = ifcModel.getUsedClasses();
            Map<EClass, Long> startOids = this.getDatabaseSession().getStartOids();
            if (startOids == null) {
                throw new BimserverDatabaseException("No objects changed");
            }
            int s = 0;
            for (EClass eClass : eClasses) {
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                ++s;
            }
            ByteBuffer buffer = ByteBuffer.allocate(8 * s);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (EClass eClass : eClasses) {
                long oid = startOids.get(eClass);
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                buffer.putLong(oid);
            }
            this.concreteRevision.setOidCounters(buffer.array());
            if (ifcModel != null) {
                this.getDatabaseSession().store(ifcModel.getValues(), (int)this.project.getId(), (int)this.concreteRevision.getId());
            }
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    CheckinDatabaseAction.this.bimServer.getCheckinsInProgress().remove(CheckinDatabaseAction.this.poid);
                    CheckinDatabaseAction.this.bimServer.getNotificationsManager().notify(new NewRevisionNotification(CheckinDatabaseAction.this.bimServer, CheckinDatabaseAction.this.project.getOid(), revision.getOid(), CheckinDatabaseAction.this.authorization));
                }
            });
            this.getDatabaseSession().store((IdEObject)this.concreteRevision);
            this.getDatabaseSession().store((IdEObject)this.project);
        }
        catch (Throwable e) {
            if (e instanceof BimserverDatabaseException) {
                throw (BimserverDatabaseException)e;
            }
            if (e instanceof UserException) {
                throw (UserException)e;
            }
            LOGGER.error("", e);
            throw new UserException(e);
        }
        return this.concreteRevision;
    }

    public String getFileName() {
        return this.fileName;
    }

    private IfcModelInterface checkinMerge(Revision lastRevision) throws BimserverLockConflictException, BimserverDatabaseException, UserException {
        return null;
    }

    public ConcreteRevision getConcreteRevision() {
        return this.concreteRevision;
    }

    public Revision getRevision() {
        return (Revision)this.concreteRevision.getRevisions().get(0);
    }

    public long getCroid() {
        return this.concreteRevision.getOid();
    }

    public long getActingUid() {
        return this.authorization.getUoid();
    }

    public long getPoid() {
        return this.poid;
    }
}

