/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.ifc.IfcModel;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class CheckoutDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModel> {
    private final long roid;
    private long serializerOid;

    public CheckoutDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long roid, long serializerOid) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roid = roid;
        this.serializerOid = serializerOid;
    }

    @Override
    public IfcModel execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        Revision revision = this.getRevisionByRoid(this.roid);
        Project project = revision.getProject();
        if (user.getHasRightsOn().contains((Object)project)) {
            for (Checkout checkout : revision.getCheckouts()) {
                if (checkout.getRevision() != revision || checkout.getUser() != user || !checkout.getActive().booleanValue()) continue;
                throw new UserException("This revision has already been checked out by you on " + dateFormat.format(checkout.getDate()));
            }
            for (Checkout checkout : project.getCheckouts()) {
                if (checkout.getUser() != user || !checkout.getActive().booleanValue()) continue;
                checkout.setActive(Boolean.valueOf(false));
                Checkout newCheckout = this.getDatabaseSession().create(Checkout.class);
                newCheckout.setActive(Boolean.valueOf(true));
                newCheckout.setDate(new Date());
                newCheckout.setUser(user);
                newCheckout.setProject(project);
                newCheckout.setRevision(revision);
                this.getDatabaseSession().store((IdEObject)checkout);
                this.getDatabaseSession().store((IdEObject)newCheckout);
                this.getDatabaseSession().store((IdEObject)project);
                return this.realCheckout(project, revision, this.getDatabaseSession(), user);
            }
            Checkout checkout = this.getDatabaseSession().create(Checkout.class);
            checkout.setActive(Boolean.valueOf(true));
            checkout.setDate(new Date());
            checkout.setUser(user);
            checkout.setProject(project);
            checkout.setRevision(revision);
            this.getDatabaseSession().store((IdEObject)checkout);
            this.getDatabaseSession().store((IdEObject)project);
            return this.realCheckout(project, revision, this.getDatabaseSession(), user);
        }
        throw new UserException("Insufficient rights to checkout this project");
    }

    private IfcModel realCheckout(Project project, Revision revision, DatabaseSession databaseSession, User user) throws BimserverLockConflictException, BimserverDatabaseException, UserException {
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        final long totalSize = revision.getSize();
        final AtomicLong total = new AtomicLong();
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        PackageMetaData lastPackageMetaData = null;
        for (ConcreteRevision subRevision : revision.getConcreteRevisions()) {
            PackageMetaData packageMetaData;
            lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(subRevision.getProject().getSchema());
            BasicIfcModel subModel = new BasicIfcModel(packageMetaData, null);
            int highestStopId = CheckoutDatabaseAction.findHighestStopRid(project, subRevision);
            OldQuery query = new OldQuery(packageMetaData, subRevision.getProject().getId(), subRevision.getId(), revision.getOid(), null, OldQuery.Deep.YES, highestStopId);
            subModel.addChangeListener(new IfcModelChangeListener(){

                public void objectAdded(IdEObject idEObject) {
                    total.incrementAndGet();
                    if (totalSize == 0L) {
                        CheckoutDatabaseAction.this.setProgress("Preparing checkout...", 0);
                    } else {
                        CheckoutDatabaseAction.this.setProgress("Preparing checkout...", (int)Math.round(100.0 * (double)total.get() / (double)totalSize));
                    }
                }
            });
            this.getDatabaseSession().getMap((IfcModelInterface)subModel, query);
            try {
                this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, subRevision, revision);
            }
            catch (GeometryGeneratingException e) {
                throw new UserException((Throwable)e);
            }
            subModel.getModelMetaData().setDate(subRevision.getDate());
            ifcModelSet.add((Object)subModel);
        }
        BasicIfcModel ifcModel = new BasicIfcModel(lastPackageMetaData, null);
        if (ifcModelSet.size() > 1) {
            try {
                ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(revision.getProject(), ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            }
            catch (MergeException e) {
                throw new UserException((Throwable)e);
            }
        } else {
            ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
        }
        ifcModel.getModelMetaData().setName(project.getName() + "." + revision.getId());
        ifcModel.getModelMetaData().setRevisionId(project.getRevisions().indexOf((Object)revision) + 1);
        ifcModel.getModelMetaData().setAuthorizedUser(user.getName());
        ifcModel.getModelMetaData().setDate(new Date());
        return (IfcModel)ifcModel;
    }
}

