/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.SummaryMap;
import org.bimserver.changes.Change;
import org.bimserver.changes.CreateObjectChange;
import org.bimserver.changes.RemoveObjectChange;
import org.bimserver.changes.Transaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.actions.CreateRevisionResult;
import org.bimserver.database.actions.GenericCheckinDatabaseAction;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.geometry.GeometryGenerationReport;
import org.bimserver.geometry.StreamingGeometryGenerator;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.NewRevisionAdded;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.VirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.LongTransaction;
import org.bimserver.webservices.NoTransactionException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitTransactionDatabaseAction
extends GenericCheckinDatabaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitTransactionDatabaseAction.class);
    private final String comment;
    private final LongTransaction longTransaction;
    private Revision revision;
    private Authorization authorization;
    private BimServer bimServer;

    public CommitTransactionDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, LongTransaction longTransaction, String comment) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.longTransaction = longTransaction;
        this.comment = comment;
    }

    @Override
    public ConcreteRevision execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = this.getProjectByPoid(this.longTransaction.getPoid());
        User user = this.getUserByUoid(this.authorization.getUoid());
        if (project == null) {
            throw new UserException("Project with poid " + this.longTransaction.getPoid() + " not found");
        }
        if (!this.authorization.hasRightsOnProjectOrSuperProjects(user, project)) {
            throw new UserException("User has no rights to checkin models to this project");
        }
        if (!MailSystem.isValidEmailAddress(user.getUsername())) {
            throw new UserException("Users must have a valid e-mail address to checkin");
        }
        long size = 0L;
        Revision previousRevision = project.getLastRevision();
        if (project.getLastRevision() != null) {
            size += project.getLastRevision().getSize().longValue();
        }
        for (Change change : this.longTransaction.getChanges()) {
            if (change instanceof CreateObjectChange) {
                ++size;
                continue;
            }
            if (!(change instanceof RemoveObjectChange)) continue;
            --size;
        }
        Revision oldLastRevision = project.getLastRevision();
        CreateRevisionResult result = this.createNewConcreteRevision(this.getDatabaseSession(), size, project, user, this.comment.trim());
        ConcreteRevision concreteRevision = result.getConcreteRevision();
        this.revision = (Revision)concreteRevision.getRevisions().get(0);
        project.setLastRevision(this.revision);
        final NewRevisionAdded newRevisionAdded = this.getDatabaseSession().create(NewRevisionAdded.class);
        newRevisionAdded.setDate(new Date());
        newRevisionAdded.setExecutor(user);
        newRevisionAdded.setRevision((Revision)concreteRevision.getRevisions().get(0));
        newRevisionAdded.setProject(project);
        newRevisionAdded.setAccessMethod(this.getAccessMethod());
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(project.getSchema());
        if (oldLastRevision != null) {
            int highestStopId = AbstractDownloadDatabaseAction.findHighestStopRid(project, oldLastRevision.getLastConcreteRevision());
            OldQuery query = new OldQuery(this.longTransaction.getPackageMetaData(), project.getId(), oldLastRevision.getId(), -1L, null, OldQuery.Deep.YES, highestStopId);
            query.updateOidCounters(oldLastRevision.getLastConcreteRevision(), this.getDatabaseSession());
        }
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                CommitTransactionDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(newRevisionAdded));
                try {
                    CommitTransactionDatabaseAction.this.bimServer.getLongTransactionManager().remove(CommitTransactionDatabaseAction.this.longTransaction.getTid());
                }
                catch (NoTransactionException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        });
        SummaryMap summaryMap = null;
        summaryMap = oldLastRevision != null && oldLastRevision.getConcreteRevisions().size() == 1 && ((ConcreteRevision)oldLastRevision.getConcreteRevisions().get(0)).getSummary() != null ? new SummaryMap(packageMetaData, ((ConcreteRevision)oldLastRevision.getConcreteRevisions().get(0)).getSummary()) : new SummaryMap(packageMetaData);
        boolean geometryChanged = true;
        Transaction transaction = new Transaction(this.bimServer, previousRevision, project, concreteRevision, this.getDatabaseSession());
        for (Change change : this.longTransaction.getChanges()) {
            if (!(change instanceof CreateObjectChange)) continue;
            try {
                change.execute(transaction);
            }
            catch (IOException | QueryException e) {
                e.printStackTrace();
            }
            summaryMap.add(((CreateObjectChange)change).geteClass(), 1);
        }
        for (Change change : this.longTransaction.getChanges()) {
            if (change instanceof CreateObjectChange) continue;
            if (change instanceof RemoveObjectChange) {
                summaryMap.remove(((RemoveObjectChange)change).geteClass(), 1);
            }
            try {
                change.execute(transaction);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
        }
        for (HashMapVirtualObject object : transaction.getCreated()) {
            this.getDatabaseSession().save((VirtualObject)object);
        }
        for (HashMapVirtualObject object : transaction.getUpdated()) {
            this.getDatabaseSession().save((VirtualObject)object, concreteRevision.getId());
        }
        if (this.bimServer.getServerSettingsCache().getServerSettings().isGenerateGeometryOnCheckin() && geometryChanged) {
            this.setProgress("Generating Geometry...", -1);
            try {
                GeometryGenerationReport report = new GeometryGenerationReport();
                report.setOriginalDeserializer("No deserializer, low level call");
                report.setOriginalIfcFileName("No file, low level call");
                report.setOriginalIfcFileSize(-1L);
                StreamingGeometryGenerator streamingGeometryGenerator = new StreamingGeometryGenerator(this.bimServer, null, -1L, report);
                int highestStopId = AbstractDownloadDatabaseAction.findHighestStopRid(concreteRevision.getProject(), concreteRevision);
                QueryContext queryContext = new QueryContext((DatabaseInterface)this.getDatabaseSession(), packageMetaData, project.getId().intValue(), concreteRevision.getId().intValue(), ((Revision)concreteRevision.getRevisions().get(0)).getOid(), highestStopId);
                Map<EClass, Long> startOids = this.getDatabaseSession().getStartOids();
                if (startOids == null) {
                    throw new BimserverDatabaseException("No objects changed");
                }
                HashMap<EClass, Long> oidCounters = new HashMap<EClass, Long>();
                for (EClass eClass : packageMetaData.getEClasses()) {
                    if (!startOids.containsKey(eClass)) continue;
                    long oid = startOids.get(eClass);
                    if (DatabaseSession.perRecordVersioning(eClass)) continue;
                    oidCounters.put(eClass, oid);
                }
                queryContext.setOidCounters(oidCounters);
                GenerateGeometryResult generateGeometry = streamingGeometryGenerator.generateGeometry(this.authorization.getUoid(), this.getDatabaseSession(), queryContext);
                concreteRevision.setMinBounds(generateGeometry.getMinBoundsAsVector3f());
                concreteRevision.setMaxBounds(generateGeometry.getMaxBoundsAsVector3f());
            }
            catch (GeometryGeneratingException e) {
                throw new UserException((Throwable)e);
            }
            this.revision.setHasGeometry(true);
        }
        if (oldLastRevision != null) {
            concreteRevision.setOidCounters(((ConcreteRevision)oldLastRevision.getConcreteRevisions().get(0)).getOidCounters());
        }
        concreteRevision.setSummary(summaryMap.toRevisionSummary(this.getDatabaseSession()));
        this.getDatabaseSession().store((IdEObject)concreteRevision);
        this.getDatabaseSession().store((IdEObject)project);
        return concreteRevision;
    }

    public Revision getRevision() {
        return this.revision;
    }
}

