/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.DownloadDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.CompareResult;
import org.bimserver.models.store.CompareType;
import org.bimserver.models.store.ModelComparePluginConfiguration;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.modelcompare.ModelCompare;
import org.bimserver.plugins.modelcompare.ModelCompareException;
import org.bimserver.plugins.modelcompare.ModelComparePlugin;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareDatabaseAction
extends BimDatabaseAction<CompareResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompareDatabaseAction.class);
    private final long roid1;
    private final long roid2;
    private final CompareType sCompareType;
    private final BimServer bimServer;
    private final long mcid;
    private Authorization authorization;
    private long serializerOid;

    public CompareDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long serializerOid, long roid1, long roid2, CompareType sCompareType, long mcid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.serializerOid = serializerOid;
        this.roid1 = roid1;
        this.roid2 = roid2;
        this.sCompareType = sCompareType;
        this.mcid = mcid;
    }

    public ModelCompare getModelCompare() throws ModelCompareException, BimserverDatabaseException {
        Revision revision1 = (Revision)this.getDatabaseSession().get(this.roid1, OldQuery.getDefault());
        Revision revision2 = (Revision)this.getDatabaseSession().get(this.roid2, OldQuery.getDefault());
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(revision1.getProject().getSchema());
        if (revision1.getProject().getSchema().equals(revision2.getProject().getSchema())) {
            ModelComparePluginConfiguration modelCompareObject = (ModelComparePluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getModelComparePluginConfiguration(), this.mcid, (QueryInterface)OldQuery.getDefault());
            if (modelCompareObject != null) {
                ModelComparePlugin modelComparePlugin = this.bimServer.getPluginManager().getModelComparePlugin(modelCompareObject.getPluginDescriptor().getPluginClassName(), true);
                if (modelComparePlugin != null) {
                    ModelCompare modelCompare = modelComparePlugin.createModelCompare(new PluginConfiguration(modelCompareObject.getSettings()), packageMetaData);
                    return modelCompare;
                }
                throw new ModelCompareException("No Model Compare found " + modelCompareObject.getPluginDescriptor().getPluginClassName());
            }
            throw new ModelCompareException("No configured Model Compare found");
        }
        throw new ModelCompareException("Not the same schema");
    }

    @Override
    public CompareResult execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        CompareResult compareResults = null;
        if (compareResults == null) {
            IfcModelInterface model1 = new DownloadDatabaseAction(this.bimServer, this.getDatabaseSession(), this.getAccessMethod(), this.roid1, -1L, this.serializerOid, this.authorization, null).execute();
            IfcModelInterface model2 = new DownloadDatabaseAction(this.bimServer, this.getDatabaseSession(), this.getAccessMethod(), this.roid2, -1L, this.serializerOid, this.authorization, null).execute();
            try {
                compareResults = this.getModelCompare().compare(model1, model2, this.sCompareType);
            }
            catch (ModelCompareException e) {
                LOGGER.error("", (Throwable)e);
                throw new UserException((Throwable)e);
            }
        }
        return compareResults;
    }
}

