/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.SummaryMap;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.RevisionSummary;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class CountDatabaseAction
extends BimDatabaseAction<Integer> {
    private Long roid;
    private String className;
    private BimServer bimServer;

    public CountDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Long roid, String className, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.roid = roid;
        this.className = className;
    }

    @Override
    public Integer execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision revision = this.getRevisionByRoid(this.roid);
        if (revision == null) {
            throw new UserException("Revision with roid " + this.roid + " not found");
        }
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
        Project project = revision.getProject();
        if (revision.getConcreteRevisions().size() == 1 && ((ConcreteRevision)revision.getConcreteRevisions().get(0)).getSummary() != null) {
            RevisionSummary summary = ((ConcreteRevision)revision.getConcreteRevisions().get(0)).getSummary();
            SummaryMap summaryMap = new SummaryMap(packageMetaData, summary);
            if (this.className.equals("[ALL]")) {
                return summaryMap.count();
            }
            return summaryMap.count(this.getDatabaseSession().getEClass(project.getSchema(), this.className));
        }
        return null;
    }
}

