/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DownloadByNewJsonQueryDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Set<Long> roids;
    private int progress;
    private String json;

    public DownloadByNewJsonQueryDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, String json, long serializerOid, Authorization authorization) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.json = json;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        ArrayList<String> projectNames = new ArrayList<String>();
        this.setProgress("Querying database...", -1);
        for (long roid : this.roids) {
            Revision revision = (Revision)this.getDatabaseSession().get(StorePackage.eINSTANCE.getRevision(), roid, (QueryInterface)OldQuery.getDefault());
            projectNames.add(revision.getProject().getName() + "." + revision.getId());
        }
        String name = Joiner.on((String)"-").join(projectNames);
        PackageMetaData lastPackageMetaData = null;
        Project lastProject = null;
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        for (long roid : this.roids) {
            PackageMetaData packageMetaData;
            Revision revision = (Revision)this.getDatabaseSession().get(StorePackage.eINSTANCE.getRevision(), roid, (QueryInterface)OldQuery.getDefault());
            lastProject = revision.getProject();
            lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
            JsonQueryObjectModelConverter converter = new JsonQueryObjectModelConverter(packageMetaData);
            try {
                ObjectNode queryObject = (ObjectNode)OBJECT_MAPPER.readValue(this.json, ObjectNode.class);
                Query query = converter.parseJson("query", queryObject);
                pidRoidMap.put(revision.getProject().getId(), roid);
                ServerIfcModel ifcModel = new ServerIfcModel(packageMetaData, pidRoidMap, this.getDatabaseSession());
                ifcModelSet.add((Object)ifcModel);
                QueryObjectProvider queryObjectProvider = new QueryObjectProvider(this.getDatabaseSession(), this.getBimServer(), query, Collections.singleton(roid), packageMetaData);
                HashMapVirtualObject next = queryObjectProvider.next();
                while (next != null) {
                    IdEObject newObject = packageMetaData.create(next.eClass());
                    IdEObjectImpl idEObjectImpl = (IdEObjectImpl)newObject;
                    idEObjectImpl.setPid(revision.getProject().getId().intValue());
                    idEObjectImpl.setOid(next.getOid());
                    for (EAttribute eAttribute : newObject.eClass().getEAllAttributes()) {
                        Object value = next.eGet((EStructuralFeature)eAttribute);
                        if (eAttribute.isMany()) {
                            List list = (List)value;
                            if (list == null) continue;
                            AbstractEList targetList = (AbstractEList)newObject.eGet((EStructuralFeature)eAttribute);
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Object item = iterator.next();
                                targetList.addUnique(item);
                            }
                            continue;
                        }
                        if (value == null && !eAttribute.isUnsettable()) continue;
                        newObject.eSet((EStructuralFeature)eAttribute, value);
                    }
                    ifcModel.add(next.getOid(), newObject);
                    next = queryObjectProvider.next();
                }
                queryObjectProvider = new QueryObjectProvider(this.getDatabaseSession(), this.getBimServer(), query, Collections.singleton(roid), packageMetaData);
                next = queryObjectProvider.next();
                while (next != null) {
                    IdEObject idEObject = ifcModel.get(next.getOid());
                    if (idEObject.eClass() != next.eClass()) {
                        throw new RuntimeException("Classes not the same");
                    }
                    for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                        if (eReference.isMany()) {
                            List refOids = (List)next.eGet((EStructuralFeature)eReference);
                            AbstractEList list = (AbstractEList)idEObject.eGet((EStructuralFeature)eReference);
                            if (refOids == null) continue;
                            for (Object refOid : refOids) {
                                if (refOid instanceof Long) {
                                    IdEObject ref = ifcModel.get((Long)refOid);
                                    if (ref == null) continue;
                                    list.addUnique((Object)ref);
                                    continue;
                                }
                                if (!(refOid instanceof HashMapWrappedVirtualObject)) continue;
                            }
                            continue;
                        }
                        Object r = next.eGet((EStructuralFeature)eReference);
                        if (r instanceof Long) {
                            long refOid = (Long)r;
                            idEObject.eSet((EStructuralFeature)eReference, (Object)ifcModel.get(refOid));
                            continue;
                        }
                        if (!(r instanceof HashMapWrappedVirtualObject)) continue;
                        HashMapWrappedVirtualObject hashMapWrappedVirtualObject = (HashMapWrappedVirtualObject)r;
                        IdEObject embeddedObject = ifcModel.create(hashMapWrappedVirtualObject.eClass());
                        ((IdEObjectImpl)embeddedObject).setOid(-1L);
                        ((IdEObjectImpl)embeddedObject).setPid(revision.getProject().getId().intValue());
                        idEObject.eSet((EStructuralFeature)eReference, (Object)embeddedObject);
                        for (EAttribute eAttribute : hashMapWrappedVirtualObject.eClass().getEAllAttributes()) {
                            embeddedObject.eSet((EStructuralFeature)eAttribute, hashMapWrappedVirtualObject.eGet((EStructuralFeature)eAttribute));
                        }
                    }
                    next = queryObjectProvider.next();
                }
                ifcModel.getModelMetaData().setName(name);
                ifcModel.getModelMetaData().setRevisionId(1);
                if (this.getAuthorization().getUoid() != -1L) {
                    ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
                }
                ifcModel.getModelMetaData().setDate(new Date());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (IfcModelInterfaceException e) {
                e.printStackTrace();
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, 0, this.getDatabaseSession());
        if (ifcModelSet.size() > 1) {
            this.setProgress("Merging IFC data...", -1);
            try {
                ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(lastProject, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            }
            catch (MergeException e) {
                throw new UserException((Throwable)e);
            }
        } else {
            ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
        }
        ifcModel.getModelMetaData().setName(name);
        if (this.getAuthorization().getUoid() != -1L) {
            ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
        }
        ifcModel.getModelMetaData().setDate(new Date());
        return ifcModel;
    }

    public int getProgress() {
        return this.progress;
    }
}

