/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashMap;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class DownloadByNewQueryDatabaseAction
extends BimDatabaseAction<ObjectProvider> {
    private Authorization authorization;
    private Set<Long> roids;
    private String json;
    private BimServer bimServer;

    public DownloadByNewQueryDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, String json, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.roids = roids;
        this.json = json;
        this.authorization = authorization;
    }

    @Override
    public ObjectProvider execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        User user = this.getUserByUoid(this.authorization.getUoid());
        Project project = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        for (Long roid : this.roids) {
            Revision virtualRevision = this.getRevisionByRoid(roid);
            pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
            project = virtualRevision.getProject();
            try {
                this.authorization.canDownload(roid);
            }
            catch (UserException e) {
                if (!this.authorization.hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                    throw new UserException("User has insufficient rights to download revisions from this project");
                }
                if (this.authorization.hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) continue;
                throw new UserException("User has insufficient rights to download revisions from this project");
            }
        }
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(project.getSchema());
        try {
            return QueryObjectProvider.fromJsonString(this.getDatabaseSession(), this.bimServer, this.json, this.roids, packageMetaData);
        }
        catch (Exception e) {
            throw new UserException((Throwable)e);
        }
    }
}

