/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.actions.DownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.ifc2x3tc1.IfcCharacterStyleSelect;
import org.bimserver.models.ifc2x3tc1.IfcColour;
import org.bimserver.models.ifc2x3tc1.IfcColourOrFactor;
import org.bimserver.models.ifc2x3tc1.IfcColourRgb;
import org.bimserver.models.ifc2x3tc1.IfcCurveStyle;
import org.bimserver.models.ifc2x3tc1.IfcFillAreaStyle;
import org.bimserver.models.ifc2x3tc1.IfcPresentationStyleAssignment;
import org.bimserver.models.ifc2x3tc1.IfcPresentationStyleSelect;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcProductRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcRepresentationItem;
import org.bimserver.models.ifc2x3tc1.IfcStyledItem;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyle;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyleElementSelect;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyleRendering;
import org.bimserver.models.ifc2x3tc1.IfcSymbolStyle;
import org.bimserver.models.ifc2x3tc1.IfcSymbolStyleSelect;
import org.bimserver.models.ifc2x3tc1.IfcTextStyle;
import org.bimserver.models.ifc2x3tc1.IfcTextStyleForDefinedFont;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.CompareContainer;
import org.bimserver.models.store.CompareItem;
import org.bimserver.models.store.CompareResult;
import org.bimserver.models.store.CompareType;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.ModelComparePluginConfiguration;
import org.bimserver.models.store.ObjectAdded;
import org.bimserver.models.store.ObjectModified;
import org.bimserver.models.store.ObjectRemoved;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.modelcompare.ModelCompare;
import org.bimserver.plugins.modelcompare.ModelCompareException;
import org.bimserver.plugins.modelcompare.ModelComparePlugin;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.modelmerger.ModelMerger;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.common.util.EList;

public class DownloadCompareDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private long roid1;
    private long roid2;
    private int progress;
    private final CompareType compareType;
    private final long mcid;

    public DownloadCompareDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, long mcid, CompareType compareType, Authorization authorization, ObjectIDM objectIDM) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.mcid = mcid;
        Iterator<Long> iterator = roids.iterator();
        this.roid1 = iterator.next();
        this.roid2 = iterator.next();
        this.compareType = compareType;
    }

    public ModelCompare getModelCompare() throws ModelCompareException, BimserverDatabaseException {
        Revision revision1 = (Revision)this.getDatabaseSession().get(this.roid1, OldQuery.getDefault());
        Revision revision2 = (Revision)this.getDatabaseSession().get(this.roid2, OldQuery.getDefault());
        PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(revision1.getProject().getSchema());
        if (revision1.getProject().getSchema().equals(revision2.getProject().getSchema())) {
            ModelComparePluginConfiguration modelCompareObject = (ModelComparePluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getModelComparePluginConfiguration(), this.mcid, (QueryInterface)OldQuery.getDefault());
            if (modelCompareObject != null) {
                ModelComparePlugin modelComparePlugin = this.getBimServer().getPluginManager().getModelComparePlugin(modelCompareObject.getPluginDescriptor().getPluginClassName(), true);
                if (modelComparePlugin != null) {
                    ModelCompare modelCompare = modelComparePlugin.createModelCompare(new PluginConfiguration(modelCompareObject.getSettings()), packageMetaData);
                    return modelCompare;
                }
                throw new ModelCompareException("No Model Compare found " + modelCompareObject.getPluginDescriptor().getPluginClassName());
            }
            throw new ModelCompareException("No configured Model Compare found");
        }
        throw new ModelCompareException("Schemas not the same");
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        try {
            Revision revision1 = this.getRevisionByRoid(this.roid1);
            Revision revision2 = this.getRevisionByRoid(this.roid2);
            Project project = revision1.getProject();
            CompareResult compareResults = null;
            IfcModelInterface model1 = new DownloadDatabaseAction(this.getBimServer(), this.getDatabaseSession(), this.getAccessMethod(), this.roid1, -1L, -1L, this.getAuthorization(), null).execute();
            IfcModelInterface model2 = new DownloadDatabaseAction(this.getBimServer(), this.getDatabaseSession(), this.getAccessMethod(), this.roid2, -1L, -1L, this.getAuthorization(), null).execute();
            try {
                compareResults = this.getModelCompare().compare(model1, model2, this.compareType);
            }
            catch (ModelCompareException e) {
                throw new UserException((Throwable)e);
            }
            ModelMerger merger = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid());
            ServerIfcModel mergedModel = new ServerIfcModel(model1.getPackageMetaData(), null, this.getDatabaseSession());
            mergedModel = merger.merge(project, new IfcModelSet(new IfcModelInterface[]{model1, model2}), new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)mergedModel));
            mergedModel.getModelMetaData().setName(project.getName() + "." + revision1.getId() + "." + revision2.getId());
            HashSet<Long> added = new HashSet<Long>();
            HashSet<Long> modified = new HashSet<Long>();
            HashSet<Long> deleted = new HashSet<Long>();
            for (CompareContainer compareContainer : compareResults.getItems()) {
                for (CompareItem compareItem : compareContainer.getItems()) {
                    DataObject dataObject = compareItem.getDataObject();
                    if (compareItem instanceof ObjectAdded) {
                        added.add(dataObject.getOid());
                        continue;
                    }
                    if (compareItem instanceof ObjectModified) {
                        modified.add(dataObject.getOid());
                        continue;
                    }
                    if (!(compareItem instanceof ObjectRemoved)) continue;
                    deleted.add(dataObject.getOid());
                }
            }
            IfcColourRgb red = (IfcColourRgb)mergedModel.createAndAdd(IfcColourRgb.class);
            red.setName("red");
            red.setRed(0.5);
            red.setGreen(0.0);
            red.setBlue(0.0);
            IfcColourRgb green = (IfcColourRgb)mergedModel.createAndAdd(IfcColourRgb.class);
            green.setName("green");
            green.setRed(0.0);
            green.setGreen(0.5);
            green.setBlue(0.0);
            IfcColourRgb blue = (IfcColourRgb)mergedModel.createAndAdd(IfcColourRgb.class);
            blue.setName("blue");
            blue.setRed(0.0);
            blue.setGreen(0.0);
            blue.setBlue(0.5);
            for (IdEObject idEObject : mergedModel.getValues()) {
                if (!(idEObject instanceof IfcProduct)) continue;
                IfcProduct product = (IfcProduct)idEObject;
                IfcColourRgb color = null;
                if (added.contains(product.getOid())) {
                    color = green;
                } else if (deleted.contains(product.getOid())) {
                    color = red;
                } else if (modified.contains(product.getOid())) {
                    color = blue;
                }
                this.setColor((IfcModelInterface)mergedModel, product, color);
            }
            mergedModel.fixOidCounter();
            return mergedModel;
        }
        catch (IfcModelInterfaceException e) {
            throw new UserException((Throwable)e);
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
    }

    private void setColor(IfcModelInterface model, IfcProduct product, IfcColourRgb color) throws IfcModelInterfaceException {
        IfcProductRepresentation representation = product.getRepresentation();
        if (representation != null) {
            EList representations = representation.getRepresentations();
            for (IfcRepresentation ifcRepresentation : representations) {
                EList representationItems = ifcRepresentation.getItems();
                for (IfcRepresentationItem ifcRepresentationItem : representationItems) {
                    EList styledByItems = ifcRepresentationItem.getStyledByItem();
                    if (styledByItems.isEmpty()) {
                        this.createStyledByItems(model, ifcRepresentationItem, ifcRepresentation.getRepresentationIdentifier(), color);
                        continue;
                    }
                    for (IfcStyledItem ifcStyledItem : styledByItems) {
                        EList styledItemStyles = ifcStyledItem.getStyles();
                        if (styledItemStyles.isEmpty()) {
                            this.createStyledItemStyles(model, ifcRepresentation.getRepresentationIdentifier(), ifcStyledItem, color);
                            continue;
                        }
                        for (IfcPresentationStyleAssignment ifcPresentationStyleAssignment : styledItemStyles) {
                            EList presentationStyleAssignmentStyles = ifcPresentationStyleAssignment.getStyles();
                            if (presentationStyleAssignmentStyles.isEmpty()) {
                                this.createPresentationStyleAssignmentStyles(model, ifcRepresentation.getRepresentationIdentifier(), ifcPresentationStyleAssignment, color);
                                continue;
                            }
                            for (IfcPresentationStyleSelect ifcPresentationStyleSelect : presentationStyleAssignmentStyles) {
                                if (ifcPresentationStyleSelect instanceof IfcSurfaceStyle) {
                                    IfcSurfaceStyle ifcSurfaceStyle = (IfcSurfaceStyle)ifcPresentationStyleSelect;
                                    EList surfaceStyleStyles = ifcSurfaceStyle.getStyles();
                                    if (surfaceStyleStyles.isEmpty()) {
                                        this.createSurfaceStyleStyles(model, ifcRepresentation.getRepresentationIdentifier(), ifcSurfaceStyle, color);
                                        continue;
                                    }
                                    boolean renderingFound = false;
                                    for (IfcSurfaceStyleElementSelect ifcSurfaceStyleElementSelect : surfaceStyleStyles) {
                                        if (!(ifcSurfaceStyleElementSelect instanceof IfcSurfaceStyleRendering)) continue;
                                        renderingFound = true;
                                        IfcSurfaceStyleRendering ifcSurfaceStyleRendering = (IfcSurfaceStyleRendering)ifcSurfaceStyleElementSelect;
                                        if (color != null) {
                                            ifcSurfaceStyleRendering.setDiffuseColour((IfcColourOrFactor)color);
                                            ifcSurfaceStyleRendering.setReflectionColour((IfcColourOrFactor)color);
                                            ifcSurfaceStyleRendering.setSpecularColour((IfcColourOrFactor)color);
                                            ifcSurfaceStyleRendering.setSurfaceColour(color);
                                            ifcSurfaceStyleRendering.setTransmissionColour((IfcColourOrFactor)color);
                                            continue;
                                        }
                                        ifcSurfaceStyleRendering.setTransparency(0.5);
                                    }
                                    if (renderingFound) continue;
                                    this.createSurfaceStyleStyles(model, ifcRepresentation.getRepresentationIdentifier(), ifcSurfaceStyle, color);
                                    continue;
                                }
                                if (ifcPresentationStyleSelect instanceof IfcTextStyle) {
                                    IfcTextStyle ifcTextStyle = (IfcTextStyle)ifcPresentationStyleSelect;
                                    IfcCharacterStyleSelect textCharacterAppearance = ifcTextStyle.getTextCharacterAppearance();
                                    if (!(textCharacterAppearance instanceof IfcTextStyleForDefinedFont)) continue;
                                    IfcTextStyleForDefinedFont ifcTextStyleForDefinedFont = (IfcTextStyleForDefinedFont)textCharacterAppearance;
                                    ifcTextStyleForDefinedFont.setColour((IfcColour)color);
                                    continue;
                                }
                                if (ifcPresentationStyleSelect instanceof IfcCurveStyle) {
                                    IfcCurveStyle ifcCurveStyle = (IfcCurveStyle)ifcPresentationStyleSelect;
                                    ifcCurveStyle.setCurveColour((IfcColour)color);
                                    continue;
                                }
                                if (ifcPresentationStyleSelect instanceof IfcFillAreaStyle) {
                                    IfcFillAreaStyle ifcFillAreaStyle = (IfcFillAreaStyle)ifcPresentationStyleSelect;
                                    ifcFillAreaStyle.getFillStyles().clear();
                                    ifcFillAreaStyle.getFillStyles().add((Object)color);
                                    continue;
                                }
                                if (!(ifcPresentationStyleSelect instanceof IfcSymbolStyle)) continue;
                                IfcSymbolStyle ifcSymbolStyle = (IfcSymbolStyle)ifcPresentationStyleSelect;
                                ifcSymbolStyle.setStyleOfSymbol((IfcSymbolStyleSelect)color);
                            }
                        }
                    }
                }
            }
        }
    }

    private void createSurfaceStyleStyles(IfcModelInterface model, String representationIdentifier, IfcSurfaceStyle ifcSurfaceStyle, IfcColourRgb color) throws IfcModelInterfaceException {
        IfcSurfaceStyleRendering ifcSurfaceStyleRendering = (IfcSurfaceStyleRendering)model.create(IfcSurfaceStyleRendering.class);
        ifcSurfaceStyle.getStyles().add((Object)ifcSurfaceStyleRendering);
        if (color != null) {
            ifcSurfaceStyleRendering.setDiffuseColour((IfcColourOrFactor)color);
            ifcSurfaceStyleRendering.setReflectionColour((IfcColourOrFactor)color);
            ifcSurfaceStyleRendering.setSpecularColour((IfcColourOrFactor)color);
            ifcSurfaceStyleRendering.setSurfaceColour(color);
            ifcSurfaceStyleRendering.setTransmissionColour((IfcColourOrFactor)color);
        } else {
            ifcSurfaceStyleRendering.setTransparency(0.5);
        }
    }

    private void createPresentationStyleAssignmentStyles(IfcModelInterface model, String representationIdentifier, IfcPresentationStyleAssignment ifcPresentationStyleAssignment, IfcColourRgb color) throws IfcModelInterfaceException {
        if (representationIdentifier.equals("Body")) {
            IfcSurfaceStyle ifcPresentationStyleSelect = (IfcSurfaceStyle)model.create(IfcSurfaceStyle.class);
            ifcPresentationStyleAssignment.getStyles().add((Object)ifcPresentationStyleSelect);
            this.createSurfaceStyleStyles(model, representationIdentifier, ifcPresentationStyleSelect, color);
        }
    }

    private void createStyledByItems(IfcModelInterface model, IfcRepresentationItem ifcRepresentationItem, String representationIdentifier, IfcColourRgb color) throws IfcModelInterfaceException {
        IfcStyledItem ifcStyledItem = (IfcStyledItem)model.create(IfcStyledItem.class);
        ifcRepresentationItem.getStyledByItem().add((Object)ifcStyledItem);
        this.createStyledItemStyles(model, representationIdentifier, ifcStyledItem, color);
    }

    private void createStyledItemStyles(IfcModelInterface model, String representationIdentifier, IfcStyledItem ifcStyledItem, IfcColourRgb color) throws IfcModelInterfaceException {
        IfcPresentationStyleAssignment ifcPresentationStyleAssignment = (IfcPresentationStyleAssignment)model.create(IfcPresentationStyleAssignment.class);
        ifcStyledItem.getStyles().add((Object)ifcPresentationStyleAssignment);
        this.createPresentationStyleAssignmentStyles(model, representationIdentifier, ifcPresentationStyleAssignment, color);
    }

    public int getProgress() {
        return this.progress;
    }
}

