/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.common.util.EList;

public class DownloadDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final long roid;
    private final ObjectIDM objectIDM;
    private final long ignoreUoid;
    private long serializerOid;

    public DownloadDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid, long ignoreUoid, long serializerOid, Authorization authorization, ObjectIDM objectIDM) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roid = roid;
        this.ignoreUoid = ignoreUoid;
        this.serializerOid = serializerOid;
        this.objectIDM = objectIDM;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        User user;
        Project project;
        PluginConfiguration serializerPluginConfiguration;
        Revision revision;
        block16: {
            revision = this.getRevisionByRoid(this.roid);
            serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
            this.getAuthorization().canDownload(this.roid);
            if (revision == null) {
                throw new UserException("Revision with oid " + this.roid + " not found");
            }
            project = revision.getProject();
            user = this.getUserByUoid(this.getAuthorization().getUoid());
            try {
                this.getAuthorization().canDownload(this.roid);
            }
            catch (UserException e) {
                if (this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) break block16;
                throw new UserException("User has insufficient rights to download revisions from this project");
            }
        }
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        long incrSize = 0L;
        EList concreteRevisions = revision.getConcreteRevisions();
        if (concreteRevisions.size() == 0) {
            throw new ServerException("No concrete revisions in revision");
        }
        for (ConcreteRevision subRevision : concreteRevisions) {
            incrSize += subRevision.getSize().longValue();
        }
        final long totalSize = incrSize;
        final AtomicLong total = new AtomicLong();
        IfcHeader ifcHeader = null;
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        pidRoidMap.put(project.getId(), this.roid);
        for (ConcreteRevision concreteRevision : concreteRevisions) {
            PackageMetaData packageMetaData;
            if (concreteRevision.getUser().getOid() == this.ignoreUoid) continue;
            lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
            ServerIfcModel subModel = new ServerIfcModel(packageMetaData, pidRoidMap, this.getDatabaseSession());
            ifcHeader = concreteRevision.getIfcHeader();
            int highestStopId = DownloadDatabaseAction.findHighestStopRid(project, concreteRevision);
            OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), concreteRevision.getOid(), this.objectIDM, OldQuery.Deep.YES, highestStopId);
            subModel.addChangeListener(new IfcModelChangeListener(){

                public void objectAdded(IdEObject idEObject) {
                    total.incrementAndGet();
                    if (totalSize == 0L) {
                        DownloadDatabaseAction.this.setProgress("Preparing download...", 0);
                    } else {
                        DownloadDatabaseAction.this.setProgress("Preparing download...", (int)Math.round(100.0 * (double)total.get() / (double)totalSize));
                    }
                }
            });
            query.updateOidCounters(concreteRevision, this.getDatabaseSession());
            this.getDatabaseSession().getMap((IfcModelInterface)subModel, query);
            if (serializerPluginConfiguration != null) {
                try {
                    this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, concreteRevision, revision);
                }
                catch (GeometryGeneratingException e) {
                    throw new UserException((Throwable)e);
                }
            }
            subModel.getModelMetaData().setDate(concreteRevision.getDate());
            ifcModelSet.add((Object)subModel);
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, this.getDatabaseSession());
        if (ifcModelSet.size() > 1) {
            try {
                ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(revision.getProject(), ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            }
            catch (MergeException e) {
                throw new UserException((Throwable)e);
            }
        } else {
            ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
        }
        if (ifcHeader != null) {
            ifcHeader.load();
            ifcModel.getModelMetaData().setIfcHeader(ifcHeader);
        }
        ifcModel.getModelMetaData().setName(project.getName() + "." + revision.getId());
        ifcModel.getModelMetaData().setRevisionId(project.getRevisions().indexOf((Object)revision) + 1);
        if (user != null) {
            ifcModel.getModelMetaData().setAuthorizedUser(user.getName());
        }
        ifcModel.getModelMetaData().setDate(revision.getDate());
        if (revision.getProject().getGeoTag() != null) {
            // empty if block
        }
        return ifcModel;
    }
}

