/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class DownloadProjectsDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<Long> roids;
    private final ObjectIDM objectIDM;
    private long serializerOid;

    public DownloadProjectsDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, long serializerOid, Authorization authorization, ObjectIDM objectIDM) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.serializerOid = serializerOid;
        this.objectIDM = objectIDM;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        Project project = null;
        String projectName = "";
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        long incrSize = 0L;
        for (long roid : this.roids) {
            Revision revision = this.getRevisionByRoid(roid);
            for (ConcreteRevision subRevision : revision.getConcreteRevisions()) {
                incrSize += subRevision.getSize().longValue();
            }
        }
        final long totalSize = incrSize;
        final AtomicLong total = new AtomicLong();
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        PackageMetaData lastPackageMetaData = null;
        IfcHeader ifcHeader = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        for (long roid : this.roids) {
            Revision revision = this.getRevisionByRoid(roid);
            project = revision.getProject();
            pidRoidMap.put(project.getId(), roid);
            if (this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                for (ConcreteRevision concreteRevision : revision.getConcreteRevisions()) {
                    PackageMetaData packageMetaData;
                    ifcHeader = concreteRevision.getIfcHeader();
                    lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
                    ServerIfcModel subModel = new ServerIfcModel(packageMetaData, pidRoidMap, this.getDatabaseSession());
                    int highestStopId = DownloadProjectsDatabaseAction.findHighestStopRid(project, concreteRevision);
                    OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), revision.getOid(), this.objectIDM, OldQuery.Deep.YES, highestStopId);
                    subModel.addChangeListener(new IfcModelChangeListener(){

                        public void objectAdded(IdEObject idEObject) {
                            total.incrementAndGet();
                            if (totalSize == 0L) {
                                DownloadProjectsDatabaseAction.this.setProgress("Preparing download...", 0);
                            } else {
                                DownloadProjectsDatabaseAction.this.setProgress("Preparing download...", (int)Math.round(100.0 * (double)total.get() / (double)totalSize));
                            }
                        }
                    });
                    query.updateOidCounters(concreteRevision, this.getDatabaseSession());
                    this.getDatabaseSession().getMap((IfcModelInterface)subModel, query);
                    projectName = projectName + concreteRevision.getProject().getName() + "-";
                    subModel.getModelMetaData().setDate(concreteRevision.getDate());
                    try {
                        this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, concreteRevision, revision);
                    }
                    catch (GeometryGeneratingException e) {
                        throw new UserException((Throwable)e);
                    }
                    ifcModelSet.add((Object)subModel);
                }
                continue;
            }
            throw new UserException("User has no rights on project " + project.getOid());
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, this.getDatabaseSession());
        if (ifcModelSet.size() == 1) {
            ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
        } else {
            try {
                ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            }
            catch (MergeException e) {
                throw new UserException((Throwable)e);
            }
        }
        if (ifcHeader != null) {
            ifcHeader.load();
            ifcModel.getModelMetaData().setIfcHeader(ifcHeader);
        }
        if (projectName.endsWith("-")) {
            projectName = projectName.substring(0, projectName.length() - 1);
        }
        ifcModel.getModelMetaData().setName(projectName);
        return ifcModel;
    }
}

