/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.HasReferenceToCondition;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllCheckoutsByUserDatabaseAction
extends BimDatabaseAction<List<Checkout>> {
    private final long uoid;

    public GetAllCheckoutsByUserDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long uoid) {
        super(databaseSession, accessMethod);
        this.uoid = uoid;
    }

    @Override
    public List<Checkout> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.uoid);
        HasReferenceToCondition condition = new HasReferenceToCondition(StorePackage.eINSTANCE.getCheckout_User(), (IdEObject)user);
        Map<Long, Checkout> query = this.getDatabaseSession().query(condition, Checkout.class, OldQuery.getDefault());
        return CollectionUtils.mapToList(query);
    }
}

