/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.List;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.HasReferenceToCondition;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllCheckoutsOfRevisionDatabaseAction
extends BimDatabaseAction<List<Checkout>> {
    private final long roid;

    public GetAllCheckoutsOfRevisionDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long roid) {
        super(databaseSession, accessMethod);
        this.roid = roid;
    }

    @Override
    public List<Checkout> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision revision = this.getRevisionByRoid(this.roid);
        HasReferenceToCondition condition = new HasReferenceToCondition(StorePackage.eINSTANCE.getCheckout_Revision(), (IdEObject)revision);
        return CollectionUtils.mapToList(this.getDatabaseSession().query(condition, Checkout.class, OldQuery.getDefault()));
    }
}

