/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.GetAllDatabaseAction;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ModelMergerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllModelMergersDatabaseAction
extends GetAllDatabaseAction<ModelMergerPluginConfiguration> {
    private final boolean onlyEnabled;
    private final BimServer bimServer;

    public GetAllModelMergersDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean onlyEnabled) {
        super(databaseSession, accessMethod, ModelMergerPluginConfiguration.class, StorePackage.eINSTANCE.getModelMergerPluginConfiguration());
        this.bimServer = bimServer;
        this.onlyEnabled = onlyEnabled;
    }

    @Override
    public List<ModelMergerPluginConfiguration> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        IsOfTypeCondition condition = new IsOfTypeCondition(StorePackage.eINSTANCE.getModelMergerPluginConfiguration());
        Map<Long, ModelMergerPluginConfiguration> result = this.getDatabaseSession().query(condition, ModelMergerPluginConfiguration.class, OldQuery.getDefault());
        List mapToList = CollectionUtils.mapToList(result);
        if (this.onlyEnabled) {
            Iterator iterator = mapToList.iterator();
            while (iterator.hasNext()) {
                ModelMergerPluginConfiguration modelMerger = (ModelMergerPluginConfiguration)iterator.next();
                if (this.bimServer.getPluginManager().isEnabled(modelMerger.getPluginDescriptor().getPluginClassName()) && modelMerger.getEnabled().booleanValue()) continue;
                iterator.remove();
            }
        }
        return mapToList;
    }
}

