/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.AndCondition;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.conditions.HasReferenceToCondition;
import org.bimserver.database.query.conditions.Not;
import org.bimserver.database.query.literals.EnumLiteral;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllNonAuthorizedUsersOfProjectDatabaseAction
extends BimDatabaseAction<Set<User>> {
    private final long poid;

    public GetAllNonAuthorizedUsersOfProjectDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long poid) {
        super(databaseSession, accessMethod);
        this.poid = poid;
    }

    @Override
    public Set<User> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = this.getProjectByPoid(this.poid);
        if (project == null) {
            throw new UserException("No Project with oid " + this.poid + " found");
        }
        AndCondition condition = new AndCondition(new AndCondition(new Not(new HasReferenceToCondition(StorePackage.eINSTANCE.getUser_HasRightsOn(), (IdEObject)project)), new AttributeCondition(StorePackage.eINSTANCE.getUser_State(), new EnumLiteral((Enum<?>)ObjectState.ACTIVE))), new Not(new AttributeCondition(StorePackage.eINSTANCE.getUser_UserType(), new EnumLiteral((Enum<?>)UserType.SYSTEM))));
        return CollectionUtils.mapToSet(this.getDatabaseSession().query(condition, User.class, OldQuery.getDefault()));
    }
}

